/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.faces.data;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DataCache
implements Serializable {
    private Map cache = new HashMap();

    public void add(int rowIndex, Row row) {
        this.cache.put(new Integer(rowIndex), row);
    }

    public void clear() {
        this.cache.clear();
    }

    public void commit() {
        Integer key;
        ArrayList<Integer> deletedKeys = new ArrayList<Integer>();
        Iterator<Object> keys = this.cache.keySet().iterator();
        while (keys.hasNext()) {
            key = (Integer)keys.next();
            Row row = (Row)this.cache.get(key);
            if (row.isDeleted()) {
                deletedKeys.add(key);
                continue;
            }
            if (!row.isUpdated()) continue;
            row.commit();
        }
        keys = deletedKeys.iterator();
        while (keys.hasNext()) {
            key = (Integer)keys.next();
            this.cache.remove(key);
        }
    }

    public Column createColumn(String schemaName, String tableName, String columnName, int sqlType, Object original) {
        return new Column(schemaName, tableName, columnName, sqlType, original);
    }

    public Column createColumn(String schemaName, String tableName, String columnName, int sqlType, Class javaType, Object original) {
        return new Column(schemaName, tableName, columnName, sqlType, javaType, original);
    }

    public Row createRow(Column[] columns) {
        return new Row(columns);
    }

    public Row get(int rowIndex) {
        return (Row)this.cache.get(new Integer(rowIndex));
    }

    public Iterator iterator() {
        return this.cache.keySet().iterator();
    }

    public void remove(int rowIndex) {
        this.cache.remove(new Integer(rowIndex));
    }

    public void reset() {
        Iterator rows = this.cache.values().iterator();
        while (rows.hasNext()) {
            Row row = (Row)rows.next();
            row.reset();
        }
    }

    private class ColumnSet
    extends AbstractSet {
        private Row row;

        ColumnSet(Row row) {
            this.row = row;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Iterator iterator() {
            return new ColumnIterator(this.row);
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.row.columns.length;
        }
    }

    private class ColumnIterator
    implements Iterator {
        int index = 0;
        private Row row;

        ColumnIterator(Row row) {
            this.row = row;
        }

        public boolean hasNext() {
            return this.index < this.row.columns.length;
        }

        public Object next() {
            return this.row.columns[this.index++];
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class Row
    extends AbstractMap
    implements Serializable {
        private Column[] columns;
        private boolean deleted;

        Row(Column[] columns) {
            this.columns = columns;
            this.deleted = false;
        }

        public void commit() {
            for (int i = 0; i < this.columns.length; ++i) {
                this.columns[i].commit();
            }
            this.setDeleted(false);
        }

        Column[] getColumns() {
            return this.columns;
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public boolean isUpdated() {
            for (int i = 0; i < this.columns.length; ++i) {
                if (!this.columns[i].updated) continue;
                return true;
            }
            return false;
        }

        public void reset() {
            for (int i = 0; i < this.columns.length; ++i) {
                this.columns[i].reset();
            }
            this.setDeleted(false);
        }

        public void setDeleted(boolean deleted) {
            this.deleted = deleted;
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object key) {
            String skey = (String)key;
            for (int i = 0; i < this.columns.length; ++i) {
                if (!skey.equalsIgnoreCase(this.columns[i].getColumnName())) continue;
                return true;
            }
            return false;
        }

        public Set entrySet() {
            return new ColumnSet(this);
        }

        public Object get(Object key) {
            String skey = (String)key;
            for (int i = 0; i < this.columns.length; ++i) {
                if (!skey.equalsIgnoreCase(this.columns[i].getColumnName())) continue;
                return this.columns[i].getValue();
            }
            return null;
        }

        public Object put(Object key, Object value) {
            String skey = (String)key;
            for (int i = 0; i < this.columns.length; ++i) {
                if (!skey.equalsIgnoreCase(this.columns[i].getColumnName())) continue;
                Object previous = this.columns[i].getValue();
                this.columns[i].setValue(value);
                return previous;
            }
            throw new IllegalArgumentException(skey);
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }
    }

    public class Column
    implements Map.Entry,
    Serializable {
        private String key;
        private Object original;
        private int sqlType;
        private Class javaType;
        private Object replacement;
        private String schemaName;
        private String tableName;
        private boolean updated;

        Column(String schemaName, String tableName, String key, int sqlType, Object original) {
            this(schemaName, tableName, key, sqlType, null, original);
        }

        Column(String schemaName, String tableName, String key, int sqlType, Class javaType, Object original) {
            this.schemaName = schemaName;
            this.tableName = tableName;
            this.key = key;
            this.sqlType = sqlType;
            this.javaType = javaType;
            this.original = original;
            this.replacement = null;
            this.updated = false;
        }

        public void commit() {
            if (this.updated) {
                this.original = this.replacement;
                this.replacement = null;
                this.updated = false;
            }
        }

        public String getColumnName() {
            return this.key;
        }

        public Object getKey() {
            return this.key;
        }

        public int getSqlType() {
            return this.sqlType;
        }

        public Class getJavaType() {
            return this.javaType;
        }

        public Object getOriginal() {
            return this.original;
        }

        public Object getReplacement() {
            return this.replacement;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public Object getValue() {
            if (this.updated) {
                return this.replacement;
            }
            return this.original;
        }

        public boolean isUpdated() {
            return this.updated;
        }

        public void reset() {
            this.replacement = null;
            this.updated = false;
        }

        public Object setValue(Object obj) {
            if (this.original == null) {
                if (!(obj == null || obj instanceof String && ((String)obj).length() == 0)) {
                    this.update(obj);
                }
            } else if (obj == null) {
                this.update(obj);
            } else if (!this.original.equals(obj)) {
                this.update(obj);
            }
            return this.original;
        }

        private void update(Object obj) {
            this.replacement = obj;
            this.updated = true;
        }
    }
}

