/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.faces.data;

import com.sun.rave.faces.data.ColumnBinding;
import com.sun.rave.faces.data.RowSetColumnBindable;
import javax.faces.component.UIInput;
import javax.faces.component.ValueHolder;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PhaseId;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;

public class DataValueBinder
implements RowSetColumnBindable,
RowSetListener,
ValueChangeListener {
    protected RowSet rowSet;
    protected ColumnBinding boundColumn;
    protected ValueHolder valueHolder;

    public void setBoundRowSet(RowSet rowSet) {
        this.dataUnbind();
        this.rowSet = rowSet;
        this.dataBind();
    }

    public RowSet getBoundRowSet() {
        return this.rowSet;
    }

    public void setBoundColumn(ColumnBinding column) {
        this.dataUnbind();
        this.boundColumn = column;
        this.dataBind();
    }

    public ColumnBinding getBoundColumn() {
        return this.boundColumn;
    }

    public void setValueHolder(ValueHolder valueHolder) {
        this.dataUnbind();
        this.valueHolder = valueHolder;
        this.dataBind();
    }

    public ValueHolder getValueHolder() {
        return this.valueHolder;
    }

    protected void dataBind() {
        if (this.rowSet != null && this.boundColumn != null && this.valueHolder != null) {
            this.rowSet.addRowSetListener(this);
        }
        if (this.valueHolder instanceof UIInput) {
            ((UIInput)this.valueHolder).addValueChangeListener((ValueChangeListener)this);
        }
    }

    protected void dataUnbind() {
        if (this.rowSet != null && this.boundColumn != null) {
            this.rowSet.removeRowSetListener(this);
        }
        if (this.valueHolder instanceof UIInput) {
            ((UIInput)this.valueHolder).removeValueChangeListener((ValueChangeListener)this);
        }
    }

    public void rowSetChanged(RowSetEvent event) {
        this.cursorMoved(event);
    }

    public void rowChanged(RowSetEvent event) {
        this.cursorMoved(event);
    }

    public void cursorMoved(RowSetEvent event) {
        if (this.rowSet != null && this.boundColumn != null && this.valueHolder != null) {
            try {
                this.valueHolder.setValue(this.rowSet.getObject(this.boundColumn.getColumnName()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.INVOKE_APPLICATION;
    }

    public void processValueChange(ValueChangeEvent event) throws AbortProcessingException {
        if (this.rowSet != null && this.boundColumn != null && this.valueHolder != null) {
            try {
                this.rowSet.updateObject(this.boundColumn.getColumnName(), this.valueHolder.getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

