/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.DataShadow;
import org.openide.loaders.DataTransferSupport;
import org.openide.loaders.FolderChildren;
import org.openide.loaders.FolderComparator;
import org.openide.loaders.FolderList;
import org.openide.loaders.FolderListListener;
import org.openide.loaders.FolderOrder;
import org.openide.loaders.FolderRenameHandler;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.SortModeEditor;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Enumerations;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.NewType;

public class DataFolder
extends MultiDataObject
implements Serializable,
DataObject.Container {
    static final long serialVersionUID = -8244904281845488751L;
    public static final String PROP_CHILDREN = "children";
    public static final String PROP_SORT_MODE = "sortMode";
    static final String EA_SORT_MODE = "OpenIDE-Folder-SortMode";
    static final String EA_ORDER = "OpenIDE-Folder-Order";
    public static final String PROP_ORDER = "order";
    public static final String SET_SORTING = "sorting";
    static final String FOLDER_ICON_BASE = "org/openide/loaders/defaultFolder";
    private static final String ROOT_SHADOW_NAME = "Root";
    private FolderList list;
    private PropertyChangeListener pcl;
    private DataTransferSupport dataTransferSupport = new Paste();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$nodes$Index;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder$Index;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder$SortMode;
    static /* synthetic */ Class class$org$openide$loaders$FolderRenameHandler;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder$Paste;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$java$io$Serializable;

    public DataFolder(FileObject fo) throws DataObjectExistsException, IllegalArgumentException {
        this(fo, DataLoaderPool.getFolderLoader());
    }

    protected DataFolder(FileObject fo, MultiFileLoader loader) throws DataObjectExistsException, IllegalArgumentException {
        this(fo, loader, true);
    }

    protected DataFolder(FileObject fo, DataLoader loader) throws DataObjectExistsException, IllegalArgumentException {
        super(fo, loader);
        this.init(fo, true);
    }

    private DataFolder(FileObject fo, MultiFileLoader loader, boolean attach) throws DataObjectExistsException, IllegalArgumentException {
        super(fo, loader);
        this.init(fo, attach);
    }

    private void init(FileObject fo, boolean attach) throws IllegalArgumentException {
        if (!fo.isFolder()) {
            throw new IllegalArgumentException("Not folder: " + fo);
        }
        this.list = this.reassignList(fo, attach);
    }

    private FolderList reassignList(FileObject fo, boolean attach) {
        FolderList list = FolderList.find(fo, true);
        if (attach) {
            this.pcl = new ListPCL();
            list.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.pcl, (Object)list));
        }
        return list;
    }

    public static DataFolder create(DataFolder folder, String name) throws IOException {
        StringTokenizer tok = new StringTokenizer(name, "/");
        while (tok.hasMoreTokens()) {
            String piece = tok.nextToken();
            if (DataFolder.confirmName(piece)) continue;
            throw new IOException(NbBundle.getMessage((Class)DataFolder.class, (String)"EXC_WrongName", (Object)piece));
        }
        return DataFolder.findFolder(FileUtil.createFolder((FileObject)folder.getPrimaryFile(), (String)name));
    }

    public final synchronized void setSortMode(SortMode mode) throws IOException {
        SortMode old = this.getOrder().getSortMode();
        this.getOrder().setSortMode(mode);
        this.firePropertyChange(PROP_SORT_MODE, old, this.getOrder().getSortMode());
    }

    public final SortMode getSortMode() {
        return this.getOrder().getSortMode();
    }

    public final synchronized void setOrder(DataObject[] arr) throws IOException {
        this.getOrder().setOrder(arr);
        this.firePropertyChange(PROP_ORDER, null, null);
    }

    private FolderOrder getOrder() {
        return FolderOrder.findFor(this.getPrimaryFile());
    }

    public String getName() {
        return this.getPrimaryFile().getNameExt();
    }

    public DataObject[] getChildren() {
        return this.list.getChildren();
    }

    final List getChildrenList() {
        return this.list.getChildrenList();
    }

    final RequestProcessor.Task computeChildrenList(FolderListListener l) {
        return this.list.computeChildrenList(l);
    }

    public Enumeration children() {
        return Collections.enumeration(this.getChildrenList());
    }

    public Enumeration children(boolean rec) {
        if (!rec) {
            return this.children();
        }
        class Processor
        implements Enumerations.Processor {
            private final /* synthetic */ boolean val$rec;

            Processor(boolean val$rec) {
                this.val$rec = val$rec;
            }

            public Object process(Object o, Collection toAdd) {
                DataObject dataObj = (DataObject)o;
                if (this.val$rec && dataObj instanceof DataFolder) {
                    toAdd.addAll(Arrays.asList(((DataFolder)dataObj).getChildren()));
                }
                return o;
            }
        }
        Enumeration en = Enumerations.queue((Enumeration)Enumerations.array((Object[])this.getChildren()), (Enumerations.Processor)new Processor(rec));
        return en;
    }

    protected synchronized Node createNodeDelegate() {
        return new FolderNode();
    }

    Node getClonedNodeDelegate(DataFilter filter) {
        Node n = this.getNodeDelegate();
        Children c = n.getChildren();
        if (c.getClass() == FolderChildren.class) {
            DataFilter f = ((FolderChildren)c).getFilter();
            if (f == DataFilter.ALL) {
                return new ClonedFilter(n, filter);
            }
            if (filter != DataFilter.ALL && filter != f) {
                return new ClonedFilter(n, DataFolder.filterCompose(f, filter));
            }
            return n.cloneNode();
        }
        return n.cloneNode();
    }

    private static DataFilter filterCompose(final DataFilter f1, final DataFilter f2) {
        if (f1.equals(f2)) {
            return f1;
        }
        return new DataFilter(){

            public boolean acceptDataObject(DataObject obj) {
                return f1.acceptDataObject(obj) && f2.acceptDataObject(obj);
            }
        };
    }

    public Children createNodeChildren(DataFilter filter) {
        return new FolderChildren(this, filter);
    }

    public boolean isDeleteAllowed() {
        return this.isRenameAllowed();
    }

    public boolean isCopyAllowed() {
        return true;
    }

    public boolean isMoveAllowed() {
        return this.isRenameAllowed();
    }

    public boolean isRenameAllowed() {
        FileObject fo = this.getPrimaryFile();
        return !fo.isRoot() && !fo.isReadOnly();
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public static DataFolder findFolder(FileObject fo) {
        DataObject d;
        try {
            d = DataObject.find(fo);
        }
        catch (DataObjectNotFoundException e) {
            throw (IllegalArgumentException)new IllegalArgumentException(e.toString()).initCause(e);
        }
        if (!(d instanceof DataFolder)) {
            throw new IllegalArgumentException("Not a DataFolder: " + fo + " (was a " + d.getClass().getName() + ") (file is folder? " + fo.isFolder() + ")");
        }
        return (DataFolder)d;
    }

    public static DataObject.Container findContainer(FileObject fo) {
        if (fo.isFolder()) {
            return FolderList.find(fo, true);
        }
        throw new IllegalArgumentException("Not a folder: " + fo);
    }

    protected DataObject handleCopy(DataFolder f) throws IOException {
        DataFolder.testNesting(this, f);
        Enumeration en = this.children();
        DataFolder newFolder = (DataFolder)super.handleCopy(f);
        while (en.hasMoreElements()) {
            try {
                DataObject obj = (DataObject)en.nextElement();
                if (obj.isCopyAllowed()) {
                    obj.copy(newFolder);
                    continue;
                }
                ErrorManager.getDefault().log(256, NbBundle.getMessage((Class)(class$org$openide$loaders$DataFolder == null ? DataFolder.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder), (String)"FMT_CannotCopyDo", (Object)obj.getName()));
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return newFolder;
    }

    static void testNesting(DataFolder folder, DataFolder targetFolder) throws IOException {
        if (targetFolder.equals(folder)) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException("Error Copying File or Folder"), 16, null, NbBundle.getMessage((Class)DataFolder.class, (String)"EXC_CannotCopyTheSame", (Object)folder.getName()), null, null);
        }
        for (DataFolder testFolder = targetFolder.getFolder(); testFolder != null; testFolder = testFolder.getFolder()) {
            if (!testFolder.equals(folder)) continue;
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException("Error copying file or folder: " + folder.getPrimaryFile() + " cannot be copied to its subfolder " + targetFolder.getPrimaryFile()), 16, null, NbBundle.getMessage((Class)DataFolder.class, (String)"EXC_CannotCopySubfolder", (Object)folder.getName()), null, null);
        }
    }

    protected void handleDelete() throws IOException {
        Enumeration en = this.children();
        try {
            while (en.hasMoreElements()) {
                DataObject obj = (DataObject)en.nextElement();
                if (!obj.isValid()) continue;
                obj.delete();
            }
        }
        catch (IOException iex) {
            FileObject fo = this.getPrimaryFile();
            String message = NbBundle.getMessage((Class)DataFolder.class, (String)"EXC_CannotDelete2", (Object)FileUtil.getFileDisplayName((FileObject)fo));
            ErrorManager.getDefault().annotate((Throwable)iex, message);
            throw iex;
        }
        super.handleDelete();
    }

    protected FileObject handleRename(final String name) throws IOException {
        if (!DataFolder.confirmName(name)) {
            throw new IOException("bad name: " + name){

                public String getLocalizedMessage() {
                    return NbBundle.getMessage((Class)(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = DataFolder.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder), (String)"EXC_WrongName", (Object)name);
                }
            };
        }
        return super.handleRename(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject handleMove(DataFolder df) throws IOException {
        FileObject originalFolder = this.getPrimaryFile();
        FileLock lock = originalFolder.lock();
        List backup = this.saveEntries();
        try {
            FileObject newFile = super.handleMove(df);
            DataFolder newFolder = null;
            boolean dispose = false;
            boolean keepAlive = false;
            int COUNT_DOWN_INIT = 20;
            for (int countDown = 20; countDown >= 0; --countDown) {
                try {
                    MultiFileLoader loader = this.getMultiFileLoader();
                    if (!$assertionsDisabled && !(loader instanceof DataLoaderPool.FolderLoader)) {
                        throw new AssertionError((Object)("This has to be FolderLoader: " + (Object)((Object)loader) + " for " + this.getPrimaryFile()));
                    }
                    DataLoaderPool.FolderLoader folderLoader = (DataLoaderPool.FolderLoader)loader;
                    newFolder = (DataFolder)DataObjectPool.createMultiObject(folderLoader, newFile, this);
                    dispose = false;
                    break;
                }
                catch (DataObjectExistsException e) {
                    newFolder = (DataFolder)e.getDataObject();
                    newFolder.dispose();
                    dispose = true;
                    continue;
                }
            }
            Enumeration en = this.children();
            while (en.hasMoreElements()) {
                try {
                    DataObject obj = (DataObject)en.nextElement();
                    if (obj.isMoveAllowed()) {
                        obj.move(newFolder);
                        continue;
                    }
                    keepAlive = true;
                    ErrorManager.getDefault().log(256, NbBundle.getMessage((Class)(class$org$openide$loaders$DataFolder == null ? DataFolder.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder), (String)"FMT_CannotMoveDo", (Object)obj.getName()));
                }
                catch (IOException ex) {
                    keepAlive = true;
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
            if (keepAlive) {
                this.restoreEntries(backup);
                this.list.refresh();
                FileObject ex = originalFolder;
                return ex;
            }
            try {
                originalFolder.delete(lock);
            }
            catch (IOException e) {
                Throwable t = ErrorManager.getDefault().annotate((Throwable)e, DataObject.getString("EXC_folder_delete_failed"));
                ErrorManager.getDefault().notify(t);
            }
            if (dispose) {
                try {
                    this.setValid(false);
                    newFile = originalFolder;
                }
                catch (PropertyVetoException e) {
                    this.restoreEntries(backup);
                    newFile = this.getPrimaryEntry().getFile();
                }
            } else {
                this.item.changePrimaryFile(newFile);
                newFolder.dispose();
                this.list = this.reassignList(newFile, true);
            }
            FileObject fileObject = newFile;
            return fileObject;
        }
        finally {
            lock.releaseLock();
        }
    }

    protected DataObject handleCreateFromTemplate(DataFolder f, String name) throws IOException {
        DataFolder newFolder = (DataFolder)super.handleCreateFromTemplate(f, name);
        Enumeration en = this.children();
        while (en.hasMoreElements()) {
            try {
                DataObject obj = (DataObject)en.nextElement();
                obj.createFromTemplate(newFolder);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return newFolder;
    }

    protected DataShadow handleCreateShadow(DataFolder f) throws IOException {
        DataFolder.testNesting(this, f);
        String name = this.getPrimaryFile().isRoot() ? FileUtil.findFreeFileName((FileObject)f.getPrimaryFile(), (String)ROOT_SHADOW_NAME, (String)"shadow") : null;
        return DataShadow.create(f, name, this);
    }

    boolean isMergingFolders(FileObject who, FileObject targetFolder) {
        return !targetFolder.equals(who.getParent());
    }

    private static boolean confirmName(String folderName) {
        return folderName.indexOf(47) == -1 && folderName.indexOf(92) == -1;
    }

    static {
        $assertionsDisabled = !DataFolder.class.desiredAssertionStatus();
    }

    private final class ListPCL
    implements PropertyChangeListener {
        ListPCL() {
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if (this == DataFolder.this.pcl) {
                DataFolder.this.firePropertyChange(DataFolder.PROP_CHILDREN, null, null);
            }
        }
    }

    private class Paste
    extends DataTransferSupport {
        Paste() {
        }

        protected DataTransferSupport.PasteTypeExt[] definePasteTypes(int op) {
            switch (op) {
                case 4: {
                    return new DataTransferSupport.PasteTypeExt[]{new DataTransferSupport.PasteTypeExt(this){
                        private final /* synthetic */ Paste this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public String getName() {
                            return DataObject.getString("PT_move");
                        }

                        public HelpCtx getHelpCtx() {
                            return new HelpCtx((class$org$openide$loaders$DataFolder$Paste == null ? (class$org$openide$loaders$DataFolder$Paste = DataFolder.class$("org.openide.loaders.DataFolder$Paste")) : class$org$openide$loaders$DataFolder$Paste).getName() + ".move");
                        }

                        protected boolean handleCanPaste(DataObject obj) {
                            return obj.isMoveAllowed() && !this.isParent(Paste.access$300(this.this$1).getPrimaryFile(), obj.getPrimaryFile());
                        }

                        protected void handlePaste(DataObject obj) throws IOException {
                            obj.move(Paste.access$300(this.this$1));
                        }

                        protected boolean cleanClipboard() {
                            return true;
                        }

                        private boolean isParent(FileObject fo, FileObject parent) {
                            File parentFile = FileUtil.toFile((FileObject)parent);
                            File foFile = FileUtil.toFile((FileObject)fo);
                            if (foFile != null && parentFile != null) {
                                return Paste.access$400(this.this$1, foFile, parentFile);
                            }
                            try {
                                if (fo.getFileSystem() != parent.getFileSystem()) {
                                    return false;
                                }
                            }
                            catch (IOException ex) {
                                // empty catch block
                            }
                            while (fo != null) {
                                if (fo.equals(parent)) {
                                    return true;
                                }
                                fo = fo.getParent();
                            }
                            return false;
                        }
                    }};
                }
                case 1: {
                    return new DataTransferSupport.PasteTypeExt[]{new DataTransferSupport.PasteTypeExt(this){
                        private final /* synthetic */ Paste this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public String getName() {
                            return DataObject.getString("PT_copy");
                        }

                        public HelpCtx getHelpCtx() {
                            return new HelpCtx((class$org$openide$loaders$DataFolder$Paste == null ? (class$org$openide$loaders$DataFolder$Paste = DataFolder.class$("org.openide.loaders.DataFolder$Paste")) : class$org$openide$loaders$DataFolder$Paste).getName() + ".copy");
                        }

                        protected boolean handleCanPaste(DataObject obj) {
                            return obj.isCopyAllowed();
                        }

                        protected void handlePaste(DataObject obj) throws IOException {
                            this.saveIfModified(obj);
                            obj.copy(Paste.access$300(this.this$1));
                        }

                        private void saveIfModified(DataObject obj) throws IOException {
                            SaveCookie sc;
                            if (obj.isModified() && (sc = (SaveCookie)obj.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = DataFolder.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie)) != null) {
                                sc.save();
                            }
                        }
                    }, new DataTransferSupport.PasteTypeExt(this){
                        private final /* synthetic */ Paste this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public String getName() {
                            return DataObject.getString("PT_instantiate");
                        }

                        public HelpCtx getHelpCtx() {
                            return new HelpCtx((class$org$openide$loaders$DataFolder$Paste == null ? (class$org$openide$loaders$DataFolder$Paste = DataFolder.class$("org.openide.loaders.DataFolder$Paste")) : class$org$openide$loaders$DataFolder$Paste).getName() + ".instantiate");
                        }

                        protected boolean handleCanPaste(DataObject obj) {
                            return obj.isTemplate();
                        }

                        protected void handlePaste(DataObject obj) throws IOException {
                            obj.createFromTemplate(Paste.access$300(this.this$1));
                        }
                    }, new DataTransferSupport.PasteTypeExt(this){
                        private final /* synthetic */ Paste this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public String getName() {
                            return DataObject.getString("PT_shadow");
                        }

                        public HelpCtx getHelpCtx() {
                            return new HelpCtx((class$org$openide$loaders$DataFolder$Paste == null ? (class$org$openide$loaders$DataFolder$Paste = DataFolder.class$("org.openide.loaders.DataFolder$Paste")) : class$org$openide$loaders$DataFolder$Paste).getName() + ".shadow");
                        }

                        protected boolean handleCanPaste(DataObject obj) {
                            try {
                                if (!Paste.access$300(this.this$1).getPrimaryFile().getFileSystem().equals(Repository.getDefault().getDefaultFileSystem())) {
                                    return false;
                                }
                            }
                            catch (FileStateInvalidException ex) {
                                return false;
                            }
                            return obj.isShadowAllowed();
                        }

                        protected void handlePaste(DataObject obj) throws IOException {
                            obj.createShadow(Paste.access$300(this.this$1));
                        }
                    }};
                }
            }
            return new DataTransferSupport.PasteTypeExt[0];
        }

        private boolean isParentFile(File foFile, File parentFile) {
            boolean retVal = false;
            while (foFile != null) {
                if (foFile.equals(parentFile)) {
                    retVal = true;
                    break;
                }
                foFile = foFile.getParentFile();
            }
            return retVal;
        }

        protected int[] defineOperations() {
            return new int[]{4, 1};
        }

        protected void handleCreatePasteTypes(Transferable t, List s) {
            Node node = NodeTransfer.node((Transferable)t, (int)1);
            if (node != null) {
                try {
                    InstanceCookie cookie = (InstanceCookie)node.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = DataFolder.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
                    if (cookie != null && (class$java$io$Serializable == null ? (class$java$io$Serializable = DataFolder.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(cookie.instanceClass())) {
                        s.add(new DataTransferSupport.SerializePaste(DataFolder.this, cookie));
                        s.add(new DataTransferSupport.InstantiatePaste(DataFolder.this, cookie));
                    }
                }
                catch (IOException e) {
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
        }

        static /* synthetic */ DataFolder access$300(Paste x0) {
            return x0.DataFolder.this;
        }

        static /* synthetic */ boolean access$400(Paste x0, File x1, File x2) {
            return x0.isParentFile(x1, x2);
        }
    }

    private final class NewFolder
    extends NewType {
        NewFolder() {
        }

        public String getName() {
            return DataObject.getString("CTL_NewFolder");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        public void create() throws IOException {
            NotifyDescriptor.InputLine input = new NotifyDescriptor.InputLine(DataObject.getString("CTL_NewFolderName"), DataObject.getString("CTL_NewFolderTitle"));
            input.setInputText(DataObject.getString("CTL_NewFolderValue"));
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)input) == NotifyDescriptor.OK_OPTION) {
                String folderName = input.getInputText();
                if ("".equals(folderName)) {
                    return;
                }
                FileObject folder = DataFolder.this.getPrimaryFile();
                int dotPos = -1;
                while ((dotPos = folderName.indexOf(".")) != -1) {
                    String subFolder = folderName.substring(0, dotPos);
                    folderName = folderName.substring(dotPos + 1);
                    FileObject existingFile = folder.getFileObject(subFolder);
                    if (existingFile != null) {
                        if (!existingFile.isFolder()) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DataFolder.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject), (String)"MSG_FMT_FileExists", (Object)subFolder, (Object)folder.getName()), 2));
                            return;
                        }
                        folder = existingFile;
                        continue;
                    }
                    if (!DataFolder.confirmName(subFolder)) {
                        throw new IOException(NbBundle.getMessage((Class)(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DataFolder.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject), (String)"EXC_WrongName", (Object)subFolder));
                    }
                    folder = folder.createFolder(subFolder);
                }
                if (!"".equals(folderName)) {
                    FileObject existingFile = folder.getFileObject(folderName);
                    if (existingFile != null) {
                        if (existingFile.isFolder()) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DataFolder.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject), (String)"MSG_FMT_FolderExists", (Object)folderName, (Object)folder.getName()), 1));
                        } else {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DataFolder.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject), (String)"MSG_FMT_FileExists", (Object)folderName, (Object)folder.getName()), 2));
                        }
                        return;
                    }
                    if (!DataFolder.confirmName(folderName)) {
                        throw new IOException(NbBundle.getMessage((Class)(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DataFolder.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject), (String)"EXC_WrongName", (Object)folderName));
                    }
                    DataObject created = DataObject.find(folder.createFolder(folderName));
                    if (created != null) {
                        DataLoaderPool.getDefault().fireOperationEvent(new OperationEvent.Copy(created, DataFolder.this), 6);
                    }
                }
            }
        }
    }

    public class FolderNode
    extends DataNode {
        public FolderNode(Children ch) {
            super(DataFolder.this, ch);
            this.setIconBase(DataFolder.FOLDER_ICON_BASE);
        }

        protected FolderNode() {
            super(DataFolder.this, (Children)new FolderChildren(DataFolder.this));
            this.setIconBase(DataFolder.FOLDER_ICON_BASE);
        }

        public Image getIcon(int type) {
            Image img = null;
            if (type == 1) {
                img = (Image)UIManager.get("Nb.Explorer.Folder.icon");
            }
            if (img == null) {
                img = super.getIcon(type);
            } else {
                try {
                    DataObject obj = this.getDataObject();
                    img = obj.getPrimaryFile().getFileSystem().getStatus().annotateIcon(img, type, obj.files());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            return img;
        }

        public Image getOpenedIcon(int type) {
            Image img = null;
            if (type == 1) {
                img = (Image)UIManager.get("Nb.Explorer.Folder.openedIcon");
            }
            if (img == null) {
                img = super.getOpenedIcon(type);
            } else {
                try {
                    DataObject obj = this.getDataObject();
                    img = obj.getPrimaryFile().getFileSystem().getStatus().annotateIcon(img, type, obj.files());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            return img;
        }

        public Node.Cookie getCookie(Class clazz) {
            if (clazz == (class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = DataFolder.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index) || clazz == (class$org$openide$loaders$DataFolder$Index == null ? (class$org$openide$loaders$DataFolder$Index = DataFolder.class$("org.openide.loaders.DataFolder$Index")) : class$org$openide$loaders$DataFolder$Index)) {
                try {
                    if (DataFolder.this.getPrimaryFile().getFileSystem() == Repository.getDefault().getDefaultFileSystem()) {
                        return new Index(DataFolder.this, (Node)this);
                    }
                }
                catch (FileStateInvalidException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
            return super.getCookie(clazz);
        }

        protected Sheet createSheet() {
            Sheet s = super.createSheet();
            Sheet.Set ss = new Sheet.Set();
            ss.setName(DataFolder.SET_SORTING);
            ss.setDisplayName(DataObject.getString("PROP_sorting"));
            ss.setShortDescription(DataObject.getString("HINT_sorting"));
            PropertySupport.ReadWrite p = new PropertySupport.ReadWrite(this, DataFolder.PROP_SORT_MODE, class$org$openide$loaders$DataFolder$SortMode == null ? (class$org$openide$loaders$DataFolder$SortMode = DataFolder.class$("org.openide.loaders.DataFolder$SortMode")) : class$org$openide$loaders$DataFolder$SortMode, DataObject.getString("PROP_sort"), DataObject.getString("HINT_sort")){
                private final /* synthetic */ FolderNode this$1;
                {
                    this.this$1 = this$1;
                    super(x0, x1, x2, x3);
                }

                public Object getValue() {
                    return FolderNode.access$000(this.this$1).getSortMode();
                }

                public void setValue(Object o) throws InvocationTargetException {
                    try {
                        FolderNode.access$000(this.this$1).setSortMode((SortMode)o);
                    }
                    catch (IOException ex) {
                        throw new InvocationTargetException(ex);
                    }
                }

                public PropertyEditor getPropertyEditor() {
                    return new SortModeEditor();
                }
            };
            ss.put((Node.Property)p);
            s.put(ss);
            return s;
        }

        public Action getPreferredAction() {
            return null;
        }

        public NewType[] getNewTypes() {
            return new NewType[0];
        }

        protected void createPasteTypes(Transferable t, List s) {
            super.createPasteTypes(t, s);
            if (!DataFolder.this.getPrimaryFile().isReadOnly()) {
                DataFolder.this.dataTransferSupport.createPasteTypes(t, s);
            }
        }

        private synchronized FolderRenameHandler getRenameHandler() {
            Lookup.Result renameImplementations = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$loaders$FolderRenameHandler == null ? (class$org$openide$loaders$FolderRenameHandler = DataFolder.class$("org.openide.loaders.FolderRenameHandler")) : class$org$openide$loaders$FolderRenameHandler));
            List handlers = (List)renameImplementations.allInstances();
            if (handlers.size() == 0) {
                return null;
            }
            if (handlers.size() > 1) {
                ErrorManager.getDefault().log(16, "Multiple instances of FolderRenameHandler found in Lookup; only using first one: " + handlers);
            }
            return (FolderRenameHandler)handlers.get(0);
        }

        public void setName(String name) {
            FolderRenameHandler handler = this.getRenameHandler();
            if (handler == null) {
                super.setName(name);
            } else {
                handler.handleRename(DataFolder.this, name);
            }
        }

        static /* synthetic */ DataFolder access$000(FolderNode x0) {
            return x0.DataFolder.this;
        }
    }

    public static abstract class SortMode
    implements Comparator {
        public static final SortMode NONE = new FolderComparator(0);
        public static final SortMode NAMES = new FolderComparator(1);
        public static final SortMode CLASS = new FolderComparator(2);
        public static final SortMode FOLDER_NAMES = new FolderComparator(3);
        public static final SortMode LAST_MODIFIED = new FolderComparator(4);
        public static final SortMode SIZE = new FolderComparator(5);

        void write(FileObject f) throws IOException {
            String x = this == FOLDER_NAMES ? "F" : (this == NAMES ? "N" : (this == CLASS ? "C" : (this == LAST_MODIFIED ? "M" : (this == SIZE ? "S" : "O"))));
            f.setAttribute(DataFolder.EA_SORT_MODE, (Object)x);
        }

        static SortMode read(FileObject f) {
            String x = (String)f.getAttribute(DataFolder.EA_SORT_MODE);
            if (x == null || x.length() != 1) {
                return FOLDER_NAMES;
            }
            char c = x.charAt(0);
            switch (c) {
                case 'N': {
                    return NAMES;
                }
                case 'C': {
                    return CLASS;
                }
                case 'O': {
                    return NONE;
                }
                case 'M': {
                    return LAST_MODIFIED;
                }
                case 'S': {
                    return SIZE;
                }
            }
            return FOLDER_NAMES;
        }
    }

    public static class Index
    extends Index.Support {
        private DataFolder df;
        private Node node;
        private Listener listener;

        public Index(DataFolder df) {
            this(df, df.getNodeDelegate());
        }

        public Index(DataFolder df, Node node) {
            this.df = df;
            this.node = node;
            this.listener = new Listener();
            node.addNodeListener(NodeOp.weakNodeListener((NodeListener)this.listener, (Object)node));
        }

        public int getNodesCount() {
            return this.node.getChildren().getNodesCount();
        }

        public Node[] getNodes() {
            return this.node.getChildren().getNodes();
        }

        public void reorder(int[] perm) {
            DataObject[] curObjs = this.df.getChildren();
            DataObject[] newObjs = new DataObject[curObjs.length];
            Node[] nodes = this.getNodes();
            if (nodes.length != perm.length) {
                throw new IllegalArgumentException("permutation of incorrect length: " + perm.length + " rather than " + nodes.length);
            }
            HashMap<String, DataObject> names = new HashMap<String, DataObject>(2 * curObjs.length);
            for (int i = 0; i < curObjs.length; ++i) {
                Node del = curObjs[i].getNodeDelegate();
                if (del.getCookie(class$org$openide$loaders$DataObject == null ? DataFolder.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject) != null) continue;
                names.put(del.getName(), curObjs[i]);
            }
            DataObject[] dperm = new DataObject[perm.length];
            for (int i = 0; i < perm.length; ++i) {
                DataObject d = (DataObject)nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? DataFolder.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (d == null) {
                    d = (DataObject)names.get(nodes[i].getName());
                }
                if (d == null) {
                    throw new IllegalArgumentException("cannot reorder node with no DataObject: " + nodes[i]);
                }
                if (d.getFolder() != this.df) {
                    throw new IllegalArgumentException("wrong folder for: " + d.getPrimaryFile() + " rather than " + this.df.getPrimaryFile());
                }
                dperm[perm[i]] = d;
            }
            HashSet<DataObject> dpermSet = new HashSet<DataObject>(Arrays.asList(dperm));
            if (dpermSet.size() != dperm.length) {
                throw new IllegalArgumentException("duplicate DataObject's among reordered childen");
            }
            int dindex = 0;
            for (int i = 0; i < curObjs.length; ++i) {
                newObjs[i] = dpermSet.remove(curObjs[i]) ? dperm[dindex++] : curObjs[i];
            }
            try {
                this.df.setOrder(newObjs);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().annotate((Throwable)ex, DataObject.getString("EXC_ReorderFailed"));
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }

        public void reorder() {
            Index.Support.showIndexedCustomizer((org.openide.nodes.Index)this);
        }

        void fireChangeEventAccess() {
            this.fireChangeEvent(new ChangeEvent((Object)this));
        }

        private final class Listener
        implements NodeListener {
            Listener() {
            }

            public void propertyChange(PropertyChangeEvent ev) {
            }

            public void nodeDestroyed(NodeEvent ev) {
            }

            public void childrenReordered(NodeReorderEvent ev) {
                Index.this.fireChangeEventAccess();
            }

            public void childrenRemoved(NodeMemberEvent ev) {
                Index.this.fireChangeEventAccess();
            }

            public void childrenAdded(NodeMemberEvent ev) {
                Index.this.fireChangeEventAccess();
            }
        }
    }

    private static final class ClonedFilterHandle
    implements Node.Handle {
        private static final long serialVersionUID = 24234097765186L;
        private DataObject folder;
        private DataFilter filter;

        public ClonedFilterHandle(DataFolder folder, DataFilter filter) {
            this.folder = folder;
            this.filter = filter;
        }

        public Node getNode() throws IOException {
            if (this.folder instanceof DataFolder) {
                DataFolder dataFolder = (DataFolder)this.folder;
                dataFolder.getClass();
                return dataFolder.new ClonedFilter(this.filter);
            }
            throw new InvalidObjectException(this.folder == null ? "" : this.folder.toString());
        }
    }

    private final class ClonedFilter
    extends FilterNode {
        private DataFilter filter;
        private int hashCode;

        public ClonedFilter(Node n, DataFilter filter) {
            super(n, DataFolder.this.createNodeChildren(filter));
            this.hashCode = -1;
            this.filter = filter;
        }

        public ClonedFilter(DataFilter filter) {
            this(this$0.getNodeDelegate(), filter);
        }

        public Node cloneNode() {
            if (DataFolder.this.isValid()) {
                return new ClonedFilter(this.filter);
            }
            return super.cloneNode();
        }

        public Node.Handle getHandle() {
            return new ClonedFilterHandle(DataFolder.this, this.filter);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o instanceof FolderNode) {
                FolderNode fn = (FolderNode)((Object)o);
                if (fn.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = DataFolder.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder) != DataFolder.this) {
                    return false;
                }
                Children ch = fn.getChildren();
                return ch instanceof FolderChildren && ((FolderChildren)ch).getFilter().equals(this.filter);
            }
            if (o instanceof ClonedFilter) {
                ClonedFilter cf = (ClonedFilter)((Object)o);
                return cf.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = DataFolder.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder) == DataFolder.this && cf.filter.equals(this.filter);
            }
            return false;
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = DataFolder.this.isValid() ? DataFolder.this.getNodeDelegate().hashCode() : super.hashCode();
                if (this.hashCode == -1) {
                    this.hashCode = -2;
                }
            }
            return this.hashCode;
        }
    }
}

