/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLdrActions;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectPool;
import org.openide.nodes.NodeOp;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.io.SafeException;

public abstract class DataLoader
extends SharedClassObject {
    private static final long serialVersionUID = 1986614061378346169L;
    public static final String PROP_DISPLAY_NAME = "displayName";
    public static final String PROP_ACTIONS = "actions";
    private static final String PROP_DEF_ACTIONS = "defaultActions";
    private static final Object ACTION_MANAGER = new Object();
    private static final Object PROP_REPRESENTATION_CLASS = new Object();
    private static final Object PROP_REPRESENTATION_CLASS_NAME = new Object();
    private static final int LOADER_VERSION = 1;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    protected DataLoader(Class representationClass) {
        this.putProperty(PROP_REPRESENTATION_CLASS, representationClass);
        this.putProperty(PROP_REPRESENTATION_CLASS_NAME, representationClass.getName());
        if (representationClass.getClassLoader() == ((Object)((Object)this)).getClass().getClassLoader()) {
            ErrorManager.getDefault().log(16, "Use of super(" + representationClass.getName() + ".class) in " + ((Object)((Object)this)).getClass().getName() + "() should be replaced with super(\"" + representationClass.getName() + "\") to reduce unnecessary class loading");
        }
    }

    protected DataLoader(String representationClassName) {
        this.putProperty(PROP_REPRESENTATION_CLASS_NAME, representationClassName);
    }

    public final Class getRepresentationClass() {
        Class<?> cls = (Class<?>)this.getProperty(PROP_REPRESENTATION_CLASS);
        if (cls != null) {
            return cls;
        }
        String clsName = (String)this.getProperty(PROP_REPRESENTATION_CLASS_NAME);
        try {
            cls = Class.forName(clsName, false, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException(cnfe.toString());
        }
        this.putProperty(PROP_REPRESENTATION_CLASS, cls);
        return cls;
    }

    public final String getRepresentationClassName() {
        return (String)this.getProperty(PROP_REPRESENTATION_CLASS_NAME);
    }

    public final SystemAction[] getActions() {
        Action[] arr = this.getSwingActions();
        ArrayList<Action> list = new ArrayList<Action>();
        for (int i = 0; i < arr.length; ++i) {
            if (!(arr[i] instanceof SystemAction) && arr[i] != null) continue;
            list.add(arr[i]);
        }
        return list.toArray(new SystemAction[0]);
    }

    final Action[] getSwingActions() {
        DataLdrActions mgr = this.findManager();
        if (mgr != null) {
            Object actions;
            try {
                actions = mgr.instanceCreate();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
                actions = null;
            }
            catch (ClassNotFoundException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
                actions = null;
            }
            if (actions == null) {
                return new Action[0];
            }
            return (Action[])actions;
        }
        SystemAction[] actions = (SystemAction[])this.getProperty(PROP_ACTIONS);
        if (actions == null && (actions = (SystemAction[])this.getProperty(PROP_DEF_ACTIONS)) == null) {
            actions = this.defaultActions();
            this.putProperty(PROP_DEF_ACTIONS, actions, false);
        }
        return actions;
    }

    protected String actionsContext() {
        return null;
    }

    protected SystemAction[] defaultActions() {
        SystemAction[] actions = NodeOp.getDefaultActions();
        return actions;
    }

    private final DataLdrActions findManager() {
        Object manager = this.getProperty(ACTION_MANAGER);
        if (manager instanceof Class) {
            return null;
        }
        DataLdrActions mgr = (DataLdrActions)((Object)manager);
        boolean newlyCreated = false;
        if (mgr == null) {
            SystemAction[] arr;
            String context = this.actionsContext();
            if (context == null) {
                this.putProperty(ACTION_MANAGER, ((Object)((Object)this)).getClass());
                return null;
            }
            FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(context);
            if (fo == null) {
                fo = Repository.getDefault().getDefaultFileSystem().getRoot();
                try {
                    fo = FileUtil.createFolder((FileObject)fo, (String)context);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                newlyCreated = true;
            }
            mgr = new DataLdrActions(DataFolder.findFolder(fo), this);
            if (newlyCreated && (arr = this.defaultActions()) != null) {
                mgr.setActions(arr);
            }
            this.putProperty(ACTION_MANAGER, (Object)mgr);
        }
        return mgr;
    }

    final void waitForActions() {
        DataLdrActions mgr = this.findManager();
        if (mgr != null) {
            mgr.waitFinished();
        }
    }

    public final void setActions(SystemAction[] actions) {
        DataLdrActions mgr = this.findManager();
        if (mgr != null) {
            mgr.setActions(actions);
        } else {
            this.putProperty(PROP_ACTIONS, actions, true);
        }
    }

    final void setSwingActions(List arr) {
        this.firePropertyChange(PROP_ACTIONS, null, null);
    }

    public final String getDisplayName() {
        String dn = (String)this.getProperty(PROP_DISPLAY_NAME);
        if (dn != null) {
            return dn;
        }
        dn = this.defaultDisplayName();
        if (dn != null) {
            return dn;
        }
        return this.getRepresentationClassName();
    }

    protected final void setDisplayName(String displayName) {
        this.putProperty(PROP_DISPLAY_NAME, displayName, true);
    }

    protected String defaultDisplayName() {
        return NbBundle.getBundle((Class)DataLoader.class).getString("LBL_loader_display_name");
    }

    public final DataObject findDataObject(FileObject fo, RecognizedFiles recognized) throws IOException {
        try {
            return DataObjectPool.handleFindDataObject(this, fo, recognized);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (RuntimeException e) {
            IOException ioe = new IOException(e.toString());
            ErrorManager.getDefault().annotate((Throwable)ioe, (Throwable)e);
            throw ioe;
        }
    }

    protected abstract DataObject handleFindDataObject(FileObject var1, RecognizedFiles var2) throws IOException;

    public final void markFile(FileObject fo) throws IOException {
        DataLoaderPool.setPreferredLoader(fo, this);
    }

    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeObject(new Integer(1));
        SystemAction[] arr = (SystemAction[])this.getProperty(PROP_ACTIONS);
        if (arr == null) {
            oo.writeObject(null);
        } else {
            LinkedList<String> names = new LinkedList<String>();
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i] == null) {
                    names.add(null);
                    continue;
                }
                names.add(arr[i].getClass().getName());
            }
            oo.writeObject(names.toArray());
        }
        String dn = (String)this.getProperty(PROP_DISPLAY_NAME);
        if (dn == null) {
            dn = "";
        }
        oo.writeUTF(dn);
    }

    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        String displayName;
        ClassNotFoundException main = null;
        int version = 0;
        Object first = oi.readObject();
        if (first instanceof Integer) {
            version = (Integer)first;
            first = oi.readObject();
        }
        Object[] arr = (Object[])first;
        boolean isdefault = true;
        SystemAction[] defactions = this.getActions();
        if (version > 0 || version == 0 && arr.length != defactions.length) {
            isdefault = false;
        }
        if (arr != null) {
            ArrayList<SystemAction> ll = new ArrayList<SystemAction>(arr.length);
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i] == null) {
                    ll.add(null);
                    if (version != 0 || !isdefault || defactions[i] == null) continue;
                    isdefault = false;
                    continue;
                }
                try {
                    ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? DataLoader.class$("java.lang.ClassLoader") : class$java$lang$ClassLoader);
                    if (loader == null) {
                        loader = ((Object)((Object)this)).getClass().getClassLoader();
                    }
                    Class<?> c = Class.forName(Utilities.translate((String)((String)arr[i])), false, loader);
                    SystemAction ac = SystemAction.get(c);
                    ll.add(ac);
                    if (version != 0 || !isdefault || defactions[i].equals((Object)ac)) continue;
                    isdefault = false;
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    ErrorManager.getDefault().annotate((Throwable)ex, 1, null, null, null, null);
                    if (main == null) {
                        main = ex;
                        continue;
                    }
                    ErrorManager.getDefault().annotate((Throwable)main, (Throwable)ex);
                }
            }
            if (main == null && !isdefault) {
                this.setActions(ll.toArray(new SystemAction[ll.size()]));
            }
        }
        if ((displayName = oi.readUTF()).equals("") || version == 0 && displayName.equals(this.defaultDisplayName())) {
            displayName = null;
        }
        this.setDisplayName(displayName);
        if (main != null) {
            SafeException se = new SafeException(main);
            String message = NbBundle.getMessage((Class)DataLoader.class, (String)"EXC_missing_actions_in_loader", (Object)this.getDisplayName());
            ErrorManager.getDefault().annotate((Throwable)se, message);
            throw se;
        }
    }

    protected boolean clearSharedData() {
        return false;
    }

    public static DataLoader getLoader(Class loaderClass) {
        return (DataLoader)DataLoader.findObject((Class)loaderClass, (boolean)true);
    }

    public static interface RecognizedFiles {
        public void markRecognized(FileObject var1);
    }
}

