/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.DefaultES;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class DefaultDataObject
extends MultiDataObject
implements OpenCookie {
    static final long serialVersionUID = -4936309935667095746L;

    DefaultDataObject(FileObject fo, MultiFileLoader loader) throws DataObjectExistsException {
        super(fo, loader);
    }

    protected Node createNodeDelegate() {
        DataNode dn = new DataNode(this, Children.LEAF);
        dn.setShortDescription(NbBundle.getMessage((Class)DefaultDataObject.class, (String)"HINT_DefaultDataObject"));
        return dn;
    }

    public String getName() {
        return this.getPrimaryFile().getNameExt();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject handleRename(String name) throws IOException {
        FileLock lock = this.getPrimaryFile().lock();
        int pos = name.lastIndexOf(46);
        try {
            if (pos < 0) {
                this.getPrimaryFile().rename(lock, name, null);
            } else if (pos == 0) {
                this.getPrimaryFile().rename(lock, name, this.getPrimaryFile().getExt());
            } else if (!name.equals(this.getPrimaryFile().getNameExt())) {
                this.getPrimaryFile().rename(lock, name.substring(0, pos), name.substring(pos + 1, name.length()));
                DataObjectPool.getPOOL().revalidate(new HashSet<FileObject>(Collections.singleton(this.getPrimaryFile())));
            }
        }
        finally {
            lock.releaseLock();
        }
        return this.getPrimaryFile();
    }

    protected DataObject handleCreateFromTemplate(DataFolder df, String name) throws IOException {
        if (name != null && name.endsWith("." + this.getPrimaryFile().getExt())) {
            name = name.substring(0, name.lastIndexOf("." + this.getPrimaryFile().getExt()));
        }
        return super.handleCreateFromTemplate(df, name);
    }

    public void open() {
        EditorCookie ic = (EditorCookie)this.getCookie(EditorCookie.class);
        if (ic != null) {
            ic.open();
        } else {
            ArrayList<Object> options = new ArrayList<Object>();
            options.add(NotifyDescriptor.OK_OPTION);
            options.add(NotifyDescriptor.CANCEL_OPTION);
            NotifyDescriptor nd = new NotifyDescriptor((Object)NbBundle.getMessage((Class)DefaultDataObject.class, (String)"MSG_BinaryFileQuestion"), NbBundle.getMessage((Class)DefaultDataObject.class, (String)"MSG_BinaryFileWarning"), -1, 3, options.toArray(), null);
            Object ret = DialogDisplayer.getDefault().notify(nd);
            if (ret != NotifyDescriptor.OK_OPTION) {
                return;
            }
            EditorCookie c = (EditorCookie)this.getCookie(EditorCookie.class, true);
            c.open();
        }
    }

    public Node.Cookie getCookie(Class c) {
        return this.getCookie(c, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Node.Cookie getCookie(Class c, boolean force) {
        if (c == OpenCookie.class) {
            return this;
        }
        Node.Cookie cook = super.getCookie(c);
        if (cook != null) {
            return cook;
        }
        if (!(c.isAssignableFrom(EditCookie.class) || c.isAssignableFrom(EditorCookie.Observable.class) || c.isAssignableFrom(PrintCookie.class) || c.isAssignableFrom(CloseCookie.class))) {
            if (c != DefaultES.class) return null;
        }
        try {
            if (!force) {
                byte[] arr = new byte[2048];
                InputStream is = this.getPrimaryFile().getInputStream();
                try {
                    int len = is.read(arr);
                    for (int i = 0; i < len; ++i) {
                        if (arr[i] < 0 || arr[i] > 31 || arr[i] == 10 || arr[i] == 13 || arr[i] == 9) continue;
                        Node.Cookie cookie = null;
                        return cookie;
                    }
                }
                finally {
                    is.close();
                }
            }
            DefaultES support = new DefaultES(this, this.getPrimaryEntry(), this.getCookieSet());
            this.getCookieSet().add((Node.Cookie)support);
            return this.getCookieSet().getCookie(c);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

