/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.MultiDataObject;

final class FilesSet
implements Set {
    private MultiDataObject mymdo;
    private boolean lazyWorkDone;
    private Object primaryFile;
    private HashMap secondary;
    private TreeSet delegate;

    public FilesSet(MultiDataObject mdo) {
        this.mymdo = mdo;
        this.lazyWorkDone = false;
        this.primaryFile = null;
        this.secondary = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLazyWork() {
        FilesSet filesSet = this;
        synchronized (filesSet) {
            if (!this.lazyWorkDone) {
                this.lazyWorkDone = true;
                Object object = this.mymdo.synchObjectSecondary();
                synchronized (object) {
                    this.mymdo.removeAllInvalid();
                    this.primaryFile = this.mymdo.getPrimaryFile();
                    this.secondary = this.mymdo.getSecondary();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getDelegate() {
        this.doLazyWork();
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            if (this.delegate == null) {
                this.delegate = new TreeSet(new FilesComparator());
                this.delegate.add(this.primaryFile);
                this.delegate.addAll(this.secondary.keySet());
            }
        }
        return this.delegate;
    }

    public boolean add(Object obj) {
        return this.getDelegate().add(obj);
    }

    public boolean addAll(Collection collection) {
        return this.getDelegate().addAll(collection);
    }

    public void clear() {
        this.getDelegate().clear();
    }

    public boolean contains(Object obj) {
        return this.getDelegate().contains(obj);
    }

    public boolean containsAll(Collection collection) {
        return this.getDelegate().containsAll(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.doLazyWork();
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            return this.delegate == null ? false : this.delegate.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        this.doLazyWork();
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            return this.delegate == null ? new FilesIterator() : this.delegate.iterator();
        }
    }

    public boolean remove(Object obj) {
        return this.getDelegate().remove(obj);
    }

    public boolean removeAll(Collection collection) {
        return this.getDelegate().removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.getDelegate().retainAll(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.doLazyWork();
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            return this.delegate == null ? this.secondary.size() + 1 : this.delegate.size();
        }
    }

    public Object[] toArray() {
        return this.getDelegate().toArray();
    }

    public Object[] toArray(Object[] obj) {
        return this.getDelegate().toArray(obj);
    }

    private final class FilesComparator
    implements Comparator {
        FilesComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 == obj2) {
                return 0;
            }
            if (obj1 == FilesSet.this.primaryFile) {
                return -1;
            }
            if (obj2 == FilesSet.this.primaryFile) {
                return 1;
            }
            FileObject f1 = (FileObject)obj1;
            FileObject f2 = (FileObject)obj2;
            int res = f1.getNameExt().compareTo(f2.getNameExt());
            if (res == 0) {
                try {
                    if (f1.getFileSystem() == f2.getFileSystem()) {
                        return 0;
                    }
                    return f1.getFileSystem().getSystemName().compareTo(f2.getFileSystem().getSystemName());
                }
                catch (FileStateInvalidException fsie) {
                    return 0;
                }
            }
            return res;
        }
    }

    private final class FilesIterator
    implements Iterator {
        private boolean first = true;
        private Iterator itDelegate = null;

        FilesIterator() {
        }

        public boolean hasNext() {
            return this.first ? true : this.getIteratorDelegate().hasNext();
        }

        public Object next() {
            if (this.first) {
                this.first = false;
                return FilesSet.this.primaryFile;
            }
            return this.getIteratorDelegate().next();
        }

        public void remove() {
            this.getIteratorDelegate().remove();
        }

        private Iterator getIteratorDelegate() {
            if (this.itDelegate == null) {
                this.itDelegate = FilesSet.this.getDelegate().iterator();
                this.itDelegate.next();
            }
            return this.itDelegate;
        }
    }
}

