/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.openide.ErrorManager;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderAdapter;

class XMLDataObjectImpl {
    private static EntityCatalog runtimeCatalogInstance = null;

    XMLDataObjectImpl() {
    }

    static DocumentBuilder makeBuilder(boolean validate) throws IOException, SAXException {
        DocumentBuilder builder;
        DocumentBuilderFactory factory;
        try {
            factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validate);
            factory.setNamespaceAware(false);
        }
        catch (FactoryConfigurationError err) {
            XMLDataObjectImpl.notifyFactoryErr(err, "javax.xml.parsers.DocumentBuilderFactory");
            throw err;
        }
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            SAXException sex = new SAXException("Configuration exception.");
            ErrorManager emgr = ErrorManager.getDefault();
            emgr.annotate((Throwable)sex, (Throwable)ex);
            emgr.annotate((Throwable)sex, "Can not create a DOM builder!\nCheck javax.xml.parsers.DocumentBuilderFactory property and the builder library presence on classpath.");
            throw sex;
        }
        return builder;
    }

    static Parser makeParser(boolean validate) {
        try {
            return new XMLReaderAdapter(XMLUtil.createXMLReader((boolean)validate));
        }
        catch (SAXException ex) {
            XMLDataObjectImpl.notifyNewSAXParserEx(ex);
            return null;
        }
    }

    static XMLReader makeXMLReader(boolean validating, boolean namespaces) {
        try {
            return XMLUtil.createXMLReader((boolean)validating, (boolean)namespaces);
        }
        catch (SAXException ex) {
            XMLDataObjectImpl.notifyNewSAXParserEx(ex);
            return null;
        }
    }

    private static void notifyNewSAXParserEx(Exception ex) {
        ErrorManager emgr = ErrorManager.getDefault();
        emgr.annotate((Throwable)ex, "Can not create a SAX parser!\nCheck javax.xml.parsers.SAXParserFactory property features and the parser library presence on classpath.");
        emgr.notify((Throwable)ex);
    }

    private static void notifyFactoryErr(Error err, String property) {
        ErrorManager emgr = ErrorManager.getDefault();
        emgr.annotate((Throwable)err, "Can not create a factory!\nCheck " + property + "  property and the factory library presence on classpath.");
        emgr.notify((Throwable)err);
    }

    private static void notifyException(Throwable err) {
        ErrorManager emgr = ErrorManager.getDefault();
        emgr.notify(1, err);
    }

    static synchronized EntityCatalog createEntityCatalog() {
        if (runtimeCatalogInstance == null) {
            runtimeCatalogInstance = new RuntimeCatalog();
        }
        return runtimeCatalogInstance;
    }

    static synchronized void registerCatalogEntry(String publicId, String uri) {
        ((RuntimeCatalog)XMLDataObjectImpl.createEntityCatalog()).registerCatalogEntry(publicId, uri);
    }

    static final class RuntimeCatalog
    extends EntityCatalog {
        private Hashtable id2uri;
        private Hashtable id2resource;
        private Hashtable id2loader;

        RuntimeCatalog() {
        }

        public InputSource resolveEntity(String name, String uri) throws IOException, SAXException {
            String mappedURI = this.name2uri(name);
            InputStream stream = this.mapResource(name);
            if (mappedURI != null) {
                InputSource retval = new InputSource(mappedURI);
                retval.setPublicId(name);
                return retval;
            }
            if (stream != null) {
                uri = "java:resource:" + (String)this.id2resource.get(name);
                InputSource retval = new InputSource(stream);
                retval.setPublicId(name);
                return retval;
            }
            return null;
        }

        public void registerCatalogEntry(String publicId, String uri) {
            if (this.id2uri == null) {
                this.id2uri = new Hashtable(17);
            }
            this.id2uri.put(publicId, uri);
        }

        public void registerCatalogEntry(String publicId, String resourceName, ClassLoader loader) {
            if (this.id2resource == null) {
                this.id2resource = new Hashtable(17);
            }
            this.id2resource.put(publicId, resourceName);
            if (loader != null) {
                if (this.id2loader == null) {
                    this.id2loader = new Hashtable(17);
                }
                this.id2loader.put(publicId, loader);
            }
        }

        private String name2uri(String publicId) {
            if (publicId == null || this.id2uri == null) {
                return null;
            }
            return (String)this.id2uri.get(publicId);
        }

        private InputStream mapResource(String publicId) {
            if (publicId == null || this.id2resource == null) {
                return null;
            }
            String resourceName = (String)this.id2resource.get(publicId);
            ClassLoader loader = null;
            if (resourceName == null) {
                return null;
            }
            if (this.id2loader != null) {
                loader = (ClassLoader)this.id2loader.get(publicId);
            }
            if (loader == null) {
                return ClassLoader.getSystemResourceAsStream(resourceName);
            }
            return loader.getResourceAsStream(resourceName);
        }
    }
}

