/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.doclets.standard;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.webui.jsf.doclets.ClassTree;
import com.sun.webui.jsf.doclets.standard.ClassUseWriter;
import com.sun.webui.jsf.doclets.standard.ConfigurationStandard;
import com.sun.webui.jsf.doclets.standard.PackageUseWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.TreeSet;

public class ClassUseMapper {
    private final ClassTree classtree;
    public Map classToPackage = new HashMap();
    public Map classToClass = new HashMap();
    public Map classToSubclass = new HashMap();
    public Map classToSubinterface = new HashMap();
    public Map classToImplementingClass = new HashMap();
    public Map classToField = new HashMap();
    public Map classToMethodReturn = new HashMap();
    public Map classToMethodArgs = new HashMap();
    public Map classToMethodThrows = new HashMap();
    public Map classToConstructorArgs = new HashMap();
    public Map classToConstructorThrows = new HashMap();

    public static void generate(ConfigurationStandard configurationStandard, ClassTree classTree) {
        ClassUseMapper classUseMapper = new ClassUseMapper(configurationStandard.root, classTree);
        ClassDoc[] classDocArray = configurationStandard.root.classes();
        for (int i = 0; i < classDocArray.length; ++i) {
            ClassUseWriter.generate(configurationStandard, classUseMapper, classDocArray[i]);
        }
        PackageDoc[] packageDocArray = configurationStandard.packages;
        for (int i = 0; i < packageDocArray.length; ++i) {
            PackageUseWriter.generate(configurationStandard, classUseMapper, packageDocArray[i]);
        }
    }

    private ClassUseMapper(RootDoc rootDoc, ClassTree classTree) {
        this.classtree = classTree;
        ClassDoc[] classDocArray = classTree.baseclasses().iterator();
        while (classDocArray.hasNext()) {
            this.subclasses((ClassDoc)classDocArray.next());
        }
        classDocArray = classTree.baseinterfaces().iterator();
        while (classDocArray.hasNext()) {
            this.implementingClasses((ClassDoc)classDocArray.next());
        }
        classDocArray = rootDoc.classes();
        for (int i = 0; i < classDocArray.length; ++i) {
            MethodDoc[] methodDocArray;
            ClassDoc classDoc = classDocArray[i];
            FieldDoc[] fieldDocArray = classDoc.fields();
            for (int j = 0; j < fieldDocArray.length; ++j) {
                methodDocArray = fieldDocArray[j];
                ClassDoc classDoc2 = methodDocArray.type().asClassDoc();
                if (classDoc2 == null) continue;
                this.add(this.classToField, classDoc2, (ProgramElementDoc)methodDocArray);
            }
            ConstructorDoc[] constructorDocArray = classDoc.constructors();
            for (int j = 0; j < constructorDocArray.length; ++j) {
                this.mapExecutable((ExecutableMemberDoc)constructorDocArray[j]);
            }
            methodDocArray = classDoc.methods();
            for (int j = 0; j < methodDocArray.length; ++j) {
                MethodDoc methodDoc = methodDocArray[j];
                this.mapExecutable((ExecutableMemberDoc)methodDoc);
                ClassDoc classDoc3 = methodDoc.returnType().asClassDoc();
                if (classDoc3 == null) continue;
                this.add(this.classToMethodReturn, classDoc3, (ProgramElementDoc)methodDoc);
            }
        }
    }

    private Collection subclasses(ClassDoc classDoc) {
        TreeSet treeSet = (TreeSet)this.classToSubclass.get(classDoc.qualifiedName());
        if (treeSet == null) {
            treeSet = new TreeSet();
            List list = this.classtree.subclasses(classDoc);
            if (list != null) {
                treeSet.addAll(list);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    treeSet.addAll(this.subclasses((ClassDoc)iterator.next()));
                }
            }
            this.addAll(this.classToSubclass, classDoc, treeSet);
        }
        return treeSet;
    }

    private Collection subinterfaces(ClassDoc classDoc) {
        TreeSet treeSet = (TreeSet)this.classToSubinterface.get(classDoc.qualifiedName());
        if (treeSet == null) {
            treeSet = new TreeSet();
            List list = this.classtree.subinterfaces(classDoc);
            if (list != null) {
                treeSet.addAll(list);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    treeSet.addAll(this.subinterfaces((ClassDoc)iterator.next()));
                }
            }
            this.addAll(this.classToSubinterface, classDoc, treeSet);
        }
        return treeSet;
    }

    private Collection implementingClasses(ClassDoc classDoc) {
        SequencedCollection sequencedCollection = (List)this.classToImplementingClass.get(classDoc.qualifiedName());
        if (sequencedCollection == null) {
            Iterator iterator;
            sequencedCollection = new TreeSet();
            List list = this.classtree.implementingclasses(classDoc);
            if (list != null) {
                sequencedCollection.addAll(list);
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    sequencedCollection.addAll(this.subclasses((ClassDoc)iterator.next()));
                }
            }
            iterator = this.subinterfaces(classDoc).iterator();
            while (iterator.hasNext()) {
                sequencedCollection.addAll(this.implementingClasses((ClassDoc)iterator.next()));
            }
            this.addAll(this.classToImplementingClass, classDoc, sequencedCollection);
        }
        return sequencedCollection;
    }

    private void mapExecutable(ExecutableMemberDoc executableMemberDoc) {
        Parameter[] parameterArray = executableMemberDoc.parameters();
        boolean bl = executableMemberDoc.isConstructor();
        ArrayList<ClassDoc> arrayList = new ArrayList<ClassDoc>();
        for (int i = 0; i < parameterArray.length; ++i) {
            ClassDoc classDoc = parameterArray[i].type().asClassDoc();
            if (classDoc == null || arrayList.contains(classDoc)) continue;
            this.add(bl ? this.classToConstructorArgs : this.classToMethodArgs, classDoc, (ProgramElementDoc)executableMemberDoc);
            arrayList.add(classDoc);
        }
        ClassDoc[] classDocArray = executableMemberDoc.thrownExceptions();
        for (int i = 0; i < classDocArray.length; ++i) {
            this.add(bl ? this.classToConstructorThrows : this.classToMethodThrows, classDocArray[i], (ProgramElementDoc)executableMemberDoc);
        }
    }

    private List refList(Map map, ClassDoc classDoc) {
        ArrayList arrayList = (ArrayList)map.get(classDoc.qualifiedName());
        if (arrayList == null) {
            arrayList = new ArrayList();
            map.put(classDoc.qualifiedName(), arrayList);
        }
        return arrayList;
    }

    private Set packageSet(ClassDoc classDoc) {
        TreeSet treeSet = (TreeSet)this.classToPackage.get(classDoc.qualifiedName());
        if (treeSet == null) {
            treeSet = new TreeSet();
            this.classToPackage.put(classDoc.qualifiedName(), treeSet);
        }
        return treeSet;
    }

    private Set classSet(ClassDoc classDoc) {
        TreeSet treeSet = (TreeSet)this.classToClass.get(classDoc.qualifiedName());
        if (treeSet == null) {
            treeSet = new TreeSet();
            this.classToClass.put(classDoc.qualifiedName(), treeSet);
        }
        return treeSet;
    }

    private void add(Map map, ClassDoc classDoc, ProgramElementDoc programElementDoc) {
        this.refList(map, classDoc).add(programElementDoc);
        this.packageSet(classDoc).add(programElementDoc.containingPackage());
        this.classSet(classDoc).add(programElementDoc instanceof MemberDoc ? ((MemberDoc)programElementDoc).containingClass() : programElementDoc);
    }

    private void addAll(Map map, ClassDoc classDoc, Collection collection) {
        if (collection == null) {
            return;
        }
        this.refList(map, classDoc).addAll(collection);
        Set set = this.packageSet(classDoc);
        Set set2 = this.classSet(classDoc);
        for (ProgramElementDoc programElementDoc : collection) {
            set.add(programElementDoc.containingPackage());
            set2.add(programElementDoc instanceof MemberDoc ? ((MemberDoc)programElementDoc).containingClass() : programElementDoc);
        }
    }
}

