/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.doclets.standard;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.webui.jsf.doclets.DocletAbortException;
import com.sun.webui.jsf.doclets.standard.ConfigurationStandard;
import com.sun.webui.jsf.doclets.standard.ConstantFieldSubWriter;
import com.sun.webui.jsf.doclets.standard.SubWriterHolderWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ConstantsSummaryWriter
extends SubWriterHolderWriter {
    ConfigurationStandard configuration;
    private Set classDocsWithConstFields;
    private Set printedPackageHeaders;
    private String UNNAMED_PACKAGE_ANCHOR = "unnamed_package";
    private String UNNAMED_PACKAGE_HEADING = "Unnamed Package";

    public ConstantsSummaryWriter(ConfigurationStandard configurationStandard, String string) throws IOException {
        super(configurationStandard, string);
        this.configuration = configurationStandard;
        this.classDocsWithConstFields = new HashSet();
    }

    public static void generate(ConfigurationStandard configurationStandard) {
        String string = "constant-values.html";
        try {
            ConstantsSummaryWriter constantsSummaryWriter = new ConstantsSummaryWriter(configurationStandard, string);
            constantsSummaryWriter.generateConstantsFile(configurationStandard.root);
            constantsSummaryWriter.close();
        }
        catch (IOException iOException) {
            configurationStandard.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    public void generateConstantsFile(RootDoc rootDoc) {
        this.printHeader(this.getText("doclet.Constants_Summary"));
        this.navLinks(true);
        this.hr();
        this.center();
        this.h1();
        this.printText("doclet.Constants_Summary");
        this.h1End();
        this.centerEnd();
        this.hr(4, "noshade");
        this.generateIndex(rootDoc);
        this.generateContents(rootDoc);
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void generateIndex(RootDoc rootDoc) {
        PackageDoc[] packageDocArray = this.configuration.packages;
        this.printedPackageHeaders = new HashSet();
        this.bold(this.getText("doclet.Contents"));
        this.ul();
        for (int i = 0; i < packageDocArray.length; ++i) {
            String string = packageDocArray[i].name();
            if (!this.hasConstantField(packageDocArray[i]) || this.hasPrintedPackage(string)) continue;
            this.li();
            if (string.length() == 0) {
                this.printHyperLink("#" + this.UNNAMED_PACKAGE_ANCHOR, this.UNNAMED_PACKAGE_HEADING);
            } else {
                string = this.parsePackageName(string);
                this.printHyperLink("#" + string, string + ".*");
                this.printedPackageHeaders.add(string);
            }
            this.print("\n");
        }
        this.ulEnd();
        this.print("\n");
    }

    protected void generateContents(RootDoc rootDoc) {
        PackageDoc[] packageDocArray = this.configuration.packages;
        this.printedPackageHeaders = new HashSet();
        boolean bl = true;
        for (int i = 0; i < packageDocArray.length; ++i) {
            Object[] objectArray = packageDocArray[i].name().length() > 0 ? packageDocArray[i].allClasses() : this.configuration.classDocCatalog.allClasses("");
            boolean bl2 = true;
            Arrays.sort(objectArray);
            for (int j = 0; j < objectArray.length; ++j) {
                Object object = objectArray[j];
                if (!this.classDocsWithConstFields.contains(object) || !object.isIncluded()) continue;
                if (bl2) {
                    this.printPackageName(packageDocArray[i].name());
                    bl2 = false;
                }
                bl = false;
                this.printConstantMemberInfo((ClassDoc)object);
            }
        }
    }

    private boolean hasConstantField(PackageDoc packageDoc) {
        ClassDoc[] classDocArray = packageDoc.name().length() > 0 ? packageDoc.allClasses() : this.configuration.classDocCatalog.allClasses("");
        boolean bl = false;
        for (int i = 0; i < classDocArray.length; ++i) {
            if (!classDocArray[i].isIncluded() || !this.hasConstantField(classDocArray[i])) continue;
            bl = true;
        }
        return bl;
    }

    private boolean hasConstantField(ClassDoc classDoc) {
        FieldDoc[] fieldDocArray = classDoc.fields();
        for (int i = 0; i < fieldDocArray.length; ++i) {
            if (fieldDocArray[i].constantValueExpression() == null) continue;
            this.classDocsWithConstFields.add(classDoc);
            return true;
        }
        return false;
    }

    protected void printConstantMemberInfo(ClassDoc classDoc) {
        String string = classDoc.isPublic() || classDoc.isProtected() ? this.getClassLink(classDoc) : classDoc.qualifiedName();
        String string2 = classDoc.containingPackage().name();
        if (string2.length() > 0) {
            this.printClassName(string2 + "." + string);
        } else {
            this.printClassName(string);
        }
        this.printConstantMembers(classDoc);
        this.tableFooter();
        this.p();
    }

    protected void printConstantMembers(ClassDoc classDoc) {
        new ConstantFieldSubWriter(this, classDoc).printMembersSummary();
    }

    protected void printPackageName(String string) {
        if (string.length() == 0) {
            this.anchor(this.UNNAMED_PACKAGE_ANCHOR);
            string = this.UNNAMED_PACKAGE_HEADING;
        } else {
            if (this.hasPrintedPackage(string)) {
                return;
            }
            string = this.parsePackageName(string);
            this.anchor(string);
        }
        this.packageTableHeader();
        this.tdAlign("left");
        this.font("+2");
        this.printedPackageHeaders.add(string);
        this.bold(string + ".*");
        this.tableFooter();
    }

    private String parsePackageName(String string) {
        int n = -1;
        for (int i = 0; i < 2; ++i) {
            n = string.indexOf(".", n + 1);
        }
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    protected boolean hasPrintedPackage(String string) {
        String[] stringArray = this.printedPackageHeaders.toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.startsWith(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    protected void printClassName(String string) {
        this.classTableHeader();
        this.tdColspan(3);
        this.bold(string);
        this.tdEnd();
        this.trEnd();
    }

    private void packageTableHeader() {
        this.println("\n<TABLE BORDER=\"1\" CELLPADDING=\"3\" CELLSPACING=\"0\" WIDTH=\"100%\">");
        this.trBgcolorStyle("#CCCCFF", "TableHeadingColor");
    }

    private void classTableHeader() {
        this.println("\n<TABLE BORDER=\"1\" CELLPADDING=\"3\" CELLSPACING=\"0\">");
        this.trBgcolorStyle("#EEEEFF", "TableSubHeadingColor");
    }

    private void tableFooter() {
        this.fontEnd();
        this.tdEnd();
        this.trEnd();
        this.tableEnd();
        this.p();
    }
}

