/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.doclets.standard;

import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.PackageDoc;
import com.sun.webui.jsf.doclets.MessageRetriever;
import com.sun.webui.jsf.doclets.standard.ConfigurationStandard;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Group {
    private Map regExpGroupMap = new HashMap();
    private List sortedRegExpList = new ArrayList();
    private List groupList = new ArrayList();
    private Map pkgNameGroupMap = new HashMap();
    private final ConfigurationStandard configuration;

    public Group(ConfigurationStandard configurationStandard) {
        this.configuration = configurationStandard;
    }

    public boolean checkPackageGroups(String string, String string2, DocErrorReporter docErrorReporter) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
        if (this.groupList.contains(string)) {
            docErrorReporter.printError(this.msg().getText("doclet.Groupname_already_used", string));
            return false;
        }
        this.groupList.add(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.length() == 0) {
                docErrorReporter.printError(this.msg().getText("doclet.Error_in_packagelist", string, string2));
                return false;
            }
            if (string3.endsWith("*")) {
                if (this.foundGroupFormat(this.regExpGroupMap, string3 = string3.substring(0, string3.length() - 1), docErrorReporter)) {
                    return false;
                }
                this.regExpGroupMap.put(string3, string);
                this.sortedRegExpList.add(string3);
                continue;
            }
            if (this.foundGroupFormat(this.pkgNameGroupMap, string3, docErrorReporter)) {
                return false;
            }
            this.pkgNameGroupMap.put(string3, string);
        }
        Collections.sort(this.sortedRegExpList, new MapKeyComparator());
        return true;
    }

    boolean foundGroupFormat(Map map, String string, DocErrorReporter docErrorReporter) {
        if (map.containsKey(string)) {
            docErrorReporter.printError(this.msg().getText("doclet.Same_package_name_used", string));
            return true;
        }
        return false;
    }

    List asList(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        return arrayList;
    }

    public Map groupPackages(PackageDoc[] packageDocArray) {
        String string;
        HashMap hashMap = new HashMap();
        String string2 = string = this.pkgNameGroupMap.isEmpty() && this.regExpGroupMap.isEmpty() ? this.msg().getText("doclet.Packages") : this.msg().getText("doclet.Other_Packages");
        if (!this.groupList.contains(string)) {
            this.groupList.add(string);
        }
        for (int i = 0; i < packageDocArray.length; ++i) {
            PackageDoc packageDoc = packageDocArray[i];
            String string3 = packageDoc.name();
            String string4 = (String)this.pkgNameGroupMap.get(string3);
            if (string4 == null) {
                string4 = this.regExpGroupName(string3);
            }
            if (string4 == null) {
                string4 = string;
            }
            this.getPkgList(hashMap, string4).add(packageDoc);
        }
        return hashMap;
    }

    String regExpGroupName(String string) {
        for (int i = 0; i < this.sortedRegExpList.size(); ++i) {
            String string2 = (String)this.sortedRegExpList.get(i);
            if (!string.startsWith(string2)) continue;
            return (String)this.regExpGroupMap.get(string2);
        }
        return null;
    }

    List getPkgList(Map map, String string) {
        ArrayList arrayList = (ArrayList)map.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            map.put(string, arrayList);
        }
        return arrayList;
    }

    public List getGroupList() {
        return this.groupList;
    }

    public MessageRetriever msg() {
        return this.configuration.standardmessage;
    }

    private static class MapKeyComparator
    implements Comparator {
        private MapKeyComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((String)object2).length() - ((String)object).length();
        }
    }
}

