/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.BlockParentHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;

public class ArrayInitHandler
extends BlockParentHandler {
    public ArrayInitHandler(IndentationCheck aIndentCheck, DetailAST aAst, ExpressionHandler aParent) {
        super(aIndentCheck, "array initialization", aAst, aParent);
    }

    public IndentLevel getLevelImpl() {
        DetailAST parentAST = this.getMainAst().getParent();
        int type = parentAST.getType();
        if (type == 136 || type == 80) {
            return new IndentLevel(this.getLineStart(parentAST));
        }
        if (this.getParent() instanceof ArrayInitHandler) {
            return ((ArrayInitHandler)this.getParent()).getChildrenExpectedLevel();
        }
        return this.getParent().getLevel();
    }

    protected DetailAST getToplevelAST() {
        return null;
    }

    protected DetailAST getLCurly() {
        return this.getMainAst();
    }

    protected DetailAST getRCurly() {
        return this.getMainAst().findFirstToken(73);
    }

    protected boolean rcurlyMustStart() {
        return false;
    }

    protected boolean childrenMayNest() {
        return true;
    }

    protected DetailAST getListChild() {
        return this.getMainAst();
    }

    protected IndentLevel getChildrenExpectedLevel() {
        int lcurlyPos;
        int firstChildPos;
        IndentLevel expectedIndent = super.getChildrenExpectedLevel();
        int firstLine = this.getFirstLine(Integer.MAX_VALUE, this.getListChild());
        if (this.hasCurlys() && firstLine == this.getLCurly().getLineNo() && (firstChildPos = this.getNextFirstNonblankOnLineAfter(firstLine, lcurlyPos = this.expandedTabsColumnNo(this.getLCurly()))) >= 0) {
            expectedIndent.addAcceptedIndent(firstChildPos);
        }
        return expectedIndent;
    }

    private int getNextFirstNonblankOnLineAfter(int aLineNo, int aColumnNo) {
        int columnNo;
        String line = this.getIndentCheck().getLines()[aLineNo - 1];
        int lineLength = line.length();
        for (columnNo = aColumnNo + 1; columnNo < lineLength && Character.isWhitespace(line.charAt(columnNo)); ++columnNo) {
        }
        return columnNo == lineLength ? -1 : columnNo;
    }
}

