/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.BlockParentHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;

public class AssignHandler
extends BlockParentHandler {
    public AssignHandler(IndentationCheck aIndentCheck, DetailAST aAst, ExpressionHandler aParent) {
        super(aIndentCheck, "assign", aAst, aParent);
    }

    public void checkIndentation() {
        IndentLevel expectedLevel = this.getChildrenExpectedLevel();
        DetailAST assign = this.getMainAst();
        if (this.startsLine(assign) && !expectedLevel.accept(this.expandedTabsColumnNo(assign))) {
            this.logError(assign, "", this.expandedTabsColumnNo(assign), expectedLevel);
        }
        DetailAST child = (DetailAST)assign.getFirstChild();
        if (assign.getParent() != null && assign.getParent().getType() == 28) {
            child = (DetailAST)child.getNextSibling();
        }
        this.checkExpressionSubtree(child, expectedLevel, false, true);
    }

    protected boolean shouldIncreaseIndent() {
        return false;
    }

    public IndentLevel suggestedChildLevel(ExpressionHandler aChild) {
        DetailAST assign = this.getMainAst();
        DetailAST child = aChild.getMainAst();
        if (child == assign.getFirstChild()) {
            return this.getLevel();
        }
        if (this.startsLine(assign)) {
            return new IndentLevel(this.expandedTabsColumnNo(assign));
        }
        return super.suggestedChildLevel(aChild);
    }
}

