/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.admin.model;

import com.sun.portal.desktop.ServletContextThreadLocalizer;
import com.sun.portal.desktop.admin.model.DAAddChannelModel;
import com.sun.portal.desktop.admin.model.DAConsoleException;
import com.sun.portal.desktop.admin.model.DADPModelImpl;
import com.sun.portal.desktop.context.PropertiesConfigContext;
import com.sun.portal.desktop.context.ProviderClassLoader;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPContainerChannel;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.desktop.dp.DPNode;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public class DAAddChannelModelImpl
extends DADPModelImpl
implements DAAddChannelModel {
    private Set channelProviders = null;
    private String containerPath = null;
    protected boolean isAddingContainer = false;
    protected ProviderClassLoader pcl = null;
    protected DPNode currentNode = null;
    static /* synthetic */ Class class$com$sun$portal$providers$containers$ContainerProvider;

    public DAAddChannelModelImpl(HttpServletRequest req, String rbName, Map map) throws DAConsoleException {
        super(req, rbName, map);
        this.containerPath = (String)map.get("com.sun.portal.desktop.admin.fqcn");
        Boolean addingContainer = (Boolean)map.get("isAddingContainer");
        if (addingContainer != null) {
            this.isAddingContainer = addingContainer;
        }
        this.initData();
    }

    public void initData() throws DAConsoleException {
        PropertiesConfigContext configContext = new PropertiesConfigContext();
        configContext.init(ServletContextThreadLocalizer.get());
        String providerClassBaseDir = configContext.getProviderClassBaseDir();
        this.pcl = ProviderClassLoader.getInstance(providerClassBaseDir);
        try {
            this.currentNode = this.containerPath == null || this.containerPath.length() < 2 ? this.dpRoot : this.dpRoot.getChannel(this.containerPath);
            if (this.currentNode == null) {
                throw new DAConsoleException(10);
            }
            short currentNodeType = this.currentNode.getType();
            if (currentNodeType != 13 && currentNodeType != 5) {
                this.currentNode = this.dpRoot;
                this.error("DAAddChannelModelImpl: Incorrect NodeType");
            }
            this.setProviderData();
        }
        catch (DPError dpe) {
            throw new DAConsoleException(0, (Throwable)dpe);
        }
    }

    private void setProviderData() throws DPError {
        this.channelProviders = new TreeSet<Object>(this.getCollator());
        Set providerNames = this.currentNode.getProviderNames();
        Iterator iterator = providerNames.iterator();
        while (iterator.hasNext()) {
            String providerName = (String)iterator.next();
            DPProvider provider = this.currentNode.getProvider(providerName);
            if (this.getTail(providerName).startsWith("_") || provider == null) continue;
            String className = provider.getClassName();
            try {
                Class<?> providerClass = this.pcl.loadClass(className);
                boolean isContainerProvider = (class$com$sun$portal$providers$containers$ContainerProvider == null ? DAAddChannelModelImpl.class$("com.sun.portal.providers.containers.ContainerProvider") : class$com$sun$portal$providers$containers$ContainerProvider).isAssignableFrom(providerClass);
                if ((!this.isAddingContainer || !isContainerProvider) && (this.isAddingContainer || isContainerProvider)) continue;
                this.channelProviders.add(providerName);
            }
            catch (ClassNotFoundException cne) {
                this.error("DAAddChannelModelImp::ClassNotFound:" + className);
            }
        }
    }

    public Set getAvailableProviders() {
        return this.channelProviders;
    }

    public boolean isDisplayProfileRoot() {
        boolean isDPRoot = false;
        if (this.currentNode == null || this.currentNode.getType() == 13) {
            isDPRoot = true;
        }
        return isDPRoot;
    }

    public void addChannel(String channelName, String providerName, boolean selectedToo) throws DAConsoleException {
        if ((channelName = channelName.trim()).length() == 0) {
            throw new DAConsoleException(12);
        }
        for (int i = 0; i < channelName.length(); ++i) {
            char c = channelName.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            throw new DAConsoleException(13);
        }
        if (this.currentNode.channelExists(channelName)) {
            throw new DAConsoleException(11);
        }
        String className = this.currentNode.getProvider(providerName).getClassName();
        DPChannel newChannel = null;
        boolean isContainerProvider = false;
        try {
            Class<?> providerClass = this.pcl.loadClass(className);
            isContainerProvider = (class$com$sun$portal$providers$containers$ContainerProvider == null ? (class$com$sun$portal$providers$containers$ContainerProvider = DAAddChannelModelImpl.class$("com.sun.portal.providers.containers.ContainerProvider")) : class$com$sun$portal$providers$containers$ContainerProvider).isAssignableFrom(providerClass);
        }
        catch (ClassNotFoundException cne) {
            this.error("DAAddChannelModelImp::ClassNotFound:" + className);
        }
        newChannel = isContainerProvider ? XMLDPFactory.getInstance().createContainerChannel(this.dpContext, this.dpRoot, ((XMLDPRoot)this.dpRoot).getDocument(), channelName, providerName) : XMLDPFactory.getInstance().createChannel(this.dpContext, this.dpRoot, ((XMLDPRoot)this.dpRoot).getDocument(), channelName, providerName);
        newChannel = this.currentNode.addChannel(newChannel);
        newChannel.setMergeType((short)1);
        if (this.currentNode instanceof DPContainerChannel) {
            channelName = newChannel.getName();
            DPContainerChannel container = (DPContainerChannel)this.currentNode;
            Set available = container.getAvailable().getNames();
            available.add(channelName);
            container.setAvailable(new ArrayList(available));
            if (selectedToo) {
                Set selected = container.getSelected().getNames();
                selected.add(channelName);
                container.setSelected(new ArrayList(selected));
            }
        }
        this.store();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

