/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.admin.model;

import com.sun.portal.desktop.admin.model.DAAddPropertyModel;
import com.sun.portal.desktop.admin.model.DAConsoleException;
import com.sun.portal.desktop.admin.model.DAEditPropertiesModelImpl;
import com.sun.portal.desktop.dp.DPCollection;
import com.sun.portal.desktop.dp.DPProperty;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class DAAddPropertyModelImpl
extends DAEditPropertiesModelImpl
implements DAAddPropertyModel {
    public DAAddPropertyModelImpl(HttpServletRequest req, String rbName, Map map) throws DAConsoleException {
        super(req, rbName, map);
    }

    public void addProperty(String name, short type, String strValue, boolean advanced, boolean unnamed) throws DAConsoleException {
        Set existingNames;
        Object value = null;
        switch (type) {
            case 1: {
                value = strValue;
                break;
            }
            case 3: {
                try {
                    value = new Integer(strValue);
                    break;
                }
                catch (NumberFormatException e) {
                    this.message("DAAddPropertiesModelImpl.addProperty:", e);
                    throw new DAConsoleException(3, (Throwable)e);
                }
            }
            case 4: {
                value = new Boolean(strValue);
                break;
            }
            case 14: {
                if (name == null || name.length() == 0) {
                    throw new DAConsoleException(5, "Collection must have a name.");
                }
                if (name.indexOf("/") > -1) {
                    throw new DAConsoleException(6, "Collection name can not have path delimiter.");
                }
                value = Collections.EMPTY_MAP;
                break;
            }
            case 16: {
                if (name != null && name.length() != 0 && name.indexOf("/") <= -1 && strValue != null && strValue.length() != 0 && strValue.indexOf("/") <= -1) break;
                throw new DAConsoleException(14, "Conditional must have condition and value and condition or value can not have path delimiter.");
            }
            default: {
                this.warning("DAAddPropertyModelImpl.addProperty:Unknown property type" + type);
                return;
            }
        }
        if (unnamed && (strValue == null || strValue.length() == 0)) {
            this.message("DAAddPropertyModelImpl.addProperty: Un-named properties MUST have a name or a value.");
            throw new DAConsoleException(7, "Un-named properties MUST have a name or a value.");
        }
        if (unnamed) {
            name = strValue;
        }
        if ((existingNames = this.getPropertyNames()).contains(name)) {
            this.message("DAAddPropertyModelImpl.addProperty: Property already exits.");
            throw new DAConsoleException(8, "Property already exits.");
        }
        if (type == 16 && existingNames.contains("_conditional_" + name + "_" + strValue)) {
            this.message("DAAddPropertyModelImpl.addProperty: Conditional Property already exits.");
            throw new DAConsoleException(8, "Conditional Property already exits.");
        }
        if (name.indexOf(61) != -1) {
            this.message("DAAddPropertyModelImpl.addProperty: Property name can not contain the condition-value delimiter.");
            throw new DAConsoleException(9, "Property name can not contain the condition-value delimiter.");
        }
        DPProperty property = null;
        property = type != 16 ? (unnamed ? XMLDPFactory.getInstance().createProperty(this.dpContext, this.dpRoot, ((XMLDPRoot)this.dpRoot).getDocument(), value) : XMLDPFactory.getInstance().createProperty(this.dpContext, this.dpRoot, ((XMLDPRoot)this.dpRoot).getDocument(), name, value)) : XMLDPFactory.getInstance().createConditionalProperties(this.dpContext, this.dpRoot, ((XMLDPRoot)this.dpRoot).getDocument(), name, strValue);
        if (advanced) {
            property.setAdvanced(true);
        }
        DPCollection collection = this.customizeCollectionsTree();
        collection.add(property);
        this.store();
    }
}

