/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.iplanet.am.util.Debug;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DebugContext;

public class DSAMEDebugContext
implements DebugContext {
    private Debug debug = null;

    public void init(String name, short level) {
        this.debug = Debug.getInstance((String)name);
        this.setDebugLevel(level);
    }

    public void setDebugLevel(short level) {
        switch (level) {
            case 0: {
                this.debug.setDebug(0);
                break;
            }
            case 1: {
                this.debug.setDebug(1);
                break;
            }
            case 2: {
                this.debug.setDebug(2);
                break;
            }
            case 3: {
                this.debug.setDebug(3);
                break;
            }
            default: {
                throw new ContextError("DSAMEDebugContext.setDebugLevel(): invalid log level=" + level);
            }
        }
    }

    public short getDebugLevel() {
        return (short)this.debug.getState();
    }

    public boolean isDebugEnabled() {
        return this.getDebugLevel() != 0;
    }

    public boolean isDebugErrorEnabled() {
        return this.getDebugLevel() == 1 || this.isDebugWarningEnabled();
    }

    public boolean isDebugWarningEnabled() {
        return this.debug.warningEnabled();
    }

    public boolean isDebugMessageEnabled() {
        return this.debug.messageEnabled();
    }

    public void debugMessage(Object o) {
        if (o != null) {
            this.debug.message(o.toString());
        } else {
            this.debug.message("<null>");
        }
    }

    public void debugWarning(Object o) {
        if (o != null) {
            this.debug.warning(o.toString());
        } else {
            this.debug.warning("<null>");
        }
    }

    public void debugError(Object o) {
        if (o != null) {
            this.debug.error(o.toString());
        } else {
            this.debug.warning("<null>");
        }
    }

    public void debugMessage(Object o, Throwable t) {
        if (o != null) {
            this.debug.message(o.toString(), t);
        } else {
            this.debug.message("<null>", t);
        }
    }

    public void debugWarning(Object o, Throwable t) {
        if (o != null) {
            this.debug.warning(o.toString(), t);
        } else {
            this.debug.warning("<null>", t);
        }
    }

    public void debugError(Object o, Throwable t) {
        if (o != null) {
            this.debug.error(o.toString(), t);
        } else {
            this.debug.warning("<null>");
        }
    }

    public void debugTrace(Object o) {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            this.debugError(o, e);
            return;
        }
    }
}

