/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.desktop.context.TemplateContext;
import com.sun.portal.desktop.template.ParsedTagArray;
import com.sun.portal.desktop.util.FileLookup;
import com.sun.portal.util.UnicodeInputStreamReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FileTemplateContext
implements TemplateContext {
    private Map templatesByKey = Collections.synchronizedMap(new HashMap());
    private Map templatesByFile = Collections.synchronizedMap(new HashMap());
    private int scanInterval = 0;
    private Map nonexistTemplateCacheByKey = Collections.synchronizedMap(new HashMap());

    private static void log(String msg) {
        if (DesktopAppContextThreadLocalizer.exists()) {
            DesktopAppContext dac = DesktopAppContextThreadLocalizer.get();
            dac.debugError(msg);
        }
    }

    public synchronized void init(int templateScanInterval) {
        this.scanInterval = templateScanInterval;
    }

    public ParsedTagArray getTemplate(String base, String type, String locale, String app, String provider, String clientFilePath, String file) {
        ParsedTagArray template = null;
        template = this.get(base, type, locale, app, provider, clientFilePath, file);
        return template;
    }

    public File getTemplatePath(String base, String type, String locale, String app, String provider, String clientFilePath, String fileName) {
        File file = this.getCachedFile(base, type, locale, app, provider, clientFilePath, fileName);
        return file;
    }

    public File getTemplateMostSpecificPath(String base, String type, String locale, String app, String provider, String clientFilePath, String fileName) {
        File file = FileLookup.getMostSpecific(base, type, locale, app, provider, clientFilePath, fileName);
        return file;
    }

    private String errorString(String base, String type, String locale, String channel, String provider, String clientPath, String file, String msg) {
        String error = msg + ": " + "base=" + base + ", type=" + type + ", locale=" + locale + ", channel=" + channel + ", provider=" + provider + ", clientPath=" + clientPath + ", file=" + file;
        return error;
    }

    public ParsedTagArray get(String base, String type, String locale, String component, String provider, String filename) {
        return this.get(base, type, locale, component, provider, null, filename);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ParsedTagArray get(String base, String type, String locale, String component, String provider, String clientPath, String filename) {
        TemplateKey tkey = new TemplateKey(base, type, locale, component, provider, clientPath, filename);
        TemplateCacheElement template = (TemplateCacheElement)this.templatesByKey.get(tkey);
        if (template == null || template.expired()) {
            if (this.nonexistCacheCheck(tkey)) throw new ContextError(this.errorString(base, type, locale, component, provider, clientPath, filename, "templatesByKey.get(): template not found"));
            File tk = FileLookup.getFirstExisting(base, type, locale, component, provider, clientPath, filename);
            if (tk == null) {
                this.populateNonexistCache(tkey);
                throw new ContextError(this.errorString(base, type, locale, component, provider, clientPath, filename, "templatesByKey.get(): template not found"));
            }
            template = this.getTemplate(tk);
            if (template == null) {
                throw new ContextError(this.errorString(base, type, locale, component, provider, clientPath, filename, "getTemplate(): returns null"));
            }
            if (template.expired()) {
                template.resetExpireTime();
            }
            this.templatesByKey.put(tkey, template);
            return template.getData();
        } else {
            if (template.getFile() == null || template.getData() != null) return template.getData();
            if ((template = this.getTemplate(template.getFile())) == null) {
                throw new ContextError(this.errorString(base, type, locale, component, provider, clientPath, filename, "getTemplate(): returns null"));
            }
            if (template.expired()) {
                template.resetExpireTime();
            }
            this.templatesByKey.put(tkey, template);
        }
        return template.getData();
    }

    public File getCachedFile(String base, String type, String locale, String component, String provider, String clientPath, String filename) {
        File result = null;
        TemplateKey tkey = new TemplateKey(base, type, locale, component, provider, clientPath, filename);
        TemplateCacheElement template = (TemplateCacheElement)this.templatesByKey.get(tkey);
        if (template == null || template.expired()) {
            if (!this.nonexistCacheCheck(tkey)) {
                result = FileLookup.getFirstExisting(base, type, locale, component, provider, clientPath, filename);
                if (result != null) {
                    template = new TemplateCacheElement(result, result.lastModified(), this.scanInterval);
                    this.templatesByKey.put(tkey, template);
                } else {
                    this.populateNonexistCache(tkey);
                }
            }
        } else {
            result = template.getFile();
            if (result != null && !result.exists()) {
                File tk = FileLookup.getFirstExisting(base, type, locale, component, provider, clientPath, filename);
                if (tk != null) {
                    template = new TemplateCacheElement(tk, tk.lastModified(), this.scanInterval);
                    this.templatesByKey.put(tkey, template);
                } else {
                    this.populateNonexistCache(tkey);
                    this.templatesByKey.remove(tkey);
                }
                this.templatesByFile.remove(result);
                result = tk;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TemplateCacheElement getTemplate(File tk) {
        TemplateCacheElement template = this.getCachedTemplate(tk);
        if (template == null || this.fileHasChanged(template, tk)) {
            FileTemplateContext fileTemplateContext = this;
            synchronized (fileTemplateContext) {
                template = this.getCachedTemplate(tk);
                if ((template == null || this.fileHasChanged(template, tk)) && (template = this.readTemplate(tk)) != null) {
                    this.templatesByFile.put(tk, template);
                }
            }
        }
        return template;
    }

    private boolean fileHasChanged(TemplateCacheElement template, File tk) {
        boolean fileHasChanged = false;
        long cacheModified = template.getLastModified();
        long fileModified = tk.lastModified();
        if (fileModified == 0L || fileModified > cacheModified) {
            fileHasChanged = true;
        }
        return fileHasChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TemplateCacheElement readTemplate(File tk) {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new UnicodeInputStreamReader(new FileInputStream(tk)));
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
        long lastModified = tk.lastModified();
        StringBuffer data = new StringBuffer(256);
        TemplateCacheElement template = null;
        String curLine = null;
        while ((curLine = in.readLine()) != null) {
            data.append(curLine).append("\n");
        }
        ParsedTagArray pta = new ParsedTagArray(data);
        template = new TemplateCacheElement(tk, lastModified, this.scanInterval);
        template.setData(pta);
        Object var10_11 = null;
        if (in == null) return template;
        try {
            in.close();
            return template;
        }
        catch (IOException ioe) {
            return null;
        }
        {
            catch (IOException e) {
                template = null;
                Object var10_12 = null;
                if (in == null) return template;
                try {
                    in.close();
                    return template;
                }
                catch (IOException ioe) {
                    return null;
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ioe) {
                template = null;
            }
            throw throwable;
        }
    }

    private TemplateCacheElement getCachedTemplate(File tk) {
        TemplateCacheElement template = (TemplateCacheElement)this.templatesByFile.get(tk);
        return template;
    }

    private boolean nonexistCacheCheck(TemplateKey tkey) {
        boolean result = false;
        TemplateCacheElement cacheEntry = (TemplateCacheElement)this.nonexistTemplateCacheByKey.get(tkey);
        if (cacheEntry != null) {
            if (cacheEntry.expired()) {
                this.nonexistTemplateCacheByKey.remove(tkey);
            } else if (cacheEntry.getFile() == null && cacheEntry.getLastModified() == -1L) {
                result = true;
            }
        }
        return result;
    }

    private void populateNonexistCache(TemplateKey tkey) {
        TemplateCacheElement cacheEntry = new TemplateCacheElement(null, -1L, this.scanInterval);
        this.nonexistTemplateCacheByKey.put(tkey, cacheEntry);
    }

    private class TemplateCacheElement {
        private long expireTime = 0L;
        private long lastModified = 0L;
        private ParsedTagArray data = null;
        private int scanInterval = 0;
        private File file = null;

        TemplateCacheElement(File f, long last, int scanInterval) {
            this.file = f;
            this.lastModified = last;
            this.scanInterval = scanInterval * 1000;
            this.resetExpireTime();
        }

        long getLastModified() {
            return this.lastModified;
        }

        void setLastModified(long last) {
            this.lastModified = last;
        }

        ParsedTagArray getData() {
            return this.data;
        }

        File getFile() {
            return this.file;
        }

        void setData(ParsedTagArray d) {
            this.data = d;
            this.resetExpireTime();
        }

        boolean expired() {
            return System.currentTimeMillis() > this.expireTime;
        }

        void resetExpireTime() {
            this.expireTime = System.currentTimeMillis() + (long)this.scanInterval;
        }
    }

    private class TemplateKey {
        String base;
        String type;
        String locale;
        String component;
        String provider;
        String clientPath;
        String filename;
        String hashKey;
        int hashCode = -1;

        TemplateKey(String base, String type, String locale, String component, String provider, String clientPath, String filename) {
            this.base = base == null ? "" : base;
            this.type = type == null ? "" : type;
            this.locale = locale == null ? "" : locale;
            this.component = component == null ? "" : component;
            this.provider = provider == null ? "" : provider;
            this.clientPath = clientPath == null ? "" : clientPath;
            this.filename = filename == null ? "" : filename;
            this.hashKey = base + type + locale + component + provider + clientPath + filename;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof TemplateKey)) {
                return false;
            }
            TemplateKey tk = (TemplateKey)obj;
            return this.base.equals(tk.base) && this.type.equals(tk.type) && this.locale.equals(tk.locale) && this.component.equals(tk.component) && this.provider.equals(tk.provider) && this.clientPath.equals(tk.clientPath) && this.filename.equals(tk.filename);
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = this.hashKey.hashCode();
            }
            return this.hashCode;
        }
    }
}

