/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.deployment;

import com.sun.portal.desktop.deployment.CmdVersion;
import com.sun.portal.desktop.deployment.DPRootSpecifier;
import com.sun.portal.desktop.deployment.Par;
import com.sun.portal.desktop.deployment.ParFileException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Vector;

public class CmdOpts {
    public static final int STD_NONE = 0;
    public static final int STD_DPONLY = 1;
    public static final int STD_PARONLY = 2;
    public static final int STD_BOTH = 3;
    public static final int STD_DPOPT = 4;
    public static final int REM_NONE = 0;
    public static final int REM_OPTIONAL = 1;
    public static final int REM_REQUIRED = 3;
    public static final String GLOBAL_DN = "global";
    private HashMap m_Short = new HashMap();
    private Vector m_Remaining = new Vector();
    private boolean m_Modify = false;
    private boolean m_Verbose = false;
    private boolean m_Overwrite = false;
    private boolean m_AutoExtract = false;
    private boolean m_Debug = false;
    private boolean m_Login = false;
    private boolean m_Help = false;
    private boolean m_Version = false;
    private String m_ParFile = null;
    private BufferedReader m_BRd = null;
    private DPRootSpecifier m_DRoot = null;
    private String m_User = null;
    private String m_Pwd = null;
    private String m_DN = null;
    private String m_StaticSub = null;
    private static final String SINGLEPFX = "-";
    private static final String DOUBLEPFX = "--";
    private static final String NEGATEPFX = "--no-";

    private CmdOpts(String[] args, int stdargs, int rem, String allowopts) throws ParFileException {
        int idx;
        this.m_Short.put("r", "runasdn");
        this.m_Short.put("p", "password");
        this.m_Short.put("m", "modify");
        this.m_Short.put("v", "verbose");
        this.m_Short.put("a", "auto");
        this.m_Short.put("o", "overwrite");
        this.m_Short.put("d", "debug");
        this.m_Short.put("s", "static");
        this.m_Short.put("V", "version");
        this.m_Short.put("?", "help");
        block33: for (idx = 0; idx < args.length; ++idx) {
            String opts = this.stripOpt(args[idx], allowopts);
            boolean boolset = true;
            if (opts == null) break;
            if (opts.startsWith("!") && opts.length() > 1) {
                boolset = false;
                opts = opts.substring(1);
            }
            boolean hasarg = false;
            char o1 = opts.charAt(0);
            switch (o1) {
                case 'p': 
                case 'r': 
                case 's': {
                    if (opts.length() > 1) {
                        Object[] tok = new Object[]{args[idx]};
                        throw new ParFileException("errorOptBadArg", tok);
                    }
                    hasarg = true;
                    break;
                }
            }
            if (hasarg && ++idx >= args.length) {
                Object[] tok = new Object[]{args[idx]};
                throw new ParFileException("errorOptNoArg", tok);
            }
            switch (o1) {
                case 'r': {
                    this.m_User = args[idx];
                    continue block33;
                }
                case 'p': {
                    this.m_Pwd = args[idx];
                    continue block33;
                }
                case 's': {
                    this.m_StaticSub = args[idx];
                    continue block33;
                }
                default: {
                    if (hasarg) {
                        throw new ParFileException("errorHasarg");
                    }
                    block34: for (int cidx = 0; cidx < opts.length(); ++cidx) {
                        switch (opts.charAt(cidx)) {
                            case 'm': {
                                this.m_Modify = boolset;
                                continue block34;
                            }
                            case 'v': {
                                this.m_Verbose = boolset;
                                continue block34;
                            }
                            case 'o': {
                                this.m_Overwrite = boolset;
                                continue block34;
                            }
                            case 'a': {
                                this.m_AutoExtract = boolset;
                                continue block34;
                            }
                            case 'd': {
                                this.m_Debug = boolset;
                                continue block34;
                            }
                            case 'V': {
                                this.m_Version = boolset;
                                continue block34;
                            }
                            case '?': {
                                this.m_Help = boolset;
                                continue block34;
                            }
                            default: {
                                Object[] tok = new Object[]{args[idx]};
                                throw new ParFileException("errorOptUnrecognized", tok);
                            }
                        }
                    }
                }
            }
        }
        if (idx < args.length && args[idx].equals(DOUBLEPFX)) {
            ++idx;
        }
        int req = 1;
        this.m_Login = true;
        switch (stdargs) {
            case 0: {
                req = 0;
                this.m_Login = false;
                break;
            }
            case 2: {
                this.m_Login = false;
                break;
            }
            case 3: {
                req = 2;
                break;
            }
        }
        if (args.length - idx < req) {
            throw new ParFileException("errorOptNotEnoughArg");
        }
        switch (stdargs) {
            case 2: 
            case 3: 
            case 4: {
                this.m_ParFile = args[idx];
                ++idx;
                break;
            }
        }
        switch (stdargs) {
            case 1: 
            case 3: {
                this.m_DN = args[idx];
                ++idx;
                break;
            }
            case 4: {
                if (idx >= args.length) break;
                this.m_DN = args[idx];
                ++idx;
                break;
            }
        }
        switch (rem) {
            case 0: {
                if (args.length <= idx) break;
                throw new ParFileException("errorOptUnrecognizedArg");
            }
            case 3: {
                if (args.length > idx) break;
                throw new ParFileException("errorOptNotEnoughArg");
            }
        }
        if (this.m_Login) {
            if (this.m_User == null) {
                this.m_User = this.promptFor("runasdn");
            }
            if (this.m_Pwd == null) {
                throw new ParFileException("errorOptNoPassword");
            }
        }
        while (idx < args.length) {
            this.m_Remaining.add(args[idx]);
            ++idx;
        }
    }

    public static CmdOpts parseOpts(String[] args, int stdargs, int rem, String usage, String allowopts) {
        CmdOpts opts = null;
        allowopts = allowopts + "V?";
        try {
            opts = new CmdOpts(args, stdargs, rem, allowopts);
            if (opts.m_Login) {
                try {
                    if (opts.m_Verbose || opts.m_Debug) {
                        System.out.println(Par.getLocalizedString("msgAuthenticating"));
                    }
                    System.out.println(opts.m_User);
                    System.out.println(opts.m_Pwd);
                    opts.m_DRoot = DPRootSpecifier.makeSpecifier(opts.m_User, opts.m_Pwd);
                    if ((opts.m_Verbose || opts.m_Debug) && opts.m_DN != null) {
                        Object[] tok = new Object[]{opts.m_DN};
                        System.out.println(Par.getLocalizedString("msgAuthenticated", tok));
                    }
                    opts.m_DRoot.setDN(opts.m_DN);
                }
                catch (Exception ex) {
                    opts.produceErrorMessage(ex);
                    return null;
                }
            }
            if (opts.m_Version) {
                CmdVersion.printVersion();
            }
            if (opts.m_Help) {
                CmdOpts.printUsage(System.out, usage, allowopts);
            }
            if (opts.m_Version || opts.m_Help) {
                return null;
            }
            return opts;
        }
        catch (ParFileException pex) {
            Object[] tokerr = new Object[]{pex.getMessage()};
            System.err.println(Par.getLocalizedString("msgCmdError", tokerr));
            CmdOpts.printUsage(System.err, usage, allowopts);
            return null;
        }
    }

    private static void printUsage(PrintStream strm, String usage, String allowopts) {
        Object[] tokusg = new Object[]{usage};
        strm.println(Par.getLocalizedString("msgCmdUsage", tokusg));
        strm.println(Par.getLocalizedString("msgCmdOptions"));
        block12: for (int i = 0; i < allowopts.length(); ++i) {
            char o = allowopts.charAt(i);
            switch (o) {
                case 'r': {
                    strm.println("\t--runasdn <dn>");
                    continue block12;
                }
                case 'p': {
                    strm.println("\t--password <password>");
                    continue block12;
                }
                case 'm': {
                    strm.println("\t--modify");
                    continue block12;
                }
                case 'v': {
                    strm.println("\t--verbose");
                    continue block12;
                }
                case 'o': {
                    strm.println("\t--overwrite");
                    continue block12;
                }
                case 'a': {
                    strm.println("\t--auto");
                    continue block12;
                }
                case 'd': {
                    strm.println("\t--debug");
                    continue block12;
                }
                case 's': {
                    strm.println("\t--static <static subdirectory>");
                    continue block12;
                }
                case '?': {
                    strm.println("\t--help");
                    continue block12;
                }
                case 'V': {
                    strm.println("\t--version");
                    continue block12;
                }
                default: {
                    System.err.println("\tLOGIC ERROR - CmdOpts doesn't recognize '" + o + "'");
                }
            }
        }
    }

    public Vector remaining() {
        return this.m_Remaining;
    }

    public boolean modify() {
        return this.m_Modify;
    }

    public boolean verbose() {
        return this.m_Verbose;
    }

    public boolean overwrite() {
        return this.m_Overwrite;
    }

    public boolean autoextract() {
        return this.m_AutoExtract;
    }

    public String parfile() {
        return this.m_ParFile;
    }

    public String staticsub() {
        return this.m_StaticSub;
    }

    public DPRootSpecifier dproot() {
        return this.m_DRoot;
    }

    public boolean debug() {
        return this.m_Debug;
    }

    public void produceErrorMessage(Exception ex) {
        Object[] tok = new Object[]{ex.getMessage()};
        System.err.println(Par.getLocalizedString("msgCmdError", tok));
        if (this.m_Debug) {
            ex.printStackTrace(System.err);
        }
    }

    private String promptFor(String prompt) throws ParFileException {
        try {
            if (this.m_BRd == null) {
                this.m_BRd = new BufferedReader(new InputStreamReader(System.in));
            }
            for (int i = 0; i < 3; ++i) {
                System.out.print(prompt + ": ");
                String resp = this.m_BRd.readLine();
                if (resp.length() <= 0) continue;
                return resp;
            }
        }
        catch (Exception ex) {
            throw new ParFileException("errorBufferedReader", ex);
        }
        throw new ParFileException("errorPromptFailure");
    }

    private String stripOpt(String arg, String allowopts) throws ParFileException {
        if (arg.startsWith(DOUBLEPFX)) {
            if (arg.equals(DOUBLEPFX)) {
                return null;
            }
            String retpfx = "";
            int plen = DOUBLEPFX.length();
            if (arg.startsWith(NEGATEPFX)) {
                if (arg.equals(NEGATEPFX)) {
                    throw new ParFileException("errorOptNegate");
                }
                retpfx = "!";
                plen = NEGATEPFX.length();
            }
            String ochar = arg.substring(plen, plen + 1);
            String oword = arg.substring(plen);
            String olookup = (String)this.m_Short.get(ochar);
            if (olookup == null || !olookup.equals(oword)) {
                Object[] tok = new Object[]{arg};
                throw new ParFileException("errorUnknownOpt", tok);
            }
            if (allowopts.indexOf(ochar) < 0) {
                Object[] tok = new Object[]{arg};
                throw new ParFileException("errorDisallowedOpt", tok);
            }
            return retpfx + ochar;
        }
        if (arg.startsWith(SINGLEPFX)) {
            for (int i = 1; i < arg.length(); ++i) {
                char o = arg.charAt(i);
                if (allowopts.indexOf(o) >= 0) continue;
                Object[] tok = new Object[]{SINGLEPFX + o};
                throw new ParFileException("errorDisallowedOpt", tok);
            }
            return arg.substring(1);
        }
        return null;
    }
}

