/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.deployment;

import com.sun.portal.desktop.deployment.ParFileException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.StringTokenizer;

public class ExtractOp {
    public static final int TYPE_PROVIDER = 1;
    public static final int TYPE_CHANNEL = 2;
    public static final int ALLTYPES = 3;
    private static final String ARG_DELIM = ",";
    private static final String ARG_EQ = "=";
    private static final String ARG_PROVIDER = "provider";
    private static final String ARG_CHANNEL = "channel";
    private static final String ARG_ENTRY = "entry";
    private static final String ARG_CONTAINER = "container";
    private static final String ARG_AVAIL = "avail";
    private static final String ARG_SELECTED = "selected";
    private static final String ARG_DPNODE = "dpnode";
    private int m_Types;
    private String m_DPNode;
    protected String m_ProviderName = null;
    protected String m_ChannelName = null;
    protected String m_ChannelContainer = null;
    protected String m_AvailContainer = null;
    protected boolean m_MakeSelected = false;
    protected String m_EntryName = null;

    protected ExtractOp(int types, String dpnode) {
        this.m_Types = types;
        this.m_DPNode = dpnode;
    }

    public ExtractOp(ExtractOp op) {
        this.m_Types = 0;
        this.m_DPNode = op.getDPNode();
        this.mergeOp(op);
    }

    public int getTypes() {
        return this.m_Types;
    }

    public String getDPNode() {
        return this.m_DPNode;
    }

    public String getProviderName() {
        return this.m_ProviderName;
    }

    public String getChannelName() {
        return this.m_ChannelName;
    }

    public String getChannelContainer() {
        return this.m_ChannelContainer;
    }

    public String getAvailContainer() {
        return this.m_AvailContainer;
    }

    public boolean getMakeSelected() {
        return this.m_MakeSelected;
    }

    public String getEntryName() {
        return this.m_EntryName;
    }

    public void setEntryName(String name) {
        this.m_EntryName = name;
    }

    public void setDPNode(String dpnode) {
        this.m_DPNode = dpnode;
    }

    public static void describeTypes(StringBuffer bf, int types) {
        String pfx = "";
        if ((types & 1) != 0) {
            bf.append(ARG_PROVIDER);
            pfx = ARG_DELIM;
        }
        if ((types & 2) != 0) {
            bf.append(pfx);
            bf.append(ARG_CHANNEL);
        }
    }

    public void add(ExtractOp op) throws ParFileException {
        if (!this.m_DPNode.equals(op.m_DPNode)) {
            throw new ParFileException("errorXOPSanity");
        }
        if ((this.m_Types & op.m_Types) != 0) {
            throw new ParFileException("errorXOPSanity");
        }
        this.mergeOp(op);
    }

    protected void mergeOp(ExtractOp op) {
        this.m_Types |= op.m_Types;
        if (this.m_ProviderName == null) {
            this.m_ProviderName = op.m_ProviderName;
        }
        if (this.m_ChannelName == null) {
            this.m_ChannelName = op.m_ChannelName;
        }
        if (this.m_ChannelContainer == null) {
            this.m_ChannelContainer = op.m_ChannelContainer;
        }
        if (this.m_AvailContainer == null) {
            this.m_AvailContainer = op.m_AvailContainer;
        }
        this.m_MakeSelected = this.m_MakeSelected || op.m_MakeSelected;
    }

    public String toArg() {
        StringBuffer buf = new StringBuffer();
        buf.append(ARG_DPNODE);
        buf.append(ARG_EQ);
        ExtractOp.argEscape(buf, this.m_DPNode);
        if ((this.m_Types & 1) != 0) {
            buf.append(ARG_DELIM);
            buf.append(ARG_PROVIDER);
            if (this.m_ProviderName != null) {
                buf.append(ARG_EQ);
                ExtractOp.argEscape(buf, this.m_ProviderName);
            }
        }
        if ((this.m_Types & 2) != 0) {
            buf.append(ARG_DELIM);
            buf.append(ARG_CHANNEL);
            if (this.m_ChannelName != null) {
                buf.append(ARG_EQ);
                ExtractOp.argEscape(buf, this.m_ChannelName);
            }
        }
        if (this.m_EntryName != null) {
            buf.append(ARG_DELIM);
            buf.append(ARG_ENTRY);
            buf.append(ARG_EQ);
            ExtractOp.argEscape(buf, this.m_EntryName);
        }
        if (this.m_ChannelContainer != null) {
            buf.append(ARG_DELIM);
            buf.append(ARG_CONTAINER);
            buf.append(ARG_EQ);
            ExtractOp.argEscape(buf, this.m_ChannelContainer);
            if (this.m_AvailContainer != null) {
                buf.append(ARG_DELIM);
                buf.append(ARG_AVAIL);
                buf.append(ARG_EQ);
                ExtractOp.argEscape(buf, this.m_AvailContainer);
                if (this.m_MakeSelected) {
                    buf.append(ARG_DELIM);
                    buf.append(ARG_SELECTED);
                }
            }
        }
        return buf.toString();
    }

    public static ExtractOp makeOpFromArgument(String arg) throws ParFileException {
        return ExtractOp.makeOpFromArgument(null, arg);
    }

    public static ExtractOp makeOpFromArgument(String dpnode, String arg) throws ParFileException {
        ExtractOp op;
        StringTokenizer tok = new StringTokenizer(arg, ARG_DELIM);
        ExtractOp extractOp = op = dpnode == null ? null : new ExtractOp(0, dpnode);
        while (tok.hasMoreTokens()) {
            String key = tok.nextToken();
            String val = null;
            int vidx = key.indexOf(ARG_EQ);
            if (vidx > 0) {
                val = ExtractOp.argUnEscape(key.substring(vidx + 1));
                key = key.substring(0, vidx);
            }
            if (op == null) {
                if (key.equalsIgnoreCase(ARG_DPNODE)) {
                    if (val == null) {
                        throw new ParFileException("errorXOPSyntax");
                    }
                    op = new ExtractOp(0, val);
                    continue;
                }
                throw new ParFileException("errorXOPSyntax");
            }
            if (key.equalsIgnoreCase(ARG_CHANNEL)) {
                op.m_Types |= 2;
                op.m_ChannelName = val;
                continue;
            }
            if (key.equalsIgnoreCase(ARG_PROVIDER)) {
                op.m_Types |= 1;
                op.m_ProviderName = val;
                continue;
            }
            if (key.equalsIgnoreCase(ARG_ENTRY)) {
                op.m_EntryName = val;
                continue;
            }
            if (key.equalsIgnoreCase(ARG_CONTAINER)) {
                op.m_ChannelContainer = val;
                continue;
            }
            if (key.equalsIgnoreCase(ARG_AVAIL)) {
                op.m_AvailContainer = val;
                continue;
            }
            if (key.equalsIgnoreCase(ARG_SELECTED)) {
                op.m_MakeSelected = val == null ? true : Boolean.valueOf(val);
                continue;
            }
            throw new ParFileException("errorXOPSyntax");
        }
        if (op == null) {
            throw new ParFileException("errorXOPSyntax");
        }
        return op;
    }

    private static void argEscape(StringBuffer buf, String val) {
        buf.append(URLEncoder.encode(val));
    }

    private static String argUnEscape(String val) throws ParFileException {
        try {
            return URLDecoder.decode(val);
        }
        catch (Exception ex) {
            throw new ParFileException("errorXOPSyntax", ex);
        }
    }
}

