/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.util;

import com.sun.portal.desktop.util.NSStringBuffer;
import java.io.IOException;
import java.io.StringWriter;

public class NSStringWriter
extends StringWriter {
    private NSStringBuffer buf;
    private boolean isClosed = false;

    private void ensureOpen() {
    }

    public NSStringWriter() {
        this.buf = new NSStringBuffer();
        this.lock = this.buf;
    }

    public NSStringWriter(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("Negative buffer size");
        }
        this.buf = new NSStringBuffer(initialSize);
        this.lock = this.buf;
    }

    public void write(int c) {
        this.ensureOpen();
        this.buf.append((char)c);
    }

    public void write(char[] cbuf, int off, int len) {
        this.ensureOpen();
        if (off < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (off + len > cbuf.length) {
            throw new IndexOutOfBoundsException();
        }
        this.buf.append(cbuf, off, len);
    }

    public void write(String str) {
        this.ensureOpen();
        this.buf.append(str);
    }

    public void write(String str, int off, int len) {
        this.ensureOpen();
        this.buf.append(str.substring(off, off + len));
    }

    public String toString() {
        return this.buf.toString();
    }

    public StringBuffer getBuffer() {
        return this.buf.toStringBuffer();
    }

    public void flush() {
        this.ensureOpen();
    }

    public void close() throws IOException {
        this.isClosed = true;
    }
}

