/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.containers.jsp.tab.util;

import com.sun.portal.desktop.DesktopRequestThreadLocalizer;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.containers.jsp.tab.ModifiableTab;
import com.sun.portal.providers.containers.jsp.tab.util.TabException;
import com.sun.portal.providers.context.ContainerProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import java.util.HashMap;
import java.util.Map;

class Tab
implements ModifiableTab {
    protected String name = null;
    protected String displayname = null;
    protected String desc = null;
    protected boolean removable = false;
    protected boolean renamable = false;
    protected boolean predefined = true;
    private ContainerProviderContext cpc;
    private String channel = null;

    Tab(String n, String d, String dn, boolean rem, boolean ren, boolean pd, ContainerProviderContext cpc, String channel) throws TabException {
        this.name = n;
        this.desc = d;
        this.displayname = dn;
        this.removable = rem;
        this.renamable = ren;
        this.predefined = pd;
        this.cpc = cpc;
        this.channel = channel;
    }

    Tab(String t, ContainerProviderContext cpc, String channel, Map props) throws TabException {
        this.cpc = cpc;
        this.channel = channel;
        this.displayname = this.getTabTitle(t, props);
        this.desc = this.getTabDesc(t, props);
        this.create(t, props);
    }

    private void create(String t, Map props) throws TabException {
        this.name = t;
        if (props.containsKey(t)) {
            Map tab = (Map)props.get(t);
            this.removable = (Boolean)tab.get("removable");
            this.renamable = (Boolean)tab.get("renamable");
            this.predefined = (Boolean)tab.get("predefined");
        }
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public boolean isRenamable() {
        return this.renamable;
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getDisplayname() {
        return this.displayname;
    }

    public void setDisplayname(String n) {
        this.displayname = n;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String d) {
        this.desc = d;
    }

    public String getEncodedName() {
        return this.cpc.encodeURLParameter(this.name);
    }

    public Map getTabMap() {
        HashMap<String, Boolean> tabMap = new HashMap<String, Boolean>();
        tabMap.put("removable", new Boolean(this.isRemovable()));
        tabMap.put("renamable", new Boolean(this.isRenamable()));
        tabMap.put("predefined", new Boolean(this.isPredefined()));
        return tabMap;
    }

    private String getTabTitle(String tab, Map props) {
        String title = null;
        try {
            if (this.cpc.getProviderVersion(this.channel) <= 1) {
                if (props.containsKey(tab)) {
                    Map tabProps = (Map)props.get(tab);
                    title = (String)tabProps.get("title");
                }
            } else {
                Provider p = this.cpc.getProvider(DesktopRequestThreadLocalizer.getRequest(), this.channel, tab);
                title = p.getTitle();
            }
        }
        catch (ProviderContextException pce) {
            return tab;
        }
        catch (ProviderException pce) {
            return tab;
        }
        if (title != null && title.length() != 0) {
            return title;
        }
        return tab;
    }

    private String getTabDesc(String tab, Map props) {
        String desc = null;
        try {
            if (this.cpc.getProviderVersion(this.channel) <= 1) {
                if (props.containsKey(tab)) {
                    Map tabProps = (Map)props.get(tab);
                    desc = (String)tabProps.get("desc");
                }
            } else {
                Provider p = this.cpc.getProvider(DesktopRequestThreadLocalizer.getRequest(), this.channel, tab);
                desc = p.getDescription();
            }
        }
        catch (ProviderContextException pce) {
            return tab;
        }
        catch (ProviderException pce) {
            return tab;
        }
        if (desc != null && desc.length() != 0) {
            return desc;
        }
        return tab;
    }
}

