/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.tools;

import com.sun.webui.tools.ToolsBase;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.imageio.ImageIO;

public class CombineImages
extends ToolsBase {
    private String imagePropertyFile;
    private String imageFile;

    public CombineImages(String sourceDir, String imagePropertyFile, String imageFile, String outFile) {
        super(sourceDir, false, null);
        this.setOutFile(outFile);
        this.imagePropertyFile = imagePropertyFile;
        this.imageFile = imageFile;
    }

    public void process() {
        Properties imageProps = this.readImageProperties(this.imagePropertyFile);
        Map imagePaths = this.getImagePaths(imageProps);
        this.combineImages(imageProps, imagePaths);
        this.writeProperties(imageProps, this.getOutFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readImageProperties(String imageProperties) {
        File fl = null;
        FileInputStream fi = null;
        Properties imageProps = null;
        try {
            fl = new File(imageProperties);
            fi = new FileInputStream(fl);
            imageProps = new Properties();
            imageProps.load(fi);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        finally {
            if (fi != null) {
                try {
                    fi.close();
                }
                catch (Exception e) {}
            }
        }
        return imageProps;
    }

    private Map getImagePaths(Properties properties) {
        TreeMap<String, String> imagePaths = new TreeMap<String, String>();
        try {
            Enumeration<Object> keys = properties.keys();
            boolean i = false;
            String key = null;
            String value = null;
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                value = properties.getProperty(key);
                if (value != null && value.trim().length() == 0) {
                    System.out.println("CombineImages: WARNING: key == " + key + " has no path value.");
                    continue;
                }
                if (key == null || key.endsWith("_HEIGHT") || key.endsWith("_WIDTH") || key.endsWith("_MAP") || key.endsWith("_ALT") || key.endsWith("_TOP") || key.endsWith("_TITLE")) continue;
                imagePaths.put(key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return imagePaths;
    }

    private void combineImages(Properties imageProps, Map imagePaths) {
        BufferedImage[] images = new BufferedImage[imagePaths.size() + 1];
        int maxWidth = 0;
        int maxHeight = 0;
        int[] top = new int[imagePaths.size() + 1];
        int i = 0;
        for (Map.Entry entry : imagePaths.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value != null && value.trim().length() == 0) continue;
            File fl = null;
            try {
                fl = new File(this.getSourceDir() + File.separator + value);
                images[i] = ImageIO.read(fl);
            }
            catch (Exception e) {
                System.out.println("CombineImages: FATAL ERROR: Image " + value + " does not exist.");
                e.printStackTrace();
                System.exit(-1);
            }
            int height = images[i].getHeight();
            int width = images[i].getWidth();
            maxHeight += height;
            if (i > 0) {
                top[i] = top[i - 1] + images[i - 1].getHeight();
            } else {
                top[0] = 0;
            }
            maxWidth = width > maxWidth ? width : maxWidth;
            imageProps.setProperty(key + "_MAP_HEIGHT", Integer.toString(height));
            imageProps.setProperty(key + "_MAP_WIDTH", Integer.toString(width));
            imageProps.setProperty(key + "_MAP_TOP", Integer.toString(-top[i]));
            ++i;
        }
        BufferedImage cmbImage = new BufferedImage(maxWidth, maxHeight, 3);
        Graphics2D createImage = cmbImage.createGraphics();
        for (int j = 0; j < i; ++j) {
            createImage.drawImage((Image)images[j], 0, top[j], null);
        }
        createImage.dispose();
        try {
            File fl = new File(this.imageFile);
            ImageIO.write((RenderedImage)cmbImage, "png", fl);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProperties(Properties imageProperties, File outFile) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outFile.getCanonicalPath());
            imageProperties.store(out, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

