/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.tools;

import com.sun.webui.tools.ToolsBase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeSet;

public class CombineJavaScript
extends ToolsBase {
    private StringBuffer outputBuffer = null;
    private String modulePrefix = null;

    public CombineJavaScript(String sourceDir, boolean verbose, String copyrightFile, String outFile, String modulePrefix) {
        super(sourceDir, verbose, copyrightFile);
        this.setOutFile(outFile);
        this.modulePrefix = modulePrefix;
    }

    protected void excludeFile(File file) throws IOException {
        if (!this.isFileAvailable(file)) {
            return;
        }
        BufferedReader input = new BufferedReader(new FileReader(file));
        String line = null;
        while ((line = input.readLine()) != null) {
            if (line.indexOf(this.modulePrefix + "._dojo.require") != 0) continue;
            int first = line.indexOf("\"") + this.modulePrefix.length();
            int last = line.indexOf("\"", first + 1);
            String fileName = line.substring(first + 1, last).replace('.', File.separatorChar) + ".js";
            this.excludeFile(new File(this.getSourceDir() + fileName));
        }
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected StringBuffer getOutBuffer() throws IOException {
        if (this.outputBuffer == null) {
            this.outputBuffer = new StringBuffer(1024);
        }
        return this.outputBuffer;
    }

    public void process(String[] fileList, String[] excludeFileList) throws IOException {
        if (fileList == null) {
            return;
        }
        if (excludeFileList != null) {
            for (int i = 0; i < excludeFileList.length; ++i) {
                this.excludeFile(new File(this.getSourceDir() + File.separator + excludeFileList[i]));
            }
        }
        TreeSet<String> ts = new TreeSet<String>();
        for (int i = 0; i < fileList.length; ++i) {
            ts.add(this.getSourceDir() + File.separator + fileList[i]);
        }
        try {
            Iterator files = ts.iterator();
            while (files.hasNext()) {
                this.processFile(new File((String)files.next()));
            }
            this.writeOutFile(this.getOutFile(), this.getOutBuffer().toString(), true);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected boolean processFile(File file) throws IOException {
        if (!this.isFileAvailable(file)) {
            return false;
        }
        BufferedReader input = new BufferedReader(new FileReader(file));
        StringBuffer buff = this.getOutBuffer();
        String line = null;
        while ((line = input.readLine()) != null) {
            boolean omitLine = false;
            if (line.indexOf(this.modulePrefix + "._dojo.require") == 0) {
                int first = line.indexOf("\"") + this.modulePrefix.length();
                int last = line.indexOf("\"", first + 1);
                String fileName = line.substring(first + 1, last).replace('.', File.separatorChar) + ".js";
                omitLine = this.processFile(new File(this.getSourceDir() + fileName));
            }
            if (omitLine) continue;
            buff.append(line);
            buff.append(System.getProperty("line.separator"));
        }
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.isVerbose()) {
            System.out.println("Combined JavaScript file '" + file.getCanonicalPath() + "'");
        }
        return true;
    }
}

