/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.tools;

import com.sun.webui.tools.ExecProcess;
import com.sun.webui.tools.ToolsBase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class CompressJavaScript
extends ToolsBase {
    private String rhinoJar = null;

    public CompressJavaScript(String sourceDir, boolean verbose, String copyrightFile, String destDir, String rhinoJar) {
        super(sourceDir, verbose, copyrightFile);
        this.setDestDir(destDir);
        this.rhinoJar = rhinoJar;
    }

    public void process(String[] fileList) throws IOException {
        for (int i = 0; i < fileList.length; ++i) {
            try {
                File inFile = new File(this.getSourceDir() + File.separator + fileList[i]);
                File outFile = new File(this.getDestDir() + File.separator + fileList[i]);
                this.processFile(inFile, outFile);
                continue;
            }
            catch (Exception e) {
                throw new IOException("Cannot compress " + this.getSourceDir() + File.separator + fileList[i] + " to " + this.getDestDir() + File.separator + fileList[i]);
            }
        }
    }

    protected void processFile(File inFile, File outFile) throws IOException {
        if (!this.isFileAvailable(inFile)) {
            return;
        }
        String cmd = "java -jar " + this.rhinoJar + " -strict -opt -1 -o " + outFile.getAbsolutePath() + " -c " + inFile.getAbsolutePath();
        ExecProcess ep = new ExecProcess(cmd);
        int returnVal = ep.exec();
        if (returnVal != 0) {
            System.exit(returnVal);
        }
        this.pruneFile(outFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pruneFile(File file) throws IOException {
        StringBuffer buff = new StringBuffer(1024);
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = input.readLine()) != null) {
                buff.append(line);
            }
            this.writeOutFile(file, buff.toString(), false);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

