/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.tools;

import com.sun.webui.tools.ToolsBase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.zip.GZIPOutputStream;

public class GzipFiles
extends ToolsBase {
    private ArrayList combinedFiles = new ArrayList();
    public String GZ_EXT = ".gz";

    public GzipFiles(String sourceDir, boolean verbose, String destDir) {
        super(sourceDir, verbose, null);
        this.setDestDir(destDir);
    }

    public void process(String[] fileList) throws IOException {
        String srcFilePath = "";
        String destFilePath = "";
        for (int i = 0; i < fileList.length; ++i) {
            srcFilePath = this.getSourceDir() + File.separator + fileList[i];
            destFilePath = this.getDestDir() + File.separator + fileList[i] + this.GZ_EXT;
            this.processFile(srcFilePath, destFilePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFile(String src, String dest) throws IOException {
        File srcFile = new File(src);
        File destFile = new File(dest);
        OutputStreamWriter output = null;
        StringBuffer buff = new StringBuffer();
        BufferedReader input = null;
        FileOutputStream destOut = new FileOutputStream(destFile);
        GZIPOutputStream gzOut = new GZIPOutputStream(destOut);
        try {
            input = new BufferedReader(new FileReader(srcFile));
            String line = null;
            while ((line = input.readLine()) != null) {
                buff.append(line);
                buff.append(System.getProperty("line.separator"));
            }
            output = new OutputStreamWriter(gzOut);
            output.write(buff.toString());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.isVerbose()) {
            System.out.println("GZIP'ed file '" + destFile.getCanonicalPath() + "'");
        }
    }
}

