/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.tools;

import com.sun.webui.tools.CombineCSS;
import com.sun.webui.tools.CombineImages;
import com.sun.webui.tools.CombineJavaScript;
import com.sun.webui.tools.CombineSdoc;
import com.sun.webui.tools.CompressCSS;
import com.sun.webui.tools.CompressJavaScript;
import com.sun.webui.tools.GzipFiles;
import com.sun.webui.tools.Native2ascii;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class Main {
    private static final String n2aUsage = "Usage: java com.sun.webui.tools.Native2ascii [-encoding <encoding>]\n[-reverse] -sourceDir <sourceDir> -destDir <destDir>\n -fileList <f0, ... fn>\nUTF-8 is the default encoding";

    public static void combineCSS(String[] args) throws IOException {
        String copyrightFile = null;
        String[] excludeFileList = null;
        String[] fileList = null;
        String outFile = null;
        String sourceDir = null;
        boolean verbose = false;
        Map map = Main.parseFileListArgs(args);
        fileList = (String[])map.get("fileList");
        if (null == fileList || fileList.length == 0) {
            System.out.println("A non emtpy file list is required.");
            Main.usage();
            System.exit(-1);
        }
        if (null == (outFile = (String)map.get("outFile"))) {
            System.out.println("-outFile is required.");
            Main.usage();
            System.exit(-1);
        }
        if (null == (sourceDir = (String)map.get("sourceDir"))) {
            System.out.println("-sourceDir is required.");
            Main.usage();
            System.exit(-1);
        }
        copyrightFile = (String)map.get("copyrightFile");
        excludeFileList = (String[])map.get("excludeFileList");
        verbose = (Boolean)map.get("verbose");
        CombineCSS obj = new CombineCSS(sourceDir, verbose, copyrightFile, outFile);
        obj.process(fileList, excludeFileList);
    }

    public static void compressCSS(String[] args) throws IOException {
        String copyrightFile = null;
        String destDir = null;
        String[] fileList = null;
        String sourceDir = null;
        boolean verbose = false;
        Map map = Main.parseFileListArgs(args);
        destDir = (String)map.get("destDir");
        if (null == destDir) {
            System.out.println("-destDir is required.");
            Main.usage();
            System.exit(-1);
        }
        if (null == (fileList = (String[])map.get("fileList")) || fileList.length == 0) {
            System.out.println("A non emtpy file list is required.");
            Main.usage();
            System.exit(-1);
        }
        if (null == (sourceDir = (String)map.get("sourceDir"))) {
            System.out.println("-sourceDir is required.");
            Main.usage();
            System.exit(-1);
        }
        copyrightFile = (String)map.get("copyrightFile");
        verbose = (Boolean)map.get("verbose");
        CompressCSS obj = new CompressCSS(sourceDir, verbose, copyrightFile, destDir);
        obj.process(fileList);
    }

    public static void combineJavaScript(String[] args) throws IOException {
        String copyrightFile = null;
        String[] excludeFileList = null;
        String[] fileList = null;
        String modulePrefix = null;
        String outFile = null;
        String sourceDir = null;
        boolean verbose = false;
        Map map = Main.parseFileListArgs(args);
        fileList = (String[])map.get("fileList");
        if (null == fileList || fileList.length == 0) {
            System.out.println("A non emtpy file list is required.");
            Main.usage();
            System.exit(-1);
        }
        if (null == (modulePrefix = (String)map.get("modulePrefix"))) {
            System.out.println("-modulePrefix is required.");
            Main.usage();
            System.exit(-1);
        }
        if (null == (outFile = (String)map.get("outFile"))) {
            System.out.println("-outFile is required.");
            Main.usage();
            System.exit(-1);
        }
        if (null == (sourceDir = (String)map.get("sourceDir"))) {
            System.out.println("-sourceDir is required.");
            Main.usage();
            System.exit(-1);
        }
        copyrightFile = (String)map.get("copyrightFile");
        excludeFileList = (String[])map.get("excludeFileList");
        verbose = (Boolean)map.get("verbose");
        CombineJavaScript obj = new CombineJavaScript(sourceDir, verbose, copyrightFile, outFile, modulePrefix);
        obj.process(fileList, excludeFileList);
    }

    public static void combineSdoc(String[] args) throws IOException {
        String copyrightFile = null;
        String[] fileList = null;
        String outFile = null;
        String sourceDir = null;
        boolean verbose = false;
        Map map = Main.parseFileListArgs(args);
        fileList = (String[])map.get("fileList");
        if (null == fileList || fileList.length == 0) {
            System.out.println("A non emtpy file list is required.");
            Main.usage();
            System.exit(-1);
        }
        if (null == (outFile = (String)map.get("outFile"))) {
            System.out.println("-outFile is required.");
            Main.usage();
            System.exit(-1);
        }
        if (null == (sourceDir = (String)map.get("sourceDir"))) {
            System.out.println("-sourceDir is required.");
            Main.usage();
            System.exit(-1);
        }
        copyrightFile = (String)map.get("copyrightFile");
        verbose = (Boolean)map.get("verbose");
        CombineSdoc obj = new CombineSdoc(sourceDir, verbose, copyrightFile, outFile);
        obj.process(fileList, null);
    }

    public static void compressJavaScript(String[] args) throws IOException {
        String copyrightFile = null;
        String destDir = null;
        String[] fileList = null;
        String rhinoJar = null;
        String sourceDir = null;
        boolean verbose = false;
        Map map = Main.parseFileListArgs(args);
        fileList = (String[])map.get("fileList");
        if (null == fileList || fileList.length == 0) {
            System.out.println("A non emtpy file list is required.");
            Main.usage();
            System.exit(-1);
        }
        if (null == (destDir = (String)map.get("destDir"))) {
            System.out.println("-destDir is required.");
            Main.usage();
            System.exit(-1);
        }
        if (null == (rhinoJar = (String)map.get("rhinoJar"))) {
            System.out.println("-rhinoJar is required.");
            Main.usage();
            System.exit(-1);
        }
        if (null == (sourceDir = (String)map.get("sourceDir"))) {
            System.out.println("-sourceDir is required.");
            Main.usage();
            System.exit(-1);
        }
        copyrightFile = (String)map.get("copyrightFile");
        verbose = (Boolean)map.get("verbose");
        CompressJavaScript obj = new CompressJavaScript(sourceDir, verbose, copyrightFile, destDir, rhinoJar);
        obj.process(fileList);
    }

    public static void native2ascii(String[] args) {
        Map map;
        String sourceDir = null;
        String destDir = null;
        String[] fileList = null;
        String encoding = null;
        boolean reverse = false;
        if (args.length < 4) {
            System.out.println(n2aUsage);
            System.exit(-1);
        }
        if (null == (sourceDir = (String)(map = Main.parseFileListArgs(args)).get("sourceDir"))) {
            System.out.println("-sourceDir is required.\nUsage: java com.sun.webui.tools.Native2ascii [-encoding <encoding>]\n[-reverse] -sourceDir <sourceDir> -destDir <destDir>\n -fileList <f0, ... fn>\nUTF-8 is the default encoding");
            System.exit(-1);
        }
        if (null == (destDir = (String)map.get("destDir"))) {
            System.out.println("-destDir is required.\nUsage: java com.sun.webui.tools.Native2ascii [-encoding <encoding>]\n[-reverse] -sourceDir <sourceDir> -destDir <destDir>\n -fileList <f0, ... fn>\nUTF-8 is the default encoding");
            System.exit(-1);
        }
        if (null == (fileList = (String[])map.get("fileList")) || fileList.length == 0) {
            System.out.println("A non emtpy file list is required.\nUsage: java com.sun.webui.tools.Native2ascii [-encoding <encoding>]\n[-reverse] -sourceDir <sourceDir> -destDir <destDir>\n -fileList <f0, ... fn>\nUTF-8 is the default encoding");
            System.exit(-1);
        }
        for (int i = 1; i < args.length; ++i) {
            try {
                if (args[i].equals("-sourceDir") || args[i].equals("-destDir") || args[i].equals("-fileList")) {
                    ++i;
                    continue;
                }
                if (args[i].equals("-reverse")) {
                    reverse = true;
                    continue;
                }
                if (args[i].equals("-encoding")) {
                    encoding = args[i + 1].trim();
                    Main.validString(encoding);
                    ++i;
                    continue;
                }
                System.out.println("Unknown arguement " + args[i] + "\n" + n2aUsage);
                System.exit(-1);
                continue;
            }
            catch (Exception e) {
                System.out.println("Invalid argument value for " + args[i] + "\n" + n2aUsage);
                System.exit(-1);
            }
        }
        Native2ascii n2a = null;
        try {
            n2a = new Native2ascii(encoding, reverse, sourceDir, destDir, fileList);
            n2a.convertAll();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static void combineImages(String[] args) {
        String sourceDir = null;
        String imageFile = null;
        String imagePropertyFile = null;
        String outFile = null;
        for (int i = 1; i < args.length; ++i) {
            try {
                if (args[i].equals("-sourceDir")) {
                    sourceDir = args[i + 1].trim();
                    Main.validString(sourceDir);
                    ++i;
                    continue;
                }
                if (args[i].equals("-imageFile")) {
                    imageFile = args[i + 1].trim();
                    Main.validString(imageFile);
                    ++i;
                    continue;
                }
                if (args[i].equals("-imagePropertyFile")) {
                    imagePropertyFile = args[i + 1].trim();
                    Main.validString(imagePropertyFile);
                    ++i;
                    continue;
                }
                if (args[i].equals("-outFile")) {
                    outFile = args[i + 1].trim();
                    Main.validString(outFile);
                    ++i;
                    continue;
                }
                System.out.println("Unknown arguement " + args[i]);
                Main.usage();
                System.exit(-1);
                continue;
            }
            catch (Exception e) {
                System.out.println("Invalid argument value for " + args[i]);
                Main.usage();
                System.exit(-1);
            }
        }
        CombineImages ci = new CombineImages(sourceDir, imagePropertyFile, imageFile, outFile);
        ci.process();
    }

    private static void gzipFiles(String[] args) {
        String[] fileList = null;
        String sourceDir = null;
        String destDir = null;
        boolean verbose = false;
        Map map = Main.parseFileListArgs(args);
        fileList = (String[])map.get("fileList");
        if (null == fileList || fileList.length == 0) {
            System.out.println("A non emtpy file list is required.");
            Main.usage();
            System.exit(-1);
        }
        if (null == (sourceDir = (String)map.get("sourceDir"))) {
            System.out.println("-sourceDir is required.");
            Main.usage();
            System.exit(-1);
        }
        if (null == (destDir = (String)map.get("destDir"))) {
            System.out.println("-destDir is required.");
            Main.usage();
            System.exit(-1);
        }
        verbose = (Boolean)map.get("verbose");
        try {
            GzipFiles obj = new GzipFiles(sourceDir, verbose, destDir);
            obj.process(fileList);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void usage() {
        System.out.println("java -jar jarFile <args...>");
        System.out.println("\nwhere options include:");
        System.out.println("-combineCSS <args...>\t\tCombine CSS directory or file.");
        System.out.println("-compressCSS <args...>\t\tCompress CSS directory or file.");
        System.out.println("-combineJavaScript <args...>\t\tCombine JavaScript directory or file.");
        System.out.println("-compressJavaScript <args...>\t\tCompress JavaScript directory or file.");
        System.out.println("-native2ascii <args...>\t\tConvert native encoded file to unicode escapes or vice versa.");
        System.out.println("-gzipFiles <args...>\t\tCompress a list of files using the gzip compression format.");
        System.out.println("\nOptions for -combineCSS include:");
        System.out.println("-fileList <f0,...,fn>\tA comma separated list of relative file paths to combine.");
        System.out.println("-excludeFileList <f0,...,fn>\tA comma separated list of relative file paths to exclude.");
        System.out.println("-outFile <outFile>\tFile path for combined output.");
        System.out.println("-sourceDir <sourceDir>\tDirectory containing the files in fileList.");
        System.out.println("-copyrightFile <copyrightFile>\tFile path for copyright file. Duplicate text is omitted from the combined file.");
        System.out.println("-verbose\tEnable verbose output.");
        System.out.println("\nOptions for -compressCSS include:");
        System.out.println("-fileList <f0,...,fn>\tA comma separated list of relative file paths to combine.");
        System.out.println("-excludeFileList <f0,...,fn>\tA comma separated list of relative file paths to exclude.");
        System.out.println("-sourceDir <sourceDir>\tDirectory containing the files in fileList.");
        System.out.println("-copyrightFile <copyrightFile>\tFile path for copyright file. Duplicate text is omitted from the combined file.");
        System.out.println("-verbose\tEnable verbose output.");
        System.out.println("\nOptions for -combineJS include:");
        System.out.println("-fileList <f0,...,fn>\tA comma separated list of relative file paths to combine.");
        System.out.println("-excludeFileList <f0,...,fn>\tA comma separated list of relative file paths to exclude.");
        System.out.println("-modulePrefix <modulePrefix>\tThe JavaScript prefix for module sources.");
        System.out.println("-outFile <outFile>\tFile path for combined output.");
        System.out.println("-sourceDir <sourceDir>\tDirectory containing the files in fileList.");
        System.out.println("-copyrightFile <copyrightFile>\tFile path for copyright file. Duplicate text is omitted from the combined file.");
        System.out.println("-verbose\tEnable verbose output.");
        System.out.println("\nOptions for -combineSdoc include:");
        System.out.println("-fileList <f0,...,fn>\tA comma separated list of relative file paths to combine.");
        System.out.println("-outFile <outFile>\tFile path for combined output.");
        System.out.println("-sourceDir <sourceDir>\tDirectory containing the files in fileList.");
        System.out.println("-copyrightFile <copyrightFile>\tFile path for copyright file. Duplicate text is omitted from the combined file.");
        System.out.println("-verbose\tEnable verbose output.");
        System.out.println("\nOptions for -compressJS include:");
        System.out.println("-fileList <f0,...,fn>\tA comma separated list of relative file paths to compress.");
        System.out.println("-destDir <destDir>\tDirectory where compressed files are written.");
        System.out.println("-rhinoJar <rhinoJar>\tJar file containing the Rhino compression tool.");
        System.out.println("-sourceDir <sourceDir>\tDirectory containing the files in fileList.");
        System.out.println("-verbose\tEnable verbose output.");
        System.out.println("\nOptions for -combineImages include:");
        System.out.println("-sourceDir <sourceDir>\tDirectory containing the image files.");
        System.out.println("-imageFile\tFile path for combined image output.");
        System.out.println("-imagePropertyFile\tFile path for image properties file.");
        System.out.println("-outFile\tFile path for updated image properties file.");
        System.out.println("\nOptions for -native2ascii include:");
        System.out.println("-sourceDir <sourceDir>\tDirectory containing files in fileList.");
        System.out.println("-destDir <destDir>\tDirectory where converted files are written.");
        System.out.println("-fileList <f0,...,fn>\tA comma separated list of relative file paths to convert.");
        System.out.println("[-encoding <encoding>]\tThe encoding to convert from or to.UTF-8 is the default encoding");
        System.out.println("[-reverse]\tConvert fileList to encoding");
        System.out.println("\nOptions for -gzipFiles include:");
        System.out.println("-fileList <f0,...,fn>\tA comma separated list of relative file paths to compress.");
        System.out.println("-destDir <outFile> <destinationDir>\tDirectory where compressed files will created.");
        System.out.println("-sourceDir <sourceDir>\tDirectory containing the files in fileList.");
        System.out.println("-verbose\tEnable verbose output.");
    }

    public static void main(String[] args) throws IOException {
        if (args.length > 0) {
            if (args[0].equals("-combineCSS")) {
                Main.combineCSS(args);
            } else if (args[0].equals("-compressCSS")) {
                Main.compressCSS(args);
            } else if (args[0].equals("-combineJS")) {
                Main.combineJavaScript(args);
            } else if (args[0].equals("-combineSdoc")) {
                Main.combineSdoc(args);
            } else if (args[0].equals("-compressJS")) {
                Main.compressJavaScript(args);
            } else if (args[0].equals("-native2ascii")) {
                Main.native2ascii(args);
            } else if (args[0].equals("-combineImages")) {
                Main.combineImages(args);
            } else if (args[0].equals("-gzipFiles")) {
                Main.gzipFiles(args);
            } else {
                Main.usage();
            }
        } else {
            Main.usage();
        }
    }

    private static Map parseFileListArgs(String[] args) {
        String copyrightFile = null;
        String destDir = null;
        String excludeFileList = null;
        String fileList = null;
        String modulePrefix = null;
        String outFile = null;
        String rhinoJar = null;
        String sourceDir = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (args.length < 4) {
            return map;
        }
        for (int i = 1; i < args.length; ++i) {
            try {
                if (args[i].equals("-fileList")) {
                    fileList = args[i + 1].trim();
                    Main.validString(fileList);
                    ++i;
                    continue;
                }
                if (args[i].equals("-destDir")) {
                    destDir = args[i + 1].trim();
                    Main.validString(destDir);
                    map.put("destDir", destDir);
                    ++i;
                    continue;
                }
                if (args[i].equals("-excludeFileList")) {
                    excludeFileList = args[i + 1].trim();
                    Main.validString(excludeFileList);
                    ++i;
                    continue;
                }
                if (args[i].equals("-modulePrefix")) {
                    modulePrefix = args[i + 1].trim();
                    Main.validString(modulePrefix);
                    map.put("modulePrefix", modulePrefix);
                    ++i;
                    continue;
                }
                if (args[i].equals("-outFile")) {
                    outFile = args[i + 1].trim();
                    Main.validString(outFile);
                    map.put("outFile", outFile);
                    ++i;
                    continue;
                }
                if (args[i].equals("-copyrightFile")) {
                    copyrightFile = args[i + 1].trim();
                    Main.validString(copyrightFile);
                    map.put("copyrightFile", copyrightFile);
                    ++i;
                    continue;
                }
                if (args[i].equals("-rhinoJar")) {
                    rhinoJar = args[i + 1].trim();
                    Main.validString(rhinoJar);
                    map.put("rhinoJar", rhinoJar);
                    ++i;
                    continue;
                }
                if (args[i].equals("-sourceDir")) {
                    sourceDir = args[i + 1].trim();
                    Main.validString(sourceDir);
                    map.put("sourceDir", sourceDir);
                    ++i;
                    continue;
                }
                if (!args[i].equals("-verbose")) continue;
                map.put("verbose", new Boolean(true));
                continue;
            }
            catch (Exception e) {
                return map;
            }
        }
        map.put("fileList", Main.getFileListArray(fileList));
        map.put("excludeFileList", Main.getFileListArray(excludeFileList));
        return map;
    }

    private static String[] getFileListArray(String fileList) {
        if (fileList == null) {
            return null;
        }
        String[] fileListArray = null;
        try {
            StringTokenizer fileListTokens = new StringTokenizer(fileList, ",");
            int count = fileListTokens.countTokens();
            if (count == 0) {
                return null;
            }
            fileListArray = new String[count];
            int j = 0;
            while (fileListTokens.hasMoreTokens()) {
                fileListArray[j] = fileListTokens.nextToken();
                ++j;
            }
        }
        catch (Exception e) {
            return null;
        }
        return fileListArray;
    }

    private static void validString(String s) throws Exception {
        if (s == null || s.length() == 0) {
            throw new Exception("Invalid argument value");
        }
    }
}

