/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.tools;

import com.sun.webui.tools.ExecProcess;
import java.io.File;

public class Native2ascii {
    private File sourceDir;
    private File destDir;
    private String[] fileList;
    private boolean reverse;
    private String encoding;

    public Native2ascii(String encoding, boolean reverse, String sourceDir, String destDir, String[] fileList) throws Exception {
        this.sourceDir = new File(sourceDir);
        this.validateDirectory(this.sourceDir, true);
        this.destDir = new File(destDir);
        this.validateDirectory(this.destDir, false);
        this.fileList = fileList;
        if (this.fileList == null || this.fileList.length == 0) {
            throw new Exception("Empty file list.");
        }
        this.encoding = encoding == null || encoding.trim().length() == 0 ? "UTF-8" : encoding.trim();
        this.reverse = reverse;
    }

    protected void validateDirectory(File dir, boolean readOnly) throws Exception {
        if (!dir.isDirectory()) {
            throw new Exception(dir.getCanonicalPath() + " is not a directory.");
        }
        if (readOnly && !dir.canRead()) {
            throw new Exception(dir.getCanonicalPath() + " is not readable.");
        }
        if (!readOnly && !dir.canWrite()) {
            throw new Exception(dir.getCanonicalPath() + " is not writable.");
        }
    }

    protected void convert(String sourceFile, String destFile) throws Exception {
        String bindir = System.getProperty("jbin");
        String cmd = (bindir == null ? "" : bindir + File.separator) + "native2ascii -encoding " + this.encoding + " " + (this.reverse ? "-reverse " : "") + " " + sourceFile + " " + destFile + " ";
        ExecProcess ep = new ExecProcess(cmd);
        int returnVal = ep.exec();
        if (returnVal != 0) {
            System.exit(returnVal);
        }
    }

    public void convertAll() throws Exception {
        String absSourceDir = this.sourceDir.getCanonicalPath();
        String absDestDir = this.destDir.getCanonicalPath();
        for (int i = 0; i < this.fileList.length; ++i) {
            try {
                this.convert(absSourceDir + File.separator + this.fileList[i], absDestDir + File.separator + this.fileList[i]);
                continue;
            }
            catch (Exception e) {
                throw new Exception("Cannot covert " + absSourceDir + File.separator + this.fileList[i] + " to " + absDestDir + File.separator + this.fileList[i], e);
            }
        }
    }
}

