/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class ToolsBase {
    private File copyrightFile = null;
    private File destDir = null;
    private File sourceDir = null;
    private File outFile = null;
    private boolean verbose = false;
    private ArrayList processedFiles = new ArrayList();

    public ToolsBase(String sourceDir, boolean verbose, String copyrightFile) {
        this.setSourceDir(sourceDir);
        this.setCopyrightFile(copyrightFile);
        this.setVerbose(verbose);
    }

    protected File getCopyrightFile() {
        return this.copyrightFile;
    }

    protected String getCopyright() throws IOException {
        File file = this.getCopyrightFile();
        if (file == null || !file.canRead()) {
            return null;
        }
        BufferedReader input = new BufferedReader(new FileReader(file));
        StringBuffer buff = new StringBuffer();
        String line = null;
        while ((line = input.readLine()) != null) {
            buff.append(line);
            buff.append(System.getProperty("line.separator"));
        }
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buff.toString();
    }

    protected String getDestDir() throws IOException {
        return this.destDir.getCanonicalPath();
    }

    protected File getOutFile() {
        return this.outFile;
    }

    protected String getSourceDir() throws IOException {
        return this.sourceDir.getCanonicalPath();
    }

    protected boolean isFileAvailable(File file) {
        boolean result = true;
        if (file == null || !file.canRead()) {
            return false;
        }
        try {
            if (this.processedFiles.contains(file.getCanonicalPath())) {
                result = false;
            }
            this.processedFiles.add(file.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected boolean isVerbose() {
        return this.verbose;
    }

    protected void setCopyrightFile(String copyrightFile) {
        if (copyrightFile == null) {
            return;
        }
        this.copyrightFile = new File(copyrightFile);
    }

    protected void setDestDir(String destDir) {
        if (destDir == null) {
            return;
        }
        try {
            this.destDir = new File(destDir);
            this.validateDirectory(this.destDir, false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void setOutFile(String outFile) {
        if (outFile == null) {
            return;
        }
        this.outFile = new File(outFile);
    }

    protected void setSourceDir(String sourceDir) {
        if (sourceDir == null) {
            return;
        }
        try {
            this.sourceDir = new File(sourceDir);
            this.validateDirectory(this.sourceDir, false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected void validateDirectory(File dir, boolean readOnly) throws IOException {
        if (!dir.isDirectory()) {
            throw new IOException(dir.getAbsolutePath() + " is not a directory.");
        }
        if (readOnly && !dir.canRead()) {
            throw new IOException(dir.getAbsolutePath() + " is not readable.");
        }
        if (!readOnly && !dir.canWrite()) {
            throw new IOException(dir.getAbsolutePath() + " is not writable.");
        }
    }

    protected void writeOutFile(File file, String str, boolean append) throws IOException {
        if (file == null) {
            return;
        }
        FileWriter output = new FileWriter(file, append);
        String copyright = this.getCopyright();
        if (copyright != null) {
            output.write(copyright);
            output.write(str.replace(copyright.trim(), ""));
        } else {
            output.write(str);
        }
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

