/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mirror;

import com.sun.faces.mirror.AttributeInfo;
import com.sun.faces.mirror.DeclaredPropertyInfo;
import com.sun.faces.mirror.PropertyInfo;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclaredAttributeInfo
implements AttributeInfo {
    static final String NAME = "name";
    static final String IS_REQUIRED = "isRequired";
    static final String IS_BINDABLE = "isBindable";
    Map<String, Object> annotationValueMap;
    PropertyInfo parentPropertyInfo;
    private String methodSignature;
    private String description;

    DeclaredAttributeInfo(PropertyInfo parentPropertyInfo) {
        this(null, parentPropertyInfo);
    }

    DeclaredAttributeInfo(AttributeInfo attributeInfo) {
        this.annotationValueMap = new HashMap<String, Object>();
        this.annotationValueMap.put(NAME, attributeInfo.getName());
        this.annotationValueMap.put(IS_REQUIRED, attributeInfo.isRequired());
        this.annotationValueMap.put(IS_BINDABLE, attributeInfo.isBindable());
        this.setDescription(attributeInfo.getDescription());
        this.setMethodSignature(attributeInfo.getMethodSignature());
        if (attributeInfo instanceof DeclaredAttributeInfo) {
            this.parentPropertyInfo = ((DeclaredAttributeInfo)attributeInfo).parentPropertyInfo;
        }
    }

    DeclaredAttributeInfo(Map<String, Object> annotationValueMap, PropertyInfo parentPropertyInfo) {
        this.annotationValueMap = annotationValueMap;
        this.parentPropertyInfo = parentPropertyInfo;
    }

    @Override
    public String getName() {
        if (this.annotationValueMap == null) {
            return this.parentPropertyInfo.getName();
        }
        String name = (String)this.annotationValueMap.get(NAME);
        return name == null ? this.parentPropertyInfo.getName() : name;
    }

    @Override
    public boolean isRequired() {
        if (this.annotationValueMap == null) {
            return false;
        }
        return Boolean.TRUE.equals(this.annotationValueMap.get(IS_REQUIRED));
    }

    @Override
    public boolean isBindable() {
        if (this.annotationValueMap == null) {
            return true;
        }
        return !Boolean.FALSE.equals(this.annotationValueMap.get(IS_BINDABLE));
    }

    @Override
    public String getMethodSignature() {
        return this.methodSignature;
    }

    void setMethodSignature(String methodSignature) {
        this.methodSignature = methodSignature;
    }

    @Override
    public String getDescription() {
        if (this.description == null && this.parentPropertyInfo != null) {
            return ((DeclaredPropertyInfo)this.parentPropertyInfo).getDocComment();
        }
        return this.description;
    }

    void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getWriteMethodName() {
        String name = this.getName();
        return "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }
}

