/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mirror;

import com.sun.faces.mirror.EventInfo;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclaredEventInfo
extends EventInfo {
    static final String NAME = "name";
    static final String DISPLAY_NAME = "displayName";
    static final String SHORT_DESCRIPTION = "shortDescription";
    static final String ADD_LISTENER_METHOD_NAME = "addListenerMethodName";
    static final String REMOVE_LISTENER_METHOD_NAME = "removeListenerMethodName";
    static final String GET_LISTENERS_METHOD_NAME = "getListenersMethodName";
    static final String IS_DEFAULT = "isDefault";
    Declaration decl;
    Map<String, Object> annotationValueMap;
    private String name;
    private String addListenerMethodName;
    private String removeListenerMethodName;
    private String getListenersMethodName;
    private TypeDeclaration listenerDeclaration;
    private Class listenerClass;
    private String listenerMethodName;
    private String[] listenerMethodParameterClassNames;

    DeclaredEventInfo(Map<String, Object> annotationValueMap, Declaration decl) {
        this.annotationValueMap = annotationValueMap;
        this.decl = decl;
    }

    public Declaration getDeclaration() {
        return this.decl;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getShortDescription() {
        return this.getDisplayName();
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public String getAddListenerMethodName() {
        if (this.addListenerMethodName == null) {
            this.addListenerMethodName = (String)this.annotationValueMap.get(ADD_LISTENER_METHOD_NAME);
        }
        return this.addListenerMethodName;
    }

    void setAddListenerMethodName(String addMethodName) {
        this.addListenerMethodName = addMethodName;
    }

    @Override
    public String getRemoveListenerMethodName() {
        if (this.removeListenerMethodName == null) {
            this.removeListenerMethodName = (String)this.annotationValueMap.get(REMOVE_LISTENER_METHOD_NAME);
        }
        return this.removeListenerMethodName;
    }

    void setRemoveListenerMethodName(String removeMethodName) {
        this.removeListenerMethodName = removeMethodName;
    }

    @Override
    public String getGetListenersMethodName() {
        if (this.getListenersMethodName == null) {
            this.getListenersMethodName = (String)this.annotationValueMap.get(GET_LISTENERS_METHOD_NAME);
        }
        return this.getListenersMethodName;
    }

    void setGetListenersMethodName(String getMethodName) {
        this.getListenersMethodName = getMethodName;
    }

    @Override
    public String getListenerMethodSignature() {
        StringBuffer buffer = new StringBuffer();
        if (this.getListenerDeclaration() != null) {
            MethodDeclaration listenerMethodDecl = (MethodDeclaration)this.getListenerDeclaration().getMethods().iterator().next();
            buffer.append(listenerMethodDecl.getReturnType().toString());
            buffer.append(" ");
            buffer.append(listenerMethodDecl.getSimpleName());
            buffer.append("(");
            for (ParameterDeclaration paramDecl : listenerMethodDecl.getParameters()) {
                buffer.append(paramDecl.getType().toString());
                buffer.append(",");
            }
            buffer.setLength(buffer.length() - 1);
            buffer.append(")");
        } else if (this.getListenerClass() != null) {
            Method listenerMethod = this.getListenerClass().getMethods()[0];
            buffer.append(listenerMethod.getReturnType().toString());
            buffer.append(" ");
            buffer.append(listenerMethod.getName());
            buffer.append("(");
            for (Class<?> paramClass : listenerMethod.getParameterTypes()) {
                buffer.append(paramClass.getName());
                buffer.append(",");
            }
            buffer.setLength(buffer.length() - 1);
            buffer.append(")");
        }
        return buffer.toString();
    }

    public TypeDeclaration getListenerDeclaration() {
        return this.listenerDeclaration;
    }

    void setListenerDeclaration(TypeDeclaration listenerDeclaration) {
        this.listenerDeclaration = listenerDeclaration;
    }

    public Class getListenerClass() {
        return this.listenerClass;
    }

    void setListenerClass(Class listenerClass) {
        this.listenerClass = listenerClass;
    }

    @Override
    public String getListenerClassName() {
        if (this.getListenerDeclaration() != null) {
            return this.getListenerDeclaration().getQualifiedName();
        }
        if (this.getListenerClass() != null) {
            return this.getListenerClass().getName();
        }
        return null;
    }

    @Override
    public String getListenerMethodName() {
        if (this.listenerMethodName == null) {
            if (this.getListenerDeclaration() != null) {
                MethodDeclaration listenerMethodDecl = (MethodDeclaration)this.getListenerDeclaration().getMethods().iterator().next();
                this.listenerMethodName = listenerMethodDecl.getSimpleName();
            } else if (this.getListenerClass() != null) {
                this.listenerMethodName = this.getListenerClass().getMethods()[0].getName();
            }
        }
        return this.listenerMethodName;
    }

    @Override
    public String[] getListenerMethodParameterClassNames() {
        if (this.listenerMethodParameterClassNames == null) {
            ArrayList<String> paramNameList = new ArrayList<String>();
            if (this.getListenerDeclaration() != null) {
                for (ParameterDeclaration paramDecl : ((MethodDeclaration)this.getListenerDeclaration().getMethods().iterator().next()).getParameters()) {
                    paramNameList.add(paramDecl.getType().toString());
                }
            } else if (this.getListenerClass() != null) {
                for (Class<?> paramClass : this.getListenerClass().getMethods()[0].getParameterTypes()) {
                    paramNameList.add(paramClass.getName());
                }
            }
            this.listenerMethodParameterClassNames = paramNameList.toArray(new String[paramNameList.size()]);
        }
        return this.listenerMethodParameterClassNames;
    }
}

