/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mirror;

import com.sun.faces.annotation.Component;
import com.sun.faces.annotation.Event;
import com.sun.faces.annotation.Property;
import com.sun.faces.annotation.PropertyCategory;
import com.sun.faces.annotation.Renderer;
import com.sun.faces.annotation.Resolver;
import com.sun.faces.annotation.Tag;
import com.sun.faces.mirror.AttributeInfo;
import com.sun.faces.mirror.CategoryInfo;
import com.sun.faces.mirror.ClassInfo;
import com.sun.faces.mirror.DeclaredAttributeInfo;
import com.sun.faces.mirror.DeclaredClassInfo;
import com.sun.faces.mirror.DeclaredComponentInfo;
import com.sun.faces.mirror.DeclaredEventInfo;
import com.sun.faces.mirror.DeclaredInterfaceInfo;
import com.sun.faces.mirror.DeclaredPropertyInfo;
import com.sun.faces.mirror.DeclaredRendererInfo;
import com.sun.faces.mirror.DeclaredTypeInfo;
import com.sun.faces.mirror.EventInfo;
import com.sun.faces.mirror.IntrospectedClassInfo;
import com.sun.faces.mirror.IntrospectedEventInfo;
import com.sun.faces.mirror.IntrospectedPropertyInfo;
import com.sun.faces.mirror.PropertyBundleMap;
import com.sun.faces.mirror.PropertyInfo;
import com.sun.faces.mirror.generator.BeanInfoSourceGenerator;
import com.sun.faces.mirror.generator.DebugGenerator;
import com.sun.faces.mirror.generator.FaceletsConfigFileGenerator;
import com.sun.faces.mirror.generator.FacesConfigFileGenerator;
import com.sun.faces.mirror.generator.GeneratorException;
import com.sun.faces.mirror.generator.GeneratorFactory;
import com.sun.faces.mirror.generator.TagLibFileGenerator;
import com.sun.faces.mirror.generator.TagSourceGenerator;
import com.sun.faces.mirror.generator.TldFileGenerator;
import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.VoidType;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.DeclarationVisitors;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import com.sun.rave.designtime.CategoryDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FacesAnnotationProcessor
implements AnnotationProcessor {
    AnnotationProcessorEnvironment env;
    Set<String> packageNameSet = new HashSet<String>();
    Set<DeclaredComponentInfo> declaredComponentSet = new HashSet<DeclaredComponentInfo>();
    Set<DeclaredRendererInfo> declaredRendererSet = new HashSet<DeclaredRendererInfo>();
    Map<String, DeclaredClassInfo> declaredClassMap = new HashMap<String, DeclaredClassInfo>();
    Map<String, DeclaredInterfaceInfo> declaredInterfaceMap = new HashMap<String, DeclaredInterfaceInfo>();
    Map<String, DeclaredClassInfo> declaredTagClassMap = new HashMap<String, DeclaredClassInfo>();
    Map<String, CategoryInfo> categoryMap = new HashMap<String, CategoryInfo>();
    Set<String> propertyResolverNameSet = new HashSet<String>();
    Set<String> variableResolverNameSet = new HashSet<String>();
    Set<String> javaeeResolverNameSet = new HashSet<String>();
    private String namespaceUri;
    private String namespacePrefix;
    private String taglibDoc;
    private boolean localize;
    private boolean processDesignTime;
    private boolean processRunTime;
    private Class generatorFactoryClass;
    private boolean debug;

    FacesAnnotationProcessor(AnnotationProcessorEnvironment env) {
        this.env = env;
    }

    String getNamespaceUri() {
        return this.namespaceUri;
    }

    void setNamespaceUri(String namespaceUri) {
        this.namespaceUri = namespaceUri;
    }

    String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    void setNamespacePrefix(String namespacePrefix) {
        this.namespacePrefix = namespacePrefix;
    }

    String getTaglibDoc() {
        return this.taglibDoc;
    }

    void setTaglibDoc(String taglibDoc) {
        this.taglibDoc = taglibDoc;
    }

    void setLocalize(boolean localize) {
        this.localize = localize;
    }

    void setProcessDesignTime(boolean processDesignTime) {
        this.processDesignTime = processDesignTime;
    }

    void setProcessRunTime(boolean processRunTime) {
        this.processRunTime = processRunTime;
    }

    Class getGeneratorFactoryClass() {
        return this.generatorFactoryClass;
    }

    void setGeneratorFactoryClass(Class generatorFactoryClass) {
        this.generatorFactoryClass = generatorFactoryClass;
    }

    void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void process() {
        block96: {
            String superClassName;
            ClassType superClassType;
            MemberDeclarationVisitor classMemberVisitor = new MemberDeclarationVisitor(this.env);
            classMemberVisitor.setCategoryMap(this.categoryMap);
            for (TypeDeclaration typeDecl : this.env.getTypeDeclarations()) {
                this.packageNameSet.add(typeDecl.getPackage().getQualifiedName());
                if (!(typeDecl instanceof ClassDeclaration) && !(typeDecl instanceof InterfaceDeclaration)) continue;
                DeclaredTypeInfo typeInfo = null;
                classMemberVisitor.reset();
                typeDecl.accept(DeclarationVisitors.getDeclarationScanner((DeclarationVisitor)classMemberVisitor, (DeclarationVisitor)DeclarationVisitors.NO_OP));
                if (typeDecl instanceof ClassDeclaration) {
                    Map<String, Object> annotationValueMap;
                    if (typeDecl.getAnnotation(Component.class) != null) {
                        annotationValueMap = FacesAnnotationProcessor.getAnnotationValueMap((Declaration)typeDecl, Component.class.getName());
                        DeclaredComponentInfo componentInfo = new DeclaredComponentInfo(annotationValueMap, (ClassDeclaration)typeDecl);
                        this.declaredComponentSet.add(componentInfo);
                        this.declaredClassMap.put(typeDecl.getQualifiedName(), componentInfo);
                        typeInfo = componentInfo;
                    } else if (typeDecl.getAnnotation(Renderer.class) != null) {
                        annotationValueMap = FacesAnnotationProcessor.getAnnotationValueMap((Declaration)typeDecl, Renderer.class.getName());
                        DeclaredRendererInfo rendererInfo = new DeclaredRendererInfo(annotationValueMap, (ClassDeclaration)typeDecl);
                        if (rendererInfo.getRenderings().size() == 0) {
                            this.env.getMessager().printWarning(typeDecl.getPosition(), "No renderings declared in renderer annotation");
                        }
                        this.declaredRendererSet.add(rendererInfo);
                    } else if (typeDecl.getAnnotation(Tag.class) != null) {
                        annotationValueMap = FacesAnnotationProcessor.getAnnotationValueMap((Declaration)typeDecl, Tag.class.getName());
                        String componentType = (String)annotationValueMap.get("componentType");
                        DeclaredClassInfo tagClassInfo = new DeclaredClassInfo((ClassDeclaration)typeDecl);
                        this.declaredTagClassMap.put(componentType, tagClassInfo);
                    } else if (typeDecl.getAnnotation(Resolver.class) != null) {
                        for (superClassType = ((ClassDeclaration)typeDecl).getSuperclass(); superClassType != null; superClassType = superClassType.getSuperclass()) {
                            superClassName = superClassType.getDeclaration().getQualifiedName();
                            if (superClassName.equals("javax.faces.el.PropertyResolver")) {
                                this.propertyResolverNameSet.add(typeDecl.getQualifiedName());
                                continue;
                            }
                            if (superClassName.equals("javax.faces.el.VariableResolver")) {
                                this.variableResolverNameSet.add(typeDecl.getQualifiedName());
                                continue;
                            }
                            if (!superClassName.equals("javax.el.ELResolver")) continue;
                            this.javaeeResolverNameSet.add(typeDecl.getQualifiedName());
                        }
                    } else {
                        DeclaredClassInfo declaredClassInfo = new DeclaredClassInfo((ClassDeclaration)typeDecl);
                        this.declaredClassMap.put(typeDecl.getQualifiedName(), declaredClassInfo);
                        typeInfo = declaredClassInfo;
                    }
                } else {
                    DeclaredInterfaceInfo declaredInterfaceInfo = new DeclaredInterfaceInfo((InterfaceDeclaration)typeDecl);
                    this.declaredInterfaceMap.put(typeDecl.getQualifiedName(), declaredInterfaceInfo);
                    typeInfo = declaredInterfaceInfo;
                }
                if (typeInfo == null) continue;
                Map<String, PropertyInfo> propertyInfoMap = classMemberVisitor.getPropertyInfoMap();
                typeInfo.setPropertyInfoMap(propertyInfoMap);
                Map<String, EventInfo> eventInfoMap = classMemberVisitor.getEventInfoMap();
                typeInfo.setEventInfoMap(eventInfoMap);
            }
            HashMap<String, IntrospectedClassInfo> introspectedClassMap = new HashMap<String, IntrospectedClassInfo>();
            for (DeclaredClassInfo declaredClassInfo : this.declaredClassMap.values()) {
                superClassType = ((ClassDeclaration)declaredClassInfo.getDeclaration()).getSuperclass();
                superClassName = superClassType.getDeclaration().getQualifiedName();
                if (this.declaredClassMap.containsKey(superClassName)) {
                    declaredClassInfo.setSuperClassInfo(this.declaredClassMap.get(superClassName));
                    continue;
                }
                if (introspectedClassMap.containsKey(superClassName)) {
                    declaredClassInfo.setSuperClassInfo((ClassInfo)introspectedClassMap.get(superClassName));
                    continue;
                }
                if (superClassName.equals("java.lang.Object")) continue;
                try {
                    Class<?> superClass = Class.forName(superClassName);
                    BeanInfo superBeanInfo = Introspector.getBeanInfo(superClass);
                    IntrospectedClassInfo superClassInfo = new IntrospectedClassInfo(superBeanInfo);
                    HashMap<String, PropertyInfo> propertyInfoMap = new HashMap<String, PropertyInfo>();
                    HashSet categoryDescriptors = new HashSet();
                    for (PropertyDescriptor propertyDescriptor : superBeanInfo.getPropertyDescriptors()) {
                        String name = propertyDescriptor.getName();
                        IntrospectedPropertyInfo propertyInfo = new IntrospectedPropertyInfo(propertyDescriptor);
                        CategoryDescriptor categoryDescriptor = (CategoryDescriptor)propertyDescriptor.getValue("category");
                        if (categoryDescriptor != null) {
                            String categoryName = categoryDescriptor.getName();
                            if (this.categoryMap.containsKey(categoryName)) {
                                propertyInfo.setCategoryInfo(this.categoryMap.get(categoryName));
                            } else {
                                this.env.getMessager().printWarning("No category descriptor found in current compilation unit for '" + categoryName + "', referenced in " + superBeanInfo.getClass().getName());
                            }
                        }
                        propertyInfo.setDeclaringClassInfo(superClassInfo);
                        propertyInfoMap.put(name, propertyInfo);
                    }
                    superClassInfo.setPropertyInfoMap(propertyInfoMap);
                    HashMap<String, EventInfo> eventInfoMap = new HashMap<String, EventInfo>();
                    for (EventSetDescriptor eventDescriptor : superBeanInfo.getEventSetDescriptors()) {
                        if (eventDescriptor.getListenerMethods().length != 1) continue;
                        String name = eventDescriptor.getName();
                        IntrospectedEventInfo eventInfo = new IntrospectedEventInfo(eventDescriptor);
                        eventInfo.setDeclaringClassInfo(superClassInfo);
                        eventInfoMap.put(name, eventInfo);
                    }
                    superClassInfo.setEventInfoMap(eventInfoMap);
                    introspectedClassMap.put(superClassName, superClassInfo);
                    declaredClassInfo.setSuperClassInfo(superClassInfo);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IntrospectionException e) {
                    e.printStackTrace();
                }
            }
            for (DeclaredClassInfo declaredClassInfo : this.declaredClassMap.values()) {
                this.updateInheritedInfo(declaredClassInfo);
                Set<String> methodNameSet = declaredClassInfo.getMethodNameSet();
                for (PropertyInfo propertyInfo : declaredClassInfo.getPropertyInfoMap().values()) {
                    Declaration decl;
                    String categoryReferenceName;
                    String writeMethodName;
                    String readMethodName;
                    String name;
                    if (!FacesAnnotationProcessor.isNameValid(propertyInfo.getName())) {
                        this.env.getMessager().printError(((DeclaredPropertyInfo)propertyInfo).getDeclaration().getPosition(), "The name specified is not a valid property name");
                    }
                    if (propertyInfo.getAttributeInfo() != null && !FacesAnnotationProcessor.isNameValid(name = propertyInfo.getAttributeInfo().getName())) {
                        this.env.getMessager().printError(((DeclaredPropertyInfo)propertyInfo).getDeclaration().getPosition(), "The name specified is not a valid attribute name");
                    }
                    if (propertyInfo.getAttributeInfo() != null && propertyInfo.getAttributeInfo().getName().equals("binding")) {
                        this.env.getMessager().printWarning(((DeclaredPropertyInfo)propertyInfo).getDeclaration().getPosition(), "Property corresponds to the reserved 'binding' tag attribute");
                    }
                    if ((readMethodName = propertyInfo.getReadMethodName()) == null) {
                        readMethodName = FacesAnnotationProcessor.generateReadMethodName(propertyInfo);
                        if (methodNameSet.contains(readMethodName)) {
                            ((DeclaredPropertyInfo)propertyInfo).setReadMethodName(readMethodName);
                        } else {
                            readMethodName = null;
                        }
                    } else if (!methodNameSet.contains(readMethodName)) {
                        this.env.getMessager().printError(((DeclaredPropertyInfo)propertyInfo).getDeclaration().getPosition(), "No such property method " + readMethodName);
                    }
                    for (MethodDeclaration methodDecl : declaredClassInfo.getDeclaration().getMethods()) {
                        if (!methodDecl.getSimpleName().equals(readMethodName)) continue;
                        TypeMirror returnType = methodDecl.getReturnType();
                        if (returnType.toString().equals(propertyInfo.getType()) && methodDecl.getParameters().size() <= 0) break;
                        this.env.getMessager().printError(methodDecl.getPosition(), "Method " + readMethodName + " for property " + propertyInfo.getName() + " has incorrect signature");
                        break;
                    }
                    if ((writeMethodName = propertyInfo.getWriteMethodName()) == null) {
                        writeMethodName = FacesAnnotationProcessor.generateWriteMethodName(propertyInfo);
                        if (methodNameSet.contains(writeMethodName)) {
                            ((DeclaredPropertyInfo)propertyInfo).setWriteMethodName(writeMethodName);
                        } else {
                            writeMethodName = null;
                        }
                    } else if (!methodNameSet.contains(writeMethodName)) {
                        this.env.getMessager().printError(((DeclaredPropertyInfo)propertyInfo).getDeclaration().getPosition(), "No such property method " + writeMethodName);
                    }
                    if (readMethodName == null && writeMethodName == null) {
                        this.env.getMessager().printError(((DeclaredPropertyInfo)propertyInfo).getDeclaration().getPosition(), "No get or set method found for property");
                    }
                    if (writeMethodName == null && propertyInfo.getAttributeInfo() != null) {
                        this.env.getMessager().printError(((DeclaredPropertyInfo)propertyInfo).getDeclaration().getPosition(), "A read-only method cannot be associated with a JSP tag attribute");
                    }
                    for (MethodDeclaration methodDecl : declaredClassInfo.getDeclaration().getMethods()) {
                        if (!methodDecl.getSimpleName().equals(writeMethodName)) continue;
                        TypeMirror returnType = methodDecl.getReturnType();
                        Collection params = methodDecl.getParameters();
                        if (returnType instanceof VoidType && params.size() == 1 && ((ParameterDeclaration)params.iterator().next()).getType().toString().equals(propertyInfo.getType())) break;
                        this.env.getMessager().printError(methodDecl.getPosition(), "Method " + writeMethodName + " for property " + propertyInfo.getName() + " has incorrect signature");
                        break;
                    }
                    if ((categoryReferenceName = ((DeclaredPropertyInfo)propertyInfo).getCategoryReferenceName()) != null) {
                        CategoryInfo categoryInfo = this.categoryMap.get(categoryReferenceName);
                        if (categoryInfo == null) {
                            this.env.getMessager().printError(((DeclaredPropertyInfo)propertyInfo).getDeclaration().getPosition(), "Reference to non-existant category descriptor: " + categoryReferenceName);
                        } else {
                            ((DeclaredPropertyInfo)propertyInfo).setCategoryInfo(categoryInfo);
                        }
                    }
                    if ((decl = ((DeclaredPropertyInfo)propertyInfo).getDeclaration()).getAnnotation(Property.Method.class) == null) continue;
                    if (propertyInfo.getType().equals("javax.el.MethodExpression")) {
                        Map<String, Object> annotationMap = FacesAnnotationProcessor.getAnnotationValueMap(decl, Property.Method.class.getCanonicalName());
                        DeclaredAttributeInfo attributeInfo = (DeclaredAttributeInfo)propertyInfo.getAttributeInfo();
                        if (annotationMap.containsKey("signature")) {
                            attributeInfo.setMethodSignature((String)annotationMap.get("signature"));
                            continue;
                        }
                        if (annotationMap.containsKey("event")) {
                            String eventName = (String)annotationMap.get("event");
                            Map<String, EventInfo> eventInfoMap = propertyInfo.getDeclaringClassInfo().getEventInfoMap();
                            EventInfo eventInfo = eventInfoMap.get(eventName);
                            if (eventInfo == null) {
                                eventInfoMap = ((DeclaredClassInfo)propertyInfo.getDeclaringClassInfo()).getInheritedEventInfoMap();
                                eventInfo = eventInfoMap.get(eventName);
                            }
                            if (eventInfo != null) {
                                attributeInfo.setMethodSignature(eventInfo.getListenerMethodSignature());
                                eventInfo.setPropertyInfo(propertyInfo);
                                continue;
                            }
                            this.env.getMessager().printError(decl.getPosition(), "No such component event");
                            continue;
                        }
                        this.env.getMessager().printError(decl.getPosition(), "Method annotation is missing an event or signature element");
                        continue;
                    }
                    this.env.getMessager().printError(decl.getPosition(), "Method annotation for property that is not of type javax.el.MethodExpression");
                }
                for (EventInfo eventInfo : declaredClassInfo.getEventInfoMap().values()) {
                    String getListenersMethodName;
                    String addListenerMethodName = eventInfo.getAddListenerMethodName();
                    if (addListenerMethodName == null) {
                        addListenerMethodName = FacesAnnotationProcessor.generateAddListenerMethodName(eventInfo);
                        if (methodNameSet.contains(addListenerMethodName)) {
                            ((DeclaredEventInfo)eventInfo).setAddListenerMethodName(addListenerMethodName);
                        } else {
                            this.env.getMessager().printError(((DeclaredEventInfo)eventInfo).getDeclaration().getPosition(), "No add event listener method declared or found");
                        }
                    } else if (!methodNameSet.contains(addListenerMethodName)) {
                        this.env.getMessager().printError(((DeclaredEventInfo)eventInfo).getDeclaration().getPosition(), "No such event method " + addListenerMethodName);
                    }
                    String removeListenerMethodName = eventInfo.getRemoveListenerMethodName();
                    if (removeListenerMethodName == null) {
                        removeListenerMethodName = FacesAnnotationProcessor.generateRemoveListenerMethodName(eventInfo);
                        if (methodNameSet.contains(removeListenerMethodName)) {
                            ((DeclaredEventInfo)eventInfo).setRemoveListenerMethodName(removeListenerMethodName);
                        } else {
                            this.env.getMessager().printError(((DeclaredEventInfo)eventInfo).getDeclaration().getPosition(), "No remove event listener method declared or found");
                        }
                    } else if (!methodNameSet.contains(removeListenerMethodName)) {
                        this.env.getMessager().printError(((DeclaredEventInfo)eventInfo).getDeclaration().getPosition(), "No such event method " + removeListenerMethodName);
                    }
                    if ((getListenersMethodName = eventInfo.getGetListenersMethodName()) != null || !methodNameSet.contains(getListenersMethodName = FacesAnnotationProcessor.generateGetListenersMethodName(eventInfo))) continue;
                    ((DeclaredEventInfo)eventInfo).setGetListenersMethodName(getListenersMethodName);
                }
                if (!(declaredClassInfo instanceof DeclaredComponentInfo) || !((DeclaredComponentInfo)declaredClassInfo).isTag()) continue;
                String rendererType = ((DeclaredComponentInfo)declaredClassInfo).getTagRendererType();
                boolean rendererFound = false;
                if (rendererType == null) {
                    String componentFamily = ((DeclaredComponentInfo)declaredClassInfo).getFamily();
                    for (DeclaredRendererInfo rendererInfo : this.declaredRendererSet) {
                        for (DeclaredRendererInfo.RendersInfo rendersInfo : rendererInfo.renderings) {
                            for (String rendererComponentFamily : rendersInfo.getComponentFamilies()) {
                                if (!componentFamily.equals(rendererComponentFamily)) continue;
                                ((DeclaredComponentInfo)declaredClassInfo).setTagRendererType(rendersInfo.getRendererType());
                                rendererFound = true;
                            }
                        }
                    }
                } else {
                    for (DeclaredRendererInfo rendererInfo : this.declaredRendererSet) {
                        for (DeclaredRendererInfo.RendersInfo rendersInfo : rendererInfo.renderings) {
                            if (!rendererType.equals(rendersInfo.getRendererType())) continue;
                            rendererFound = true;
                        }
                    }
                }
                if (rendererFound) continue;
                this.env.getMessager().printWarning(declaredClassInfo.getDeclaration().getPosition(), "No renderer found of correct renderer type and component family");
            }
            for (String componentType : this.declaredTagClassMap.keySet()) {
                boolean found = false;
                for (DeclaredComponentInfo componentInfo : this.declaredComponentSet) {
                    if (!componentType.equals(componentInfo.getType())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.env.getMessager().printWarning(this.declaredTagClassMap.get(componentType).getDeclaration().getPosition(), "No component found for tag's component type");
            }
            try {
                GeneratorFactory generatorFactory = new GeneratorFactory();
                if (this.getGeneratorFactoryClass() != null) {
                    try {
                        generatorFactory = (GeneratorFactory)this.getGeneratorFactoryClass().newInstance();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                Filer filer = this.env.getFiler();
                if (this.debug) {
                    DebugGenerator debugGenerator = generatorFactory.getDebugGenerator();
                    debugGenerator.setNamespace(this.getNamespaceUri());
                    debugGenerator.setNamespacePrefix(this.getNamespacePrefix());
                    debugGenerator.setPackageNameSet(this.packageNameSet);
                    debugGenerator.setDeclaredComponentInfoSet(this.declaredComponentSet);
                    debugGenerator.setDeclaredRendererInfoSet(this.declaredRendererSet);
                    PrintWriter debugWriter = new PrintWriter(System.out);
                    debugGenerator.setPrintWriter(debugWriter);
                    debugGenerator.generate();
                    debugWriter.close();
                }
                if (this.processDesignTime) {
                    HashMap<String, PropertyBundleMap> propertyBundleMapsMap = new HashMap<String, PropertyBundleMap>();
                    BeanInfoSourceGenerator beanInfoSourceGenerator = generatorFactory.getBeanInfoSourceGenerator();
                    beanInfoSourceGenerator.setNamespace(this.getNamespaceUri());
                    beanInfoSourceGenerator.setNamespacePrefix(this.getNamespacePrefix());
                    for (DeclaredComponentInfo componentInfo : this.declaredComponentSet) {
                        beanInfoSourceGenerator.setDeclaredComponentInfo(componentInfo);
                        beanInfoSourceGenerator.setPrintWriter(filer.createSourceFile(beanInfoSourceGenerator.getQualifiedName()));
                        if (this.localize) {
                            String packageName = componentInfo.getPackageName();
                            PropertyBundleMap propertyBundleMap = (PropertyBundleMap)propertyBundleMapsMap.get(packageName);
                            if (propertyBundleMap == null) {
                                String qualifiedName = packageName + ".BeanInfoBundle";
                                propertyBundleMap = new PropertyBundleMap(qualifiedName);
                                propertyBundleMapsMap.put(packageName, propertyBundleMap);
                            }
                            beanInfoSourceGenerator.setPropertyBundleMap(propertyBundleMap);
                        }
                        beanInfoSourceGenerator.generate();
                    }
                    if (this.localize) {
                        for (PropertyBundleMap propertyBundleMap : propertyBundleMapsMap.values()) {
                            if (propertyBundleMap.size() <= 0) continue;
                            String fileName = propertyBundleMap.getQualifiedName().replace('.', File.separatorChar) + ".properties";
                            PrintWriter printWriter = filer.createTextFile(Filer.Location.SOURCE_TREE, "", new File(fileName), "ASCII");
                            for (Object key : propertyBundleMap.keyList()) {
                                Object value = propertyBundleMap.get(key);
                                printWriter.println(key.toString() + "=" + value.toString());
                            }
                            printWriter.close();
                        }
                    }
                }
                if (!this.processRunTime) break block96;
                if (this.declaredComponentSet.size() > 0) {
                    FacesConfigFileGenerator facesConfigGenerator = generatorFactory.getFacesConfigFileGenerator();
                    facesConfigGenerator.setDeclaredComponentInfoSet(this.declaredComponentSet);
                    facesConfigGenerator.setDeclaredRendererInfoSet(this.declaredRendererSet);
                    facesConfigGenerator.setDeclaredPropertyResolverNameSet(this.propertyResolverNameSet);
                    facesConfigGenerator.setDeclaredVariableResolverNameSet(this.variableResolverNameSet);
                    facesConfigGenerator.setDeclaredJavaEEResolverNameSet(this.javaeeResolverNameSet);
                    String fileName = facesConfigGenerator.getFileName();
                    facesConfigGenerator.setPrintWriter(filer.createTextFile(Filer.Location.CLASS_TREE, "", new File(fileName), "UTF-8"));
                    facesConfigGenerator.generate();
                    FaceletsConfigFileGenerator faceletsConfigGenerator = generatorFactory.getFaceletsConfigFileGenerator();
                    faceletsConfigGenerator.setDeclaredComponentInfoSet(this.declaredComponentSet);
                    faceletsConfigGenerator.setDeclaredRendererInfoSet(this.declaredRendererSet);
                    faceletsConfigGenerator.setNamespace(this.getNamespaceUri());
                    String faceletsFileName = faceletsConfigGenerator.getFileName();
                    faceletsConfigGenerator.setPrintWriter(filer.createTextFile(Filer.Location.CLASS_TREE, "", new File(faceletsFileName), "UTF-8"));
                    faceletsConfigGenerator.generate();
                }
                TagSourceGenerator tagSourceGenerator = generatorFactory.getTagSourceGenerator();
                tagSourceGenerator.setNamespace(this.getNamespaceUri());
                tagSourceGenerator.setNamespacePrefix(this.getNamespacePrefix());
                for (DeclaredComponentInfo componentInfo : this.declaredComponentSet) {
                    if (this.declaredTagClassMap.containsKey(componentInfo.getType()) || !componentInfo.isTag()) continue;
                    tagSourceGenerator.setDeclaredComponentInfo(componentInfo);
                    tagSourceGenerator.setPrintWriter(filer.createSourceFile(tagSourceGenerator.getQualifiedName()));
                    tagSourceGenerator.generate();
                }
                if (this.declaredComponentSet.size() <= 0) break block96;
                if (this.taglibDoc != null) {
                    try {
                        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                        TaglibDocHandler handler = new TaglibDocHandler();
                        parser.parse(new File(this.taglibDoc), (DefaultHandler)handler);
                        Map<String, String> tagDescriptionMap = handler.getTagDescriptionMap();
                        Map<String, Map> tagAttributeMap = handler.getTagAttributeMap();
                        for (DeclaredComponentInfo componentInfo : this.declaredComponentSet) {
                            String tagName = componentInfo.getTagName();
                            if (tagDescriptionMap.containsKey(tagName)) {
                                componentInfo.setTagDescription(tagDescriptionMap.get(tagName));
                            }
                            if (!tagAttributeMap.containsKey(tagName)) continue;
                            Map attrDescriptionMap = tagAttributeMap.get(tagName);
                            for (PropertyInfo propertyInfo : componentInfo.getPropertyInfoMap().values()) {
                                AttributeInfo attrInfo = propertyInfo.getAttributeInfo();
                                if (!(attrInfo instanceof DeclaredAttributeInfo) || attrInfo == null || !attrDescriptionMap.containsKey(attrInfo.getName())) continue;
                                ((DeclaredAttributeInfo)attrInfo).setDescription((String)attrDescriptionMap.get(attrInfo.getName()));
                            }
                        }
                    }
                    catch (Exception e) {
                        this.env.getMessager().printError("Error occurred while processing input tag description file: " + e.getMessage());
                    }
                }
                TagLibFileGenerator tagLibGenerator = generatorFactory.getTagLibFileGenerator();
                tagLibGenerator.setDeclaredComponentInfoSet(this.declaredComponentSet);
                tagLibGenerator.setNamespace(this.getNamespaceUri());
                tagLibGenerator.setNamespacePrefix(this.getNamespacePrefix());
                String fileName = tagLibGenerator.getFileName();
                tagLibGenerator.setPrintWriter(filer.createTextFile(Filer.Location.CLASS_TREE, "", new File(fileName), "UTF-8"));
                tagLibGenerator.generate();
                TldFileGenerator tldGenerator = generatorFactory.getTldFileGenerator();
                tldGenerator.setDeclaredComponentInfoSet(this.declaredComponentSet);
                tldGenerator.setNamespace(this.getNamespaceUri());
                tldGenerator.setNamespacePrefix(this.getNamespacePrefix());
                fileName = tldGenerator.getFileName();
                tldGenerator.setPrintWriter(filer.createTextFile(Filer.Location.CLASS_TREE, "", new File(fileName), "UTF-8"));
                tldGenerator.generate();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.env.getMessager().printError(e.getMessage());
            }
            catch (GeneratorException e) {
                this.env.getMessager().printError(e.getMessage());
            }
        }
    }

    private void updateInheritedInfo(DeclaredClassInfo classInfo) {
        HashMap<String, PropertyInfo> superPropertyInfoMap = new HashMap<String, PropertyInfo>();
        ClassInfo superClassInfo = classInfo.getSuperClassInfo();
        if (superClassInfo != null) {
            if (DeclaredClassInfo.class.isAssignableFrom(superClassInfo.getClass())) {
                this.updateInheritedInfo((DeclaredClassInfo)superClassInfo);
            }
            superPropertyInfoMap.putAll(superClassInfo.getPropertyInfoMap());
            if (DeclaredClassInfo.class.isAssignableFrom(superClassInfo.getClass())) {
                superPropertyInfoMap.putAll(((DeclaredClassInfo)superClassInfo).getInheritedPropertyInfoMap());
            }
            classInfo.getMethodNameSet().addAll(superClassInfo.getMethodNameSet());
        }
        Stack superInterfaces = new Stack();
        superInterfaces.addAll(classInfo.getDeclaration().getSuperinterfaces());
        while (!superInterfaces.isEmpty()) {
            InterfaceType interfaceType = (InterfaceType)superInterfaces.pop();
            if (this.declaredInterfaceMap.containsKey(interfaceType.toString())) {
                DeclaredInterfaceInfo interfaceInfo = this.declaredInterfaceMap.get(interfaceType.toString());
                for (PropertyInfo propertyInfo : interfaceInfo.getPropertyInfoMap().values()) {
                    if (superPropertyInfoMap.containsKey(propertyInfo.getName())) {
                        this.env.getMessager().printError(classInfo.getQualifiedName() + " inherits property " + propertyInfo.getName() + " more than once");
                        continue;
                    }
                    superPropertyInfoMap.put(propertyInfo.getName(), propertyInfo);
                }
            }
            superInterfaces.addAll(interfaceType.getSuperinterfaces());
        }
        for (PropertyInfo propertyInfo : classInfo.getPropertyInfoMap().values()) {
            if (!superPropertyInfoMap.containsKey(propertyInfo.getName()) || !(propertyInfo instanceof DeclaredPropertyInfo)) continue;
            DeclaredPropertyInfo thisPropertyInfo = (DeclaredPropertyInfo)propertyInfo;
            PropertyInfo superPropertyInfo = (PropertyInfo)superPropertyInfoMap.get(propertyInfo.getName());
            boolean updateInheritedValues = true;
            if (!propertyInfo.getType().equals(superPropertyInfo.getType())) {
                this.env.getMessager().printError(thisPropertyInfo.getDeclaration().getPosition(), "Property in sub class must be of same type as the property that it overrides");
                updateInheritedValues = false;
            }
            if (propertyInfo.getReadMethodName() != null && superPropertyInfo.getReadMethodName() != null && !propertyInfo.getReadMethodName().equals(superPropertyInfo.getReadMethodName())) {
                this.env.getMessager().printError(thisPropertyInfo.getDeclaration().getPosition(), "Read method of property in sub class must have same name as the method that it overrides");
                updateInheritedValues = false;
            }
            if (propertyInfo.getWriteMethodName() != null && superPropertyInfo.getWriteMethodName() != null && !propertyInfo.getWriteMethodName().equals(superPropertyInfo.getWriteMethodName())) {
                this.env.getMessager().printError(thisPropertyInfo.getDeclaration().getPosition(), "Write method of property in sub class must have same name as the method that it overrides");
                updateInheritedValues = false;
            }
            if (!updateInheritedValues) continue;
            thisPropertyInfo.updateInheritedValues(superPropertyInfo);
        }
        Map<String, PropertyInfo> propertyInfoMap = classInfo.getPropertyInfoMap();
        Map<String, EventInfo> eventInfoMap = classInfo.getEventInfoMap();
        superInterfaces.clear();
        superInterfaces.addAll(classInfo.getDeclaration().getSuperinterfaces());
        while (!superInterfaces.isEmpty()) {
            InterfaceType interfaceType = (InterfaceType)superInterfaces.pop();
            if (this.declaredInterfaceMap.containsKey(interfaceType.toString())) {
                DeclaredInterfaceInfo interfaceInfo = this.declaredInterfaceMap.get(interfaceType.toString());
                for (PropertyInfo propertyInfo : interfaceInfo.getPropertyInfoMap().values()) {
                    if (propertyInfoMap.containsKey(propertyInfo.getName())) continue;
                    propertyInfoMap.put(propertyInfo.getName(), propertyInfo);
                }
                for (EventInfo eventInfo : interfaceInfo.getEventInfoMap().values()) {
                    if (eventInfoMap.containsKey(eventInfo.getName())) continue;
                    eventInfoMap.put(eventInfo.getName(), eventInfo);
                }
            }
            superInterfaces.addAll(interfaceType.getSuperinterfaces());
        }
    }

    private static Map<String, Object> getAnnotationValueMap(Declaration decl, String annotationClassName) {
        for (AnnotationMirror annotationMirror : decl.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().getDeclaration().getQualifiedName().equals(annotationClassName)) continue;
            return FacesAnnotationProcessor.getAnnotationValueMap(annotationMirror);
        }
        return null;
    }

    private static Map<String, Object> getAnnotationValueMap(AnnotationMirror annotationMirror) {
        HashMap<String, Object> annotationValueMap = new HashMap<String, Object>();
        for (AnnotationTypeElementDeclaration elementDecl : annotationMirror.getElementValues().keySet()) {
            String name = elementDecl.getSimpleName();
            Map<String, Object> value = ((AnnotationValue)annotationMirror.getElementValues().get(elementDecl)).getValue();
            if (value != null && AnnotationMirror.class.isAssignableFrom(value.getClass())) {
                value = FacesAnnotationProcessor.getAnnotationValueMap((AnnotationMirror)value);
            } else if (List.class.isAssignableFrom(value.getClass())) {
                Iterator iter = ((List)((Object)value)).iterator();
                ArrayList<Object> valueList = new ArrayList<Object>();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (AnnotationValue.class.isAssignableFrom(obj.getClass())) {
                        Object annotationValue = ((AnnotationValue)obj).getValue();
                        if (AnnotationMirror.class.isAssignableFrom(annotationValue.getClass())) {
                            valueList.add(FacesAnnotationProcessor.getAnnotationValueMap((AnnotationMirror)annotationValue));
                            continue;
                        }
                        valueList.add(annotationValue);
                        continue;
                    }
                    valueList.add(obj);
                }
                value = valueList;
            }
            annotationValueMap.put(name, value);
        }
        return annotationValueMap;
    }

    private static boolean isNameValid(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String generateReadMethodName(PropertyInfo propertyInfo) {
        String name = propertyInfo.getName();
        String prefix = propertyInfo.getType().equals("boolean") ? "is" : "get";
        return prefix + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private static String generateWriteMethodName(PropertyInfo propertyInfo) {
        String name = propertyInfo.getName();
        return "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private static String generateAddListenerMethodName(EventInfo eventInfo) {
        String name = eventInfo.getName();
        return "add" + name.substring(0, 1).toUpperCase() + name.substring(1) + "Listener";
    }

    private static String generateRemoveListenerMethodName(EventInfo eventInfo) {
        String name = eventInfo.getName();
        return "remove" + name.substring(0, 1).toUpperCase() + name.substring(1) + "Listener";
    }

    private static String generateGetListenersMethodName(EventInfo eventInfo) {
        String name = eventInfo.getName();
        return "get" + name.substring(0, 1).toUpperCase() + name.substring(1) + "Listeners";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaglibDocHandler
    extends DefaultHandler {
        String attrName;
        String attrDescription;
        String tagName;
        String tagDescription;
        StringBuffer buffer = new StringBuffer();
        Stack<String> elementStack = new Stack();
        Map<String, String> tagDescriptionMap = new HashMap<String, String>();
        Map<String, Map> tagAttributeMap = new HashMap<String, Map>();
        Map<String, String> attributeDescriptionMap;

        private TaglibDocHandler() {
        }

        @Override
        public void startDocument() throws SAXException {
            this.tagDescriptionMap.clear();
            this.tagAttributeMap.clear();
            this.elementStack.clear();
        }

        @Override
        public void characters(char[] chars, int start, int length) throws SAXException {
            this.buffer.append(chars, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (localName == null || localName.length() == 0) {
                localName = qName;
            }
            if (localName.equals("tag")) {
                this.attributeDescriptionMap = new HashMap<String, String>();
                this.tagName = null;
                this.tagDescription = null;
            } else if (localName.equals("attribute")) {
                this.attrName = null;
                this.attrDescription = null;
            }
            this.elementStack.push(localName);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.elementStack.pop();
            if (localName == null || localName.length() == 0) {
                localName = qName;
            }
            if (localName.equals("name")) {
                if (this.elementStack.peek().equals("tag")) {
                    this.tagName = this.buffer.toString().trim();
                } else {
                    this.attrName = this.buffer.toString().trim();
                }
            } else if (localName.equals("description")) {
                if (this.elementStack.peek().equals("tag")) {
                    this.tagDescription = this.buffer.toString().trim();
                } else {
                    this.attrDescription = this.buffer.toString().trim();
                }
            } else if (localName.equals("attribute")) {
                if (this.attrDescription != null) {
                    this.attributeDescriptionMap.put(this.attrName, this.attrDescription);
                }
            } else if (localName.equals("tag")) {
                if (this.tagDescription != null) {
                    this.tagDescriptionMap.put(this.tagName, this.tagDescription);
                }
                this.tagAttributeMap.put(this.tagName, this.attributeDescriptionMap);
            }
            this.buffer.setLength(0);
        }

        public Map<String, String> getTagDescriptionMap() {
            return this.tagDescriptionMap;
        }

        public Map<String, Map> getTagAttributeMap() {
            return this.tagAttributeMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MemberDeclarationVisitor
    extends SimpleDeclarationVisitor {
        AnnotationProcessorEnvironment env;
        Map<String, PropertyInfo> propertyInfoMap = new HashMap<String, PropertyInfo>();
        Map<String, EventInfo> eventInfoMap = new HashMap<String, EventInfo>();
        String defaultPropertyName = null;
        String defaultEventName = null;
        private Map<String, CategoryInfo> categoryMap;

        MemberDeclarationVisitor(AnnotationProcessorEnvironment env) {
            this.env = env;
        }

        public void visitFieldDeclaration(FieldDeclaration decl) {
            if (decl.getAnnotation(Property.class) != null) {
                Map annotationMap = FacesAnnotationProcessor.getAnnotationValueMap((Declaration)decl, Property.class.getName());
                DeclaredPropertyInfo propertyInfo = new DeclaredPropertyInfo(annotationMap, (Declaration)decl);
                String name = (String)annotationMap.get("name");
                if (name == null || name.length() == 0) {
                    name = decl.getSimpleName();
                }
                if (Boolean.TRUE.equals(annotationMap.get("isDefault"))) {
                    if (this.defaultPropertyName == null) {
                        this.defaultPropertyName = name;
                    } else {
                        this.env.getMessager().printError(decl.getPosition(), "Duplicate default property");
                    }
                }
                propertyInfo.setName(name);
                propertyInfo.setType(decl.getType().toString());
                if (this.propertyInfoMap.containsKey(name)) {
                    this.env.getMessager().printError(decl.getPosition(), "Duplicate property annotation");
                }
                this.propertyInfoMap.put(name, propertyInfo);
            } else if (decl.getAnnotation(PropertyCategory.class) != null) {
                boolean categoryIsValid = true;
                Collection modifiers = decl.getModifiers();
                if (!decl.getType().toString().equals(CategoryDescriptor.class.getName())) {
                    this.env.getMessager().printError(decl.getPosition(), "Fields identified as property categories must be of type " + CategoryDescriptor.class.getName());
                    categoryIsValid = false;
                }
                if (!modifiers.contains(Modifier.PUBLIC)) {
                    this.env.getMessager().printError(decl.getPosition(), "Non-public field cannot be a property category");
                    categoryIsValid = false;
                }
                if (!modifiers.contains(Modifier.STATIC)) {
                    this.env.getMessager().printError(decl.getPosition(), "Non-static field cannot be a property category");
                    categoryIsValid = false;
                }
                if (categoryIsValid) {
                    CategoryInfo categoryInfo = new CategoryInfo(FacesAnnotationProcessor.getAnnotationValueMap((Declaration)decl, PropertyCategory.class.getName()));
                    String className = decl.getDeclaringType().getQualifiedName();
                    String fieldName = decl.getSimpleName();
                    categoryInfo.setFieldName(className + "." + fieldName);
                    this.categoryMap.put(categoryInfo.getName(), categoryInfo);
                }
            }
        }

        public void visitMethodDeclaration(MethodDeclaration decl) {
            if (decl.getAnnotation(Property.class) != null) {
                Map annotationMap = FacesAnnotationProcessor.getAnnotationValueMap((Declaration)decl, Property.class.getName());
                DeclaredPropertyInfo propertyInfo = new DeclaredPropertyInfo(annotationMap, (Declaration)decl);
                String name = (String)annotationMap.get("name");
                TypeMirror returnType = decl.getReturnType();
                Collection paramDecls = decl.getParameters();
                if (returnType instanceof VoidType && paramDecls.size() == 1) {
                    String methodName = decl.getSimpleName();
                    propertyInfo.setWriteMethodName(methodName);
                    propertyInfo.setType(((ParameterDeclaration)paramDecls.iterator().next()).getType().toString());
                    if (name == null || name.length() == 0) {
                        if (methodName.startsWith("set")) {
                            name = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
                        } else {
                            this.env.getMessager().printError(decl.getPosition(), "Property name implied for a write method name that is not standard");
                        }
                    }
                } else if (!(returnType instanceof VoidType) && paramDecls.size() == 0) {
                    String methodName = decl.getSimpleName();
                    propertyInfo.setReadMethodName(methodName);
                    propertyInfo.setType(returnType.toString());
                    if (name == null || name.length() == 0) {
                        if (methodName.startsWith("get")) {
                            name = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
                        } else if (propertyInfo.getType().equals("boolean") && methodName.startsWith("is")) {
                            name = methodName.substring(2, 3).toLowerCase() + methodName.substring(3);
                        } else {
                            this.env.getMessager().printError(decl.getPosition(), "Property name implied for a read method name that is not standard");
                        }
                    }
                } else {
                    this.env.getMessager().printError(decl.getPosition(), "Annotated property method does not have correct signature");
                }
                if (name != null) {
                    propertyInfo.setName(name);
                    if (this.propertyInfoMap.containsKey(name)) {
                        this.env.getMessager().printError(decl.getPosition(), "Duplicate property annotation");
                    }
                    this.propertyInfoMap.put(name, propertyInfo);
                }
            } else if (decl.getAnnotation(Event.class) != null) {
                Map annotationMap = FacesAnnotationProcessor.getAnnotationValueMap((Declaration)decl, Event.class.getName());
                DeclaredEventInfo eventInfo = new DeclaredEventInfo(annotationMap, (Declaration)decl);
                String name = (String)annotationMap.get("name");
                TypeMirror returnType = decl.getReturnType();
                Collection paramDecls = decl.getParameters();
                if (Boolean.TRUE.equals(annotationMap.get("isDefault"))) {
                    if (this.defaultEventName == null) {
                        this.defaultEventName = name;
                    } else {
                        this.env.getMessager().printError(decl.getPosition(), "Duplicate default event");
                    }
                }
                if (returnType instanceof VoidType && paramDecls.size() == 1) {
                    String methodName = decl.getSimpleName();
                    if (methodName.startsWith("add")) {
                        eventInfo.setAddListenerMethodName(methodName);
                    } else if (methodName.startsWith("remove")) {
                        eventInfo.setRemoveListenerMethodName(methodName);
                    } else {
                        if (!methodName.equals(annotationMap.get("addListenerMethodName")) && !methodName.equals(annotationMap.get("removeListenerMethodName"))) {
                            this.env.getMessager().printError(decl.getPosition(), "Indeterminate event listener method (may be 'add' or 'remove' method)");
                        }
                        if (name == null) {
                            this.env.getMessager().printError(decl.getPosition(), "Event name unspecified for event listener method with non-standard name");
                        }
                    }
                    TypeMirror paramType = ((ParameterDeclaration)paramDecls.iterator().next()).getType();
                    if (DeclaredType.class.isAssignableFrom(paramType.getClass())) {
                        eventInfo.setListenerDeclaration(((DeclaredType)paramType).getDeclaration());
                    } else {
                        try {
                            eventInfo.setListenerClass(Class.forName(paramType.toString()));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (name == null) {
                        String listenerClassName = eventInfo.getListenerClassName();
                        if (listenerClassName.endsWith("Listener")) {
                            int offset = listenerClassName.indexOf(".") >= 0 ? listenerClassName.lastIndexOf(".") + 1 : 0;
                            name = listenerClassName.substring(offset, offset + 1).toLowerCase() + listenerClassName.substring(offset + 1, listenerClassName.indexOf("Listener"));
                        } else {
                            this.env.getMessager().printError(decl.getPosition(), "Event name unspecified for event listener class with non-standard name");
                        }
                    }
                    if (name != null) {
                        eventInfo.setName(name);
                        if (this.eventInfoMap.containsKey(name)) {
                            this.env.getMessager().printError(decl.getPosition(), "Duplicate event annotation");
                        }
                        this.eventInfoMap.put(name, eventInfo);
                    }
                } else {
                    this.env.getMessager().printError(decl.getPosition(), "Invalid signature for an event listener 'add' or 'remove' method");
                }
            }
        }

        public Map<String, PropertyInfo> getPropertyInfoMap() {
            return this.propertyInfoMap;
        }

        public Map<String, EventInfo> getEventInfoMap() {
            return this.eventInfoMap;
        }

        public void setCategoryMap(Map<String, CategoryInfo> categoryMap) {
            this.categoryMap = categoryMap;
        }

        public void reset() {
            this.propertyInfoMap = new HashMap<String, PropertyInfo>();
            this.eventInfoMap = new HashMap<String, EventInfo>();
            this.defaultPropertyName = null;
        }
    }
}

