/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mirror;

import com.sun.faces.mirror.FacesAnnotationProcessor;
import com.sun.faces.mirror.generator.GeneratorFactory;
import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesAnnotationProcessorFactory
implements AnnotationProcessorFactory {
    private static final String LOCALIZE_OPTION = "localize";
    private static final String JAVAEE_VERSION_OPTION = "javaee.version";
    private static final String GENERATE_RUNTIME_OPTION = "generate.runtime";
    private static final String GENERATE_DESIGNTIME_OPTION = "generate.designtime";
    private static final String GENERATOR_FACTORY_OPTION = "generatorfactory";
    private static final String NAMESPACE_URI_OPTION = "namespace.uri";
    private static final String NAMESPACE_PREFIX_OPTION = "namespace.prefix";
    private static final String TAGLIB_DOC_OPTION = "taglibdoc";
    private static final String DEBUG_OPTION = "debug";
    private static final Pattern optionPattern = Pattern.compile("-A\\s*([^\\s=]+)\\s*=?([^\\s=]*)");
    private static final Collection<String> supportedOptions = Collections.unmodifiableList(Arrays.asList("localize"));
    private static final Collection<String> supportedAnnotationTypes = Collections.unmodifiableList(Arrays.asList("*"));

    public Collection<String> supportedAnnotationTypes() {
        return supportedAnnotationTypes;
    }

    public Collection<String> supportedOptions() {
        return supportedOptions;
    }

    public AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> declSet, AnnotationProcessorEnvironment env) {
        FacesAnnotationProcessor annotationProcessor = new FacesAnnotationProcessor(env);
        Map optionMap = env.getOptions();
        for (String key : optionMap.keySet()) {
            Matcher matcher = optionPattern.matcher(key);
            if (!matcher.matches()) continue;
            String name = matcher.group(1);
            String value = matcher.group(2);
            if (name.equals(LOCALIZE_OPTION)) {
                annotationProcessor.setLocalize(true);
                continue;
            }
            if (name.equals(JAVAEE_VERSION_OPTION)) continue;
            if (name.equals(GENERATE_RUNTIME_OPTION)) {
                annotationProcessor.setProcessRunTime(true);
                continue;
            }
            if (name.equals(GENERATE_DESIGNTIME_OPTION)) {
                annotationProcessor.setProcessDesignTime(true);
                continue;
            }
            if (name.equals(GENERATOR_FACTORY_OPTION)) {
                if (value == null || value.length() == 0) {
                    env.getMessager().printError("Option generatorfactory missing value");
                }
                try {
                    Class<?> factoryClass = Class.forName(value);
                    if (!GeneratorFactory.class.isAssignableFrom(factoryClass)) {
                        env.getMessager().printError("Generator factory class must extend " + GeneratorFactory.class.toString());
                        continue;
                    }
                    annotationProcessor.setGeneratorFactoryClass(Class.forName(value));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            if (name.equals(NAMESPACE_URI_OPTION)) {
                if (value == null || value.length() == 0) {
                    env.getMessager().printError("Option namespace.uri missing value");
                }
                annotationProcessor.setNamespaceUri(value);
                continue;
            }
            if (name.equals(NAMESPACE_PREFIX_OPTION)) {
                if (value == null || value.length() == 0) {
                    env.getMessager().printError("Option namespace.prefix missing value");
                }
                annotationProcessor.setNamespacePrefix(value);
                continue;
            }
            if (name.equals(TAGLIB_DOC_OPTION)) {
                if (value == null || value.length() == 0) {
                    env.getMessager().printError("Option taglibdoc missing value");
                }
                annotationProcessor.setTaglibDoc(value);
                continue;
            }
            if (!name.equals(DEBUG_OPTION)) continue;
            annotationProcessor.setDebug(true);
        }
        return annotationProcessor;
    }
}

