/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mirror;

import com.sun.faces.mirror.ClassInfo;
import com.sun.faces.mirror.EventInfo;
import com.sun.faces.mirror.PropertyInfo;
import com.sun.rave.designtime.CategoryDescriptor;
import java.beans.BeanInfo;
import java.beans.MethodDescriptor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntrospectedClassInfo
extends ClassInfo {
    BeanInfo beanInfo;
    Map<String, PropertyInfo> propertyInfoMap;
    Map<String, EventInfo> eventInfoMap;
    Set<String> methodNameSet;
    Set<CategoryDescriptor> categoryDescriptors;

    IntrospectedClassInfo(BeanInfo beanInfo) {
        this.beanInfo = beanInfo;
    }

    public String getName() {
        return this.beanInfo.getBeanDescriptor().getName();
    }

    @Override
    public String getClassName() {
        return this.beanInfo.getBeanDescriptor().getBeanClass().getSimpleName();
    }

    @Override
    public String getPackageName() {
        return this.beanInfo.getBeanDescriptor().getBeanClass().getPackage().getName();
    }

    public BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    @Override
    public ClassInfo getSuperClassInfo() {
        return null;
    }

    @Override
    public boolean isAssignableTo(String qualifiedClassName) {
        try {
            Class<?> superClass = Class.forName(qualifiedClassName);
            if (superClass.isAssignableFrom(this.getBeanInfo().getBeanDescriptor().getBeanClass())) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public Map<String, PropertyInfo> getPropertyInfoMap() {
        return this.propertyInfoMap;
    }

    void setPropertyInfoMap(Map<String, PropertyInfo> propertyInfoMap) {
        this.propertyInfoMap = propertyInfoMap;
    }

    @Override
    public Map<String, EventInfo> getEventInfoMap() {
        return this.eventInfoMap;
    }

    void setEventInfoMap(Map<String, EventInfo> eventInfoMap) {
        this.eventInfoMap = eventInfoMap;
    }

    @Override
    public PropertyInfo getDefaultPropertyInfo() {
        String defaultPropertyName = null;
        int index = this.beanInfo.getDefaultPropertyIndex();
        if (index >= 0) {
            defaultPropertyName = this.beanInfo.getPropertyDescriptors()[index].getName();
        } else {
            try {
                if (Class.forName("javax.faces.component.ValueHolder").isAssignableFrom(this.getBeanInfo().getBeanDescriptor().getBeanClass())) {
                    defaultPropertyName = "value";
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (defaultPropertyName == null) {
            return null;
        }
        return this.getPropertyInfoMap().get(defaultPropertyName);
    }

    @Override
    public EventInfo getDefaultEventInfo() {
        String defaultEventName = null;
        int index = this.beanInfo.getDefaultEventIndex();
        if (index >= 0) {
            defaultEventName = this.beanInfo.getEventSetDescriptors()[index].getName();
        } else {
            try {
                Class<?> beanClass = this.getBeanInfo().getBeanDescriptor().getBeanClass();
                if (Class.forName("javax.faces.component.ActionSource").isAssignableFrom(beanClass)) {
                    defaultEventName = "action";
                } else if (Class.forName("javax.faces.component.EditableValueHolder").isAssignableFrom(beanClass)) {
                    defaultEventName = "valueChange";
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (defaultEventName == null) {
            return null;
        }
        return this.getEventInfoMap().get(defaultEventName);
    }

    @Override
    Set<String> getMethodNameSet() {
        if (this.methodNameSet == null) {
            this.methodNameSet = new HashSet<String>();
            for (MethodDescriptor method : this.getBeanInfo().getMethodDescriptors()) {
                this.methodNameSet.add(method.getName());
            }
        }
        return this.methodNameSet;
    }
}

