/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mirror.generator;

import com.sun.faces.mirror.DeclaredComponentInfo;
import com.sun.faces.mirror.DeclaredRendererInfo;
import com.sun.faces.mirror.generator.FaceletsConfigFileGenerator;
import com.sun.faces.mirror.generator.GeneratorException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Set;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class FaceletsConfigFileGeneratorImpl
extends FaceletsConfigFileGenerator {
    static final String TEMPLATE = "com/sun/faces/mirror/generator/FaceletsConfig.template";
    VelocityEngine velocityEngine;

    FaceletsConfigFileGeneratorImpl(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    public void generate() throws GeneratorException {
        Set<DeclaredComponentInfo> componentInfoSet = this.getDeclaredComponentInfoSet();
        Set<DeclaredRendererInfo> rendererInfoSet = this.getDeclaredRendererInfoSet();
        PrintWriter printWriter = this.getPrintWriter();
        if (componentInfoSet.size() == 0 && rendererInfoSet.size() == 0) {
            return;
        }
        try {
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("date", (Object)DateFormat.getDateInstance(2).format(new Date()));
            velocityContext.put("componentInfoSet", componentInfoSet);
            velocityContext.put("rendererInfoSet", rendererInfoSet);
            velocityContext.put("namespace", (Object)(this.getNamespace() == null ? "" : this.getNamespace()));
            Template template = this.velocityEngine.getTemplate(TEMPLATE);
            template.merge((Context)velocityContext, (Writer)printWriter);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GeneratorException(e);
        }
    }

    public String getFileName() {
        return "facelets.taglib.xml";
    }

    public String getDirectoryName() {
        return "META-INF";
    }
}

