/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mirror.generator;

import com.sun.faces.mirror.DeclaredComponentInfo;
import com.sun.faces.mirror.DeclaredRendererInfo;
import com.sun.faces.mirror.generator.FacesConfigFileGenerator;
import com.sun.faces.mirror.generator.GeneratorException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Set;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

class FacesConfigFileGeneratorImpl
extends FacesConfigFileGenerator {
    static final String TEMPLATE = "com/sun/faces/mirror/generator/FacesConfig.template";
    VelocityEngine velocityEngine;

    FacesConfigFileGeneratorImpl(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    public void generate() throws GeneratorException {
        Set<DeclaredComponentInfo> componentInfoSet = this.getDeclaredComponentInfoSet();
        Set<DeclaredRendererInfo> rendererInfoSet = this.getDeclaredRendererInfoSet();
        Set<String> propertyResolverNameSet = this.getDeclaredPropertyResolverNameSet();
        Set<String> variableResolverNameSet = this.getDeclaredVariableResolverNameSet();
        Set<String> javaeeResolverNameSet = this.getDeclaredJavaEEResolverNameSet();
        PrintWriter printWriter = this.getPrintWriter();
        if (componentInfoSet.size() == 0 && rendererInfoSet.size() == 0) {
            return;
        }
        try {
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("date", (Object)DateFormat.getDateInstance(2).format(new Date()));
            velocityContext.put("componentInfoSet", componentInfoSet);
            velocityContext.put("rendererInfoSet", rendererInfoSet);
            velocityContext.put("propertyResolverNameSet", propertyResolverNameSet);
            velocityContext.put("variableResolverNameSet", variableResolverNameSet);
            velocityContext.put("javaeeResolverNameSet", javaeeResolverNameSet);
            Template template = this.velocityEngine.getTemplate(TEMPLATE);
            template.merge((Context)velocityContext, (Writer)printWriter);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GeneratorException(e);
        }
    }

    public String getFileName() {
        return "faces-config.xml";
    }

    public String getDirectoryName() {
        return "META-INF";
    }
}

