/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mirror.generator;

import com.sun.faces.mirror.DeclaredComponentInfo;
import com.sun.faces.mirror.PropertyInfo;
import com.sun.faces.mirror.generator.GeneratorException;
import com.sun.faces.mirror.generator.TagSourceGenerator;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

class TagSourceGeneratorImpl
extends TagSourceGenerator {
    static final String TEMPLATE = "com/sun/faces/mirror/generator/TagSource.template";
    VelocityEngine velocityEngine;

    public TagSourceGeneratorImpl(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    public void generate() throws GeneratorException {
        try {
            DeclaredComponentInfo componentInfo = this.getDeclaredComponentInfo();
            String namespace = this.getNamespace();
            String namespacePrefix = this.getNamespacePrefix();
            PrintWriter printWriter = this.getPrintWriter();
            ArrayList<PropertyInfo> propertyInfos = new ArrayList<PropertyInfo>();
            propertyInfos.addAll(componentInfo.getInheritedPropertyInfoMap().values());
            propertyInfos.addAll(componentInfo.getPropertyInfoMap().values());
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("date", (Object)DateFormat.getDateInstance(2).format(new Date()));
            velocityContext.put("tagPackage", (Object)this.getPackageName());
            velocityContext.put("tagClass", (Object)this.getClassName());
            velocityContext.put("componentInfo", (Object)componentInfo);
            velocityContext.put("propertyInfos", propertyInfos);
            velocityContext.put("namespace", (Object)(namespace == null ? "" : namespace));
            velocityContext.put("namespacePrefix", (Object)(namespacePrefix == null ? "" : namespacePrefix));
            Template template = this.velocityEngine.getTemplate(TEMPLATE);
            template.merge((Context)velocityContext, (Writer)printWriter);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GeneratorException(e);
        }
    }

    public String getPackageName() {
        return this.getDeclaredComponentInfo().getPackageName();
    }

    public String getClassName() {
        return this.getDeclaredComponentInfo().getClassName() + "Tag";
    }
}

