/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class RenameAction
extends NodeAction {
    protected boolean surviveFocusChange() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(RenameAction.class, "Rename");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RenameAction.class);
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        return activatedNodes[0].canRename();
    }

    protected void performAction(Node[] activatedNodes) {
        Node n = activatedNodes[0];
        NotifyDescriptor.InputLine dlg = new NotifyDescriptor.InputLine(NbBundle.getMessage(RenameAction.class, "CTL_RenameLabel"), NbBundle.getMessage(RenameAction.class, "CTL_RenameTitle"));
        dlg.setInputText(n.getName());
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify(dlg))) {
            String newname = null;
            try {
                newname = dlg.getInputText();
                if (!newname.equals("")) {
                    n.setName(dlg.getInputText());
                }
            }
            catch (IllegalArgumentException e) {
                ErrorManager em = ErrorManager.getDefault();
                ErrorManager.Annotation[] ann = em.findAnnotations(e);
                boolean needToAnnotate = true;
                if (ann != null && ann.length > 0) {
                    for (int i = 0; i < ann.length; ++i) {
                        String glm = ann[i].getLocalizedMessage();
                        if (glm == null || glm.equals("")) continue;
                        needToAnnotate = false;
                    }
                }
                if (needToAnnotate) {
                    em.annotate((Throwable)e, NbBundle.getMessage(RenameAction.class, "MSG_BadFormat", n.getName(), newname));
                }
                em.notify(e);
            }
        }
    }

    protected boolean asynchronous() {
        return false;
    }
}

