/*
 * Decompiled with CFR 0.152.
 */
package org.openide.options;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextProxy;
import java.beans.beancontext.BeanContextSupport;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Comparator;
import org.openide.ErrorManager;
import org.openide.options.SystemOption;
import org.openide.util.io.NbMarshalledObject;

public abstract class ContextSystemOption
extends SystemOption
implements BeanContextProxy {
    protected BeanContext beanContext = this.getBeanContext();
    private static Object ctxt = new Object();
    private static final long serialVersionUID = -781528552645947127L;

    public final void addOption(SystemOption so) {
        this.getBeanContext().add(so);
    }

    public final void removeOption(SystemOption so) {
        this.getBeanContext().remove(so);
    }

    public final SystemOption[] getOptions() {
        Object[] objs = this.getBeanContext().toArray();
        int j = 0;
        for (int i = 0; i < objs.length; ++i) {
            if (!(objs[i] instanceof SystemOption)) continue;
            if (i > j) {
                objs[j] = objs[i];
            }
            ++j;
        }
        SystemOption[] options = new SystemOption[j];
        System.arraycopy(objs, 0, options, 0, j);
        return options;
    }

    public final BeanContextChild getBeanContextProxy() {
        return this.getBeanContext();
    }

    private BeanContext getBeanContext() {
        return (BeanContext)this.getProperty(ctxt);
    }

    protected void initialize() {
        super.initialize();
        this.putProperty(ctxt, new OptionBeanContext(this));
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        Object[] objects = this.getBeanContext().toArray();
        Arrays.sort(objects, new ClassComparator());
        for (int i = 0; i < objects.length; ++i) {
            out.writeObject(new NbMarshalledObject(objects[i]));
        }
        out.writeObject(null);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        Object obj = in.readObject();
        if (obj instanceof BeanContext) {
            this.beanContext = (BeanContext)obj;
        } else {
            BeanContext c = this.getBeanContext();
            while (obj != null) {
                NbMarshalledObject m = (NbMarshalledObject)obj;
                try {
                    c.add(m.get());
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify(1, e);
                }
                catch (LinkageError e) {
                    ErrorManager.getDefault().notify(1, e);
                }
                obj = in.readObject();
            }
        }
    }

    private static class OptionBeanContext
    extends BeanContextSupport
    implements PropertyChangeListener {
        private ContextSystemOption parent = null;
        private static final long serialVersionUID = 3532434266136225440L;

        public OptionBeanContext(ContextSystemOption p) {
            this.parent = p;
        }

        public boolean add(Object targetChild) {
            if (!(targetChild instanceof SystemOption)) {
                throw new IllegalArgumentException("Not a SystemOption: " + targetChild);
            }
            boolean b = super.add(targetChild);
            if (b) {
                ((SystemOption)targetChild).addPropertyChangeListener(this);
            }
            return b;
        }

        public boolean remove(Object targetChild) {
            if (!(targetChild instanceof SystemOption)) {
                throw new IllegalArgumentException("Not a SystemOption: " + targetChild);
            }
            boolean b = super.remove(targetChild);
            if (b) {
                ((SystemOption)targetChild).removePropertyChangeListener(this);
            }
            return b;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (this.parent != null) {
                this.parent.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        }
    }

    private static class ClassComparator
    implements Comparator {
        ClassComparator() {
        }

        public int compare(Object o1, Object o2) {
            return o1.getClass().getName().compareTo(o2.getClass().getName());
        }
    }
}

