/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import org.openide.ErrorManager;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

public final class RequestProcessor {
    private static RequestProcessor DEFAULT = new RequestProcessor();
    private static RequestProcessor UNLIMITED = new RequestProcessor("Default RequestProcessor", 50);
    private static Timer starterThread = new Timer(true);
    private static ErrorManager logger;
    String name;
    private static int counter;
    boolean stopped = false;
    private Object processorLock = new Object();
    private HashSet processors = new HashSet();
    private List queue = new LinkedList();
    private int running = 0;
    private int throughput;
    static final boolean SLOW;
    static /* synthetic */ Class class$org$openide$util$RequestProcessor;

    public RequestProcessor() {
        this(null, 1);
    }

    public RequestProcessor(String name) {
        this(name, 1);
    }

    public RequestProcessor(String name, int throughput) {
        this.throughput = throughput;
        this.name = name != null ? name : "OpenIDE-request-processor-" + counter++;
    }

    public static RequestProcessor getDefault() {
        return UNLIMITED;
    }

    public Task post(Runnable run) {
        return this.post(run, 0, 1);
    }

    public Task post(Runnable run, int timeToWait) {
        return this.post(run, timeToWait, 1);
    }

    public Task post(Runnable run, int timeToWait, int priority) {
        Task task = new Task(run, priority);
        task.schedule(timeToWait);
        return task;
    }

    public Task create(Runnable run) {
        return new Task(run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRequestProcessorThread() {
        Thread c = Thread.currentThread();
        Object object = this.processorLock;
        synchronized (object) {
            return this.processors.contains(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this == UNLIMITED || this == DEFAULT) {
            throw new IllegalArgumentException("Can't stop shared RP's");
        }
        Object object = this.processorLock;
        synchronized (object) {
            this.stopped = true;
            Iterator it = this.processors.iterator();
            while (it.hasNext()) {
                ((Processor)it.next()).interrupt();
            }
        }
    }

    public static Task postRequest(Runnable run) {
        return DEFAULT.post(run);
    }

    public static Task postRequest(Runnable run, int timeToWait) {
        return DEFAULT.post(run, timeToWait);
    }

    public static Task postRequest(Runnable run, int timeToWait, int priority) {
        return DEFAULT.post(run, timeToWait, priority);
    }

    public static Task createRequest(Runnable run) {
        return DEFAULT.create(run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ErrorManager logger() {
        Timer timer = starterThread;
        synchronized (timer) {
            if (logger == null) {
                logger = ErrorManager.getDefault().getInstance("org.openide.util.RequestProcessor");
            }
            return logger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueue(Item item) {
        Object object = this.processorLock;
        synchronized (object) {
            if (item.getTask() == null) {
                return;
            }
            this.prioritizedEnqueue(item);
            if (this.running < this.throughput) {
                ++this.running;
                Processor proc = Processor.get();
                this.processors.add(proc);
                proc.setName(this.name);
                proc.attachTo(this);
            }
        }
    }

    private void prioritizedEnqueue(Item item) {
        int iprio = item.getPriority();
        if (this.queue.isEmpty()) {
            this.queue.add(item);
            item.enqueued = true;
            return;
        }
        if (iprio > ((Item)this.queue.get(this.queue.size() - 1)).getPriority()) {
            ListIterator<Item> it = this.queue.listIterator();
            while (it.hasNext()) {
                Item next = (Item)it.next();
                if (iprio <= next.getPriority()) continue;
                it.set(item);
                it.add(next);
                item.enqueued = true;
                return;
            }
            throw new IllegalStateException("Prioritized enqueue failed!");
        }
        this.queue.add(item);
        item.enqueued = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task askForWork(Processor worker, String debug) {
        Object object = this.processorLock;
        synchronized (object) {
            if (this.stopped || this.queue.isEmpty()) {
                this.processors.remove(worker);
                Processor.put(worker, debug);
                --this.running;
                return null;
            }
            Item i = (Item)this.queue.remove(0);
            Task t = i.getTask();
            i.clear();
            return t;
        }
    }

    static {
        counter = 0;
        SLOW = Boolean.getBoolean("org.openide.util.RequestProcessor.Item.SLOW");
    }

    private static class Processor
    extends Thread {
        private static Stack pool = new Stack();
        private RequestProcessor source;
        private static final int INACTIVE_TIMEOUT = 60000;
        private boolean idle = true;
        private Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Processor get() {
            Stack stack = pool;
            synchronized (stack) {
                if (pool.isEmpty()) {
                    Processor proc = new Processor();
                    proc.idle = false;
                    proc.start();
                    return proc;
                }
                Processor proc = (Processor)pool.pop();
                proc.idle = false;
                return proc;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void put(Processor proc, String last) {
            Stack stack = pool;
            synchronized (stack) {
                proc.setName("Inactive RequestProcessor thread [Was:" + proc.getName() + "/" + last + "]");
                proc.idle = true;
                pool.push(proc);
            }
        }

        public Processor() {
            super(Processor.getTopLevelThreadGroup(), "Inactive RequestProcessor thread");
            this.setDaemon(true);
        }

        void setPrio(int priority) {
            if (priority != this.getPriority()) {
                this.setPriority(priority);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void attachTo(RequestProcessor src) {
            Object object = this.lock;
            synchronized (object) {
                this.source = src;
                this.lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Task todo;
                RequestProcessor current = null;
                Object object = this.lock;
                synchronized (object) {
                    try {
                        if (this.source == null) {
                            this.lock.wait(60000L);
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    current = this.source;
                    this.source = null;
                    if (current == null) {
                        Stack e = pool;
                        synchronized (e) {
                            if (this.idle) {
                                pool.remove(this);
                                break;
                            }
                            continue;
                        }
                    }
                }
                String debug = null;
                ErrorManager em = RequestProcessor.logger();
                boolean loggable = em.isLoggable(1);
                if (loggable) {
                    em.log(1, "Begining work " + this.getName());
                }
                while ((todo = current.askForWork(this, debug)) != null) {
                    this.setPrio(todo.getPriority());
                    try {
                        if (loggable) {
                            RequestProcessor.logger().log("  Executing " + todo);
                        }
                        todo.run();
                        if (loggable) {
                            RequestProcessor.logger().log("  Execution finished in" + this.getName());
                        }
                        debug = todo.debug();
                    }
                    catch (OutOfMemoryError oome) {
                        ErrorManager.getDefault().notify(oome);
                    }
                    catch (StackOverflowError e) {
                        e.printStackTrace();
                        Processor.doNotify(todo, e);
                    }
                    catch (Throwable t) {
                        Processor.doNotify(todo, t);
                    }
                    todo = null;
                }
                if (!loggable) continue;
                RequestProcessor.logger().log(1, "Work finished " + this.getName());
            }
        }

        private static void doNotify(Task todo, Throwable ex) {
            ErrorManager err = ErrorManager.getDefault();
            err.annotate(ex, 4096, null, NbBundle.getMessage(class$org$openide$util$RequestProcessor == null ? (class$org$openide$util$RequestProcessor = RequestProcessor.class$("org.openide.util.RequestProcessor")) : class$org$openide$util$RequestProcessor, "EXC_IN_REQUEST_PROCESSOR"), SLOW ? todo.item : null, null);
            err.notify(ex);
        }

        static ThreadGroup getTopLevelThreadGroup() {
            PrivilegedAction run = new PrivilegedAction(){

                public Object run() {
                    ThreadGroup current = Thread.currentThread().getThreadGroup();
                    while (current.getParent() != null) {
                        current = current.getParent();
                    }
                    return current;
                }
            };
            return (ThreadGroup)AccessController.doPrivileged(run);
        }
    }

    private static class Item
    extends Exception {
        private final RequestProcessor owner;
        private Task action;
        private boolean enqueued;

        Item(Task task, RequestProcessor rp) {
            super("Posted StackTrace");
            this.action = task;
            this.owner = rp;
        }

        Task getTask() {
            return this.action;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean clear() {
            Object object = this.owner.processorLock;
            synchronized (object) {
                this.action = null;
                return this.enqueued ? this.owner.queue.remove(this) : true;
            }
        }

        int getPriority() {
            return this.action.getPriority();
        }

        public Throwable fillInStackTrace() {
            return SLOW ? super.fillInStackTrace() : this;
        }
    }

    public final class Task
    extends org.openide.util.Task
    implements Cancellable {
        private Item item;
        private int priority;
        private long time;
        private Thread lastThread;

        Task(Runnable run) {
            super(run);
            this.priority = 1;
            this.time = 0L;
            this.lastThread = null;
        }

        Task(Runnable run, int priority) {
            super(run);
            this.priority = 1;
            this.time = 0L;
            this.lastThread = null;
            if (priority < 1) {
                priority = 1;
            }
            if (priority > 10) {
                priority = 10;
            }
            this.priority = priority;
        }

        public void run() {
            this.lastThread = Thread.currentThread();
            super.run();
            this.lastThread = null;
        }

        public int getDelay() {
            long delay = this.time - System.currentTimeMillis();
            if (delay < 0L) {
                return 0;
            }
            if (delay > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)delay;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void schedule(int delay) {
            Item localItem;
            if (RequestProcessor.this.stopped) {
                throw new IllegalStateException("RequestProcessor already stopped!");
            }
            this.time = System.currentTimeMillis() + (long)delay;
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                this.notifyRunning();
                if (this.item != null) {
                    this.item.clear();
                }
                localItem = this.item = new Item(this, RequestProcessor.this);
            }
            if (delay == 0) {
                RequestProcessor.this.enqueue(localItem);
            } else {
                starterThread.schedule(new TimerTask(this, localItem){
                    private final /* synthetic */ Item val$localItem;
                    private final /* synthetic */ Task this$1;
                    {
                        this.this$1 = this$1;
                        this.val$localItem = val$localItem;
                    }

                    public void run() {
                        try {
                            Task.access$100(this.this$1).enqueue(this.val$localItem);
                        }
                        catch (RuntimeException e) {
                            ErrorManager.getDefault().notify(e);
                        }
                    }
                }, delay);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel() {
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                boolean success;
                boolean bl = success = this.item == null ? false : this.item.clear();
                if (success) {
                    this.notifyFinished();
                }
                return success;
            }
        }

        public int getPriority() {
            return this.priority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPriority(int priority) {
            if (this.priority == priority) {
                return;
            }
            if (priority < 1) {
                priority = 1;
            }
            if (priority > 10) {
                priority = 10;
            }
            this.priority = priority;
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                if (this.item == null) {
                    return;
                }
                if (RequestProcessor.this.queue.remove(this.item)) {
                    RequestProcessor.this.prioritizedEnqueue(this.item);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitFinished() {
            if (RequestProcessor.this.isRequestProcessorThread()) {
                boolean toRun;
                Object object = RequestProcessor.this.processorLock;
                synchronized (object) {
                    toRun = !this.isFinished() && (this.item == null || this.item.clear());
                }
                if (toRun) {
                    this.run();
                } else if (this.lastThread != Thread.currentThread()) {
                    super.waitFinished();
                }
            } else {
                super.waitFinished();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitFinished(long timeout) throws InterruptedException {
            if (RequestProcessor.this.isRequestProcessorThread()) {
                boolean toRun;
                Object object = RequestProcessor.this.processorLock;
                synchronized (object) {
                    toRun = !this.isFinished() && (this.item == null || this.item.clear());
                }
                if (toRun) {
                    throw new InterruptedException("Cannot wait with timeout " + timeout + " from the RequestProcessor thread for task: " + this);
                }
                if (this.lastThread != Thread.currentThread()) {
                    return super.waitFinished(timeout);
                }
                return true;
            }
            return super.waitFinished(timeout);
        }

        public String toString() {
            return "RequestProcessor.Task [" + RequestProcessor.this.name + ", " + this.priority + "] for " + super.toString();
        }

        static /* synthetic */ RequestProcessor access$100(Task x0) {
            return x0.RequestProcessor.this;
        }
    }
}

