/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.netbeans.modules.openide.util.AWTBridge;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public abstract class CallableSystemAction
extends SystemAction
implements Presenter.Menu,
Presenter.Popup,
Presenter.Toolbar {
    static final long serialVersionUID = 2339794599168944156L;
    private static final Set warnedAsynchronousActions;
    private static RequestProcessor RP;
    private static final boolean DEFAULT_ASYNCH;
    private static Object invokeInstance;
    private static Object invokeAction;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JMenuItem getMenuPresenter() {
        return AWTBridge.getDefault().createMenuPresenter(this);
    }

    public JMenuItem getPopupPresenter() {
        return AWTBridge.getDefault().createPopupPresenter(this);
    }

    public Component getToolbarPresenter() {
        return AWTBridge.getDefault().createToolbarPresenter(this);
    }

    public abstract void performAction();

    public void actionPerformed(ActionEvent ev) {
        if (this.isEnabled()) {
            this.doPerformAction(new ActionRunnable(ev){

                public void run() {
                    CallableSystemAction.this.performAction();
                }
            });
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    final void doPerformAction(final ActionRunnable r) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError((Object)("Action " + this.getClass().getName() + " may not be invoked from the thread " + Thread.currentThread().getName() + ", only the event queue: http://www.netbeans.org/download/dev/javadoc/OpenAPIs/apichanges.html#actions-event-thread"));
        }
        if (this.asynchronous() && !r.needsToBeSynchronous()) {
            Runnable r2 = new Runnable(){

                public void run() {
                    r.doRun();
                }
            };
            RP.post(r2);
        } else {
            r.run();
        }
    }

    protected boolean asynchronous() {
        if (warnedAsynchronousActions.add(this.getClass())) {
            ErrorManager.getDefault().log(16, "Warning - " + this.getClass().getName() + " should override CallableSystemAction.asynchronous() to return false");
        }
        return DEFAULT_ASYNCH;
    }

    private static void invokeAction(Action action, ActionEvent ev) {
        if (invokeAction == null) {
            ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (loader == null) {
                loader = CallableSystemAction.class.getClassLoader();
            }
            try {
                Class<?> clazz = Class.forName("org.openide.actions.ActionManager", true, loader);
                invokeInstance = Lookup.getDefault().lookup(clazz);
                invokeAction = invokeInstance != null ? clazz.getMethod("invokeAction", Action.class, ActionEvent.class) : new Object();
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, ex);
                invokeAction = new Object();
            }
        }
        if (invokeAction instanceof Method) {
            Method m = (Method)invokeAction;
            try {
                m.invoke(invokeInstance, action, ev);
                return;
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(ex);
            }
        }
        action.actionPerformed(ev);
    }

    static {
        $assertionsDisabled = !CallableSystemAction.class.desiredAssertionStatus();
        warnedAsynchronousActions = new WeakSet();
        RP = new RequestProcessor("Module-Actions", Integer.MAX_VALUE);
        DEFAULT_ASYNCH = !Boolean.getBoolean("org.openide.util.actions.CallableSystemAction.synchronousByDefault");
    }

    abstract class ActionRunnable
    implements Action {
        private ActionEvent ev;

        public ActionRunnable(ActionEvent ev) {
            this.ev = ev;
        }

        public final boolean needsToBeSynchronous() {
            return "waitFinished".equals(this.ev.getActionCommand());
        }

        public final void doRun() {
            CallableSystemAction.invokeAction(this, this.ev);
        }

        protected abstract void run();

        public final void actionPerformed(ActionEvent e) {
            this.run();
        }

        public final void addPropertyChangeListener(PropertyChangeListener listener) {
            throw new UnsupportedOperationException();
        }

        public final Object getValue(String key) {
            return CallableSystemAction.this.getValue(key);
        }

        public final boolean isEnabled() {
            return CallableSystemAction.this.isEnabled();
        }

        public final void putValue(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        public final void removePropertyChangeListener(PropertyChangeListener listener) {
            throw new UnsupportedOperationException();
        }

        public final void setEnabled(boolean b) {
            throw new UnsupportedOperationException();
        }
    }
}

