/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://woodstock.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://woodstock.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2007 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.webui.jsf.theme;

/**
 * <p> This class contains HTML template related theme constants.</p>
 */
public class ThemeTemplates {
    
    /**
     * A template file that contains HTML for the alarm component.
     */
    public static final String ALARM = "alarm";

    /**
     * A template file that contains HTML for the anchor component.
     */
    public static final String ANCHOR = "anchor";    
    
    /**
     * A template file that contains HTML for the alert component.
     */
    public static final String ALERT = "alert";
    
    /**
     * A template file that contains HTML for the Bubble Help component.
     */
    public static final String BUBBLE = "bubble";

    /**
     * A template file that contains HTML for the button component.
     */
    public static final String BUTTON = "button";

    /**
     * A template file that contains HTML for the Calendar component.
     */
    public static final String CALENDAR = "calendar";
    
    /**
     * A template file that contains HTML for the CalendarMonth component.
     */
    public static final String CALENDARMONTH = "calendarMonth";
    
    /**
     * A template file that contains HTML for the Checkbox component.
     */
    public static final String CHECKBOX = "checkbox";
    
    /**
     * A template file that contains HTML for the checkbox group components.
     */
    public static final String CHECKBOXGROUP = "checkboxGroup"; 

    /**
     * A template file that contains HTML for the DropDown component.
     */
    public static final String DROPDOWN = "dropDown";
    
    /**
     * A template file that contains HTML for the hiddenField component.
     */
    public static final String HIDDENFIELD = "hiddenField";

    /**
     * A template file that contains HTML for the image component.
     */
    public static final String IMAGE = "image";

    /**
     * A template file that contains HTML for the image button component.
     */
    public static final String IMAGEBUTTON = "imageButton";

    /**
     * A template file that contains HTML for the ImageHyperlink component.
     */
    public static final String IMAGEHYPERLINK= "imageHyperlink";
    
    /**
     * A template file that contains HTML for the Label component.
     */
    public static final String LABEL = "label";
    
    /**
     * A template file that contains HTML for the Listbox component.
     */
    public static final String LISTBOX = "listbox";

    /**
     * A template file that contains HTML for the PasswordField component.
     */
    public static final String PASSWORDFIELD= "passwordField";

    /**
     * A template file that contains HTML for the ProgressBar component.
     */
    public static final String PROGRESSBAR = "progressBar";

    /**
     * A template file that contains HTML for the radioButton component.
     */
    public static final String RADIOBUTTON = "radioButton"; 
    
    /**
     * A template file that contains HTML for the radioButton group components.
     */
    public static final String RADIOBUTTONGROUP = "radioButtonGroup"; 

    /**
     * A template file that contains HTML for the reset button component.
     */
    public static final String RESETBUTTON = "resetButton";

    /**
     * A template file that contains HTML for the staticText component.
     */
    public static final String STATICTEXT = "staticText";

    /**
     * A template file that contains HTML for the Table2 component.
     */
    public static final String TABLE2 = "table2";

    /**
     * A template file that contains HTML for the Table2RowGroup component.
     */
    public static final String TABLE2ROWGROUP = "table2RowGroup";

    /**
     * A template file that contains HTML for the TextField component.
     */
    public static final String TEXTFIELD= "textField";
    
    /**
     * A template file that contains HTML for the TextArea component.
     */
    public static final String TEXTAREA= "textArea";

    /**
     * A template file that contains HTML for the accordion component.
     */
    public static final String ACCORDION = "accordion";

    /**
     * A template file that contains HTML for the accordion tab component.
     */
    public static final String ACCORDIONTAB = "accordionTab";

   /**
     * A template file that contains HTML for the popupMenu component.
     */
    public static String POPUPMENU = "popupMenu";

    /**
     * A template file that contains HTML for the Login component.
     */
    public static final String LOGIN = "login";

    /**
     * A template file that contains HTML for the rating component.
     */
    public static final String RATING = "rating";
    
    /**
     * This private constructor prevents this class from being instantiated
     * directly as its only purpose is to provide image constants.
     */
    private ThemeTemplates() {
        // do nothing
    }
}


