# Administration

The administration UI enables a sign service admin to perform the following actions:

- Create a new sign service user account (used by the sign client to authenticate)
- Configure which certificate, Key Vault, and Timestamp server a sign service user uses
- Create certificate signing requests, merge the certificate back to the server
- Disable a sign service user account

Currently, "destructive" operations, like deleting a sign service user account, removing certificates, removing key vaults, are not supported in the UI and require an alternate means (such as using the Azure Portal).

## Granting Access to the Admin UI

By default, the user who runs the `InstallUtility` is granted access to the Admin UI. Access is controlled via Azure AD application role assignments, and additional users/groups can be added via the AAD Portal.

TODO: Insert screenshot here.

## Creating a Sign Service User Account

The Sign Service requires user accounts to be used as service accounts. This is due to a current limitation of Azure AD that doesn't allow a Service Principal to Service Principal On-Behalf-Of flow. That flow is part of the defense-in-depth, preventing the signing service from having direct access to the signing functions on its own. The service can only access the signing method on-behalf-of the user at the time of request.

It is recommended to create new accounts for this purpose and let the admin UI control them. Creating the user also creates a matched key vault and sets the appropriate security between them.

Create a new account by going to the Users area and clicking the "Create new sign service account" link and filling in the fields:

| Field | Value |
| ----- | ----- |
| Username | The User Principal Name. If a domain is specified, it must be one of the verified domains of the tenant. If not specified, will default to the `Domain` configuration value. This must be unique per tenant. |
| DisplayName| Friendly name that shows up in the AAD Portal and other places. |
| Configured | Controls access to the service. If unchecked, user cannot login to the sign service. To enable, the `KeyVaultUrl`, `CertificateName` and `TimestampUrl` fields must all be filled in. Recommendation is to leave unchecked and leave `KeyVaultUrl` blank here. |
| KeyVaultUrl | Url to the key vault, like `https://myvault.vault.azure.net`. Leave blank to have a new key vault created and configured for the user. Recommended to leave blank.
| CertificateName | Name of the certificate in the vault. Leave blank if `KeyVaultUrl` is blank. |
| TimestampUrl | Url of RFC 3161 Timestamp server. E.g. `http://timestamp.digicert.com` or the one you need to use. |

Clicking `Create` creates the user and related Key Vault. The screen shows the password for the account (randomly generated). Store the password for use later as it is not available again. Passwords may be reset on the Edit User screen if the user logged in is a Global Admin of the tenant.

## Create a CSR or upload a certificate

Go to the Key Vaults area and find the newly created vault for the user. Select `Details` to see the available certificates. If this is a new vault, there won't be any.

Using an existing PFX file is not supported in the UI as it's inherently less-secure than the certificates generated by the sign service. The sign service certificates use a key that can never leave the HSM boundary. If you want to use an existing key, you can upload that in the Azure Portal by navigating to the Key Vault and going to its Certificates area. Once there, it'll be available to select as described below.

Click `New Certificate`, give the certificate a name and click Create. The `CertificateName` does not matter, long as it's unique within the Vault. This is the value you'll configure on the user later.

On the next page, copy the CSR text and provide it to your Certificate Authority on your Code Signing order entry page. This CSR can be used for Extended Validation (EV) Code Signing certificates, as it meets the requirements by residing on a FIPS 140-2 Level 2 HSM.

After your CA completes the request, and in the case of an EV certificate, may require an HSM attestation letter attesting to the FIPS 140-2 Level 2 compliance, you can return to the request by going to the Key Vault certificate details page, and uploading the `.CER` file. The key vault certificates list should now show the certificate thumbprint and expiration date.

Now, you can go back to the Users area, click `Edit` on the User. The `KeyVaultUrl` will be filled in automatically. There will be a drop-down showing the certificates. Select the one you want, ensure the `TimestampUrl` has a value, check the `Configured` box and hit Save.

The sign client can now be used with the configured user credentials.