# Vuex 入門

Vuex アプリケーションの中心にあるものは **ストア** です。"ストア"は、基本的にアプリケーションの**状態**を保持するコンテナです。単純なグローバルオブジェクトとの違いが2つあります。

1. Vuex ストアはリアクティブです。 Vue コンポーネントがストアから状態を取り出すとき、もし、ストアの状態が変化したら、ストアは、リアクティブかつ効率的に更新を行います。

2. ストアの状態を直接変更することはできません。明示的な **ミューテーション**のディスパッチによってのみ、ストアの状態を変更します。これによって、全ての状態の変更の追跡を容易にし、ツールでのアプリケーションの動作の理解を助けます。

### シンプルなストア

> **注意:** 私たちは、このドキュメントのコード例に ES2015 のシンタックスを利用しています。 もし、触れたことがなければ、[ぜひ、触れてください](https://babeljs.io/docs/learn-es2015/)! このドキュメントは、他に[大規模アプリケーションの構築](https://jp.vuejs.org/guide/application.html)に書かれたコンセプトを既に読まれていることを前提にしています。

Vuex ストアの作成は、かなり単純です。ストアオブジェクトの初期状態と、いくつかのミューテーションを準備するだけです。

``` js
import Vuex from 'vuex'

const state = {
  count: 0
}

const mutations = {
  INCREMENT (state) {
    state.count++
  }
}

export default new Vuex.Store({
  state,
  mutations
})
```

`store.state` でストアオブジェクトの状態を参照でき、また、ミューションの名前でディスパッチすることで、ミューテーションをトリガーできます。

``` js
store.dispatch('INCREMENT')

console.log(store.state.count) // -> 1
```

もし、オブジェクトスタイルのディスパッチがよければ、以下のように記述して、おこなうことができます。

``` js
// 先の例と同じ効果
store.dispatch({
  type: 'INCREMENT'
})
```

もう一度、`store.state.count` を直接変更する代わりにミューテーションをディスパッチする理由について、確認しておきましょう。このシンプルな規約は、あなたのコードの意図をさらに明確にし、コードを読んだ時にアプリケーションの状態の変更について、論理的に考えることができるようにします。加えて、私たちに全ての変更のログを取ったり、状態のスナップショットを取ったり、タイムトラベルデバッグを行うようなツールを実装する余地を与えてくれます。

今回は最も単純な例を通して、ストアが何かについて説明してきました。しかし、 Vuex はストアだけではありません。次から、[ステート](state.md)、[ミューテーション](mutations.md)、[アクション](actions.md)といった Vuex のコアコンセプトについて詳しく説明していきます。
