﻿// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.
// FxCop Suppression file
// To Use:
// Add module level suppressions to this file to have them suppressed in the assembly
//

using System.Diagnostics.CodeAnalysis;
#if CODE_ANALYSIS
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.BackEnd.TaskHostConfiguration.#.ctor(System.Int32,System.String,System.Collections.Generic.IDictionary`2<System.String,System.String>,System.Globalization.CultureInfo,System.Globalization.CultureInfo,System.AppDomainSetup,System.Int32,System.Int32,System.String,System.Boolean,System.String,System.String,System.Collections.Generic.IDictionary`2<System.String,System.Object>)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#.ctor(System.String,System.Boolean)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#get_AssemblyName()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#CompareBaseNamesStringWise(System.String,System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#CompareBaseNameTo(Microsoft.Build.Shared.AssemblyNameExtension)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#CompareBaseNameToImpl(Microsoft.Build.Shared.AssemblyNameExtension)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#CompareTo(Microsoft.Build.Shared.AssemblyNameExtension)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#EqualsIgnoreVersion(Microsoft.Build.Shared.AssemblyNameExtension)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#EscapeDisplayNameCharacters(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#get_FullName()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#GetHashCode()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#get_HasProcessorArchitectureInFusionName()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#get_IsSimpleName()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#get_IsUnnamedAssembly()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#PartialNameCompare(Microsoft.Build.Shared.AssemblyNameExtension)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#AddRemappedAssemblyName(Microsoft.Build.Shared.AssemblyNameExtension)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#Clone()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#CloneImmutable()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#get_Immutable()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#MarkImmutable()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#PartialNameCompare(Microsoft.Build.Shared.AssemblyNameExtension,Microsoft.Build.Shared.PartialComparisonFlags,System.Boolean)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#PartialNameCompare(Microsoft.Build.Shared.AssemblyNameExtension,System.Boolean)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#get_ProcessorArchitecture()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#get_RemappedFromEnumerator()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#GetAssemblyNameEx(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#PartialNameCompare(Microsoft.Build.Shared.AssemblyNameExtension,Microsoft.Build.Shared.PartialComparisonFlags)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#ReplaceVersion(System.Version)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyNameExtension.#get_UnnamedAssembly()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.CollectionHelpers.#RemoveNulls`1(System.Collections.Generic.List`1<!!0>)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ErrorUtilities.#VerifyThrowInternalLockHeld(System.Object)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ErrorUtilities.#DebugTraceMessage(System.String,System.String,System.Object[])", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ErrorUtilities.#ThrowArgument(System.String,System.Object[])", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ErrorUtilities.#ThrowArgumentOutOfRange(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ErrorUtilities.#ThrowIfTypeDoesNotImplementToString(System.Object)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ErrorUtilities.#VerifyThrow(System.Boolean,System.String,System.Object,System.Object)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ErrorUtilities.#VerifyThrow(System.Boolean,System.String,System.Object,System.Object,System.Object)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ErrorUtilities.#VerifyThrow(System.Boolean,System.String,System.Object,System.Object,System.Object,System.Object)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ErrorUtilities.#VerifyThrowArgument(System.Boolean,System.Exception,System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ErrorUtilities.#VerifyThrowArgument(System.Boolean,System.Exception,System.String,System.Object,System.Object)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ErrorUtilities.#VerifyThrowArgument(System.Boolean,System.Exception,System.String,System.Object,System.Object,System.Object)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ErrorUtilities.#VerifyThrowArgument(System.Boolean,System.Exception,System.String,System.Object,System.Object,System.Object,System.Object)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ErrorUtilities.#VerifyThrowArgument(System.Boolean,System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ErrorUtilities.#VerifyThrowArgument(System.Boolean,System.String,System.Object,System.Object)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ErrorUtilities.#VerifyThrowArgument(System.Boolean,System.String,System.Object,System.Object,System.Object)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ErrorUtilities.#VerifyThrowArgument(System.Boolean,System.String,System.Object,System.Object,System.Object,System.Object)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ErrorUtilities.#VerifyThrowArgumentArraysSameLength(System.Array,System.Array,System.String,System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ErrorUtilities.#VerifyThrowArgumentLengthIfNotNull(System.String,System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ErrorUtilities.#VerifyThrowArgumentOutOfRange(System.Boolean,System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ErrorUtilities.#VerifyThrowInternalLength(System.String,System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ErrorUtilities.#VerifyThrowInternalRooted(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ErrorUtilities.#VerifyThrowInvalidOperation(System.Boolean,System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ErrorUtilities.#VerifyThrowInvalidOperation(System.Boolean,System.String,System.Object)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ErrorUtilities.#VerifyThrowInvalidOperation(System.Boolean,System.String,System.Object,System.Object)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.EscapingUtilities.#ContainsEscapedWildcards(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ExceptionHandling.#IsIoRelatedException(System.Exception)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ExceptionHandling.#NotExpectedFunctionException(System.Exception)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ExceptionHandling.#NotExpectedIoOrXmlException(System.Exception)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ExceptionHandling.#NotExpectedReflectionException(System.Exception)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ExceptionHandling.#NotExpectedRegistryException(System.Exception)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ExceptionHandling.#NotExpectedSerializationException(System.Exception)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ExceptionHandling.#GetXmlLineAndColumn(System.Exception)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ExceptionHandling.#IsXmlException(System.Exception)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ExceptionHandling+LineAndColumn.#get_Column()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ExceptionHandling+LineAndColumn.#set_Column(System.Int32)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ExceptionHandling+LineAndColumn.#get_Line()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.ExceptionHandling+LineAndColumn.#set_Line(System.Int32)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.#ClearCacheDirectory()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.#CreateUriFromPath(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.#get_CurrentExecutableConfigurationFilePath()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.#get_CurrentExecutableDirectory()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.#get_CurrentExecutablePath()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.#DeleteDirectoryNoThrow(System.String,System.Boolean)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.#DeleteNoThrow(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.#DirectoryExistsNoThrow(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.#EnsureNoLeadingSlash(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.#EnsureNoTrailingSlash(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.#EnsureTrailingSlash(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.#FileExistsNoThrow(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.#FileOrDirectoryExistsNoThrow(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.#GetCacheDirectory()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.#GetDirectoryNameOfFullPath(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.#HasExtension(System.String,System.String[])", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.#IsMetaprojectFilename(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.#IsSolutionFilename(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.#IsVCProjFilename(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.#MakeRelative(System.String,System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.#TrimAndStripAnyQuotes(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.#get_ExecutingAssemblyPath()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.#GetHexHash(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities.#GetPathsHash(System.Collections.Generic.IEnumerable`1<System.String>)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.FileUtilities+ItemSpecModifiers.#GetItemSpecModifier(System.String,System.String,System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.LoadedType.#.ctor(System.Type,Microsoft.Build.Shared.AssemblyLoadInfo)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.LogMessagePacketBase.#.ctor(Microsoft.Build.BackEnd.INodePacketTranslator)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.LogMessagePacketBase.#get_EventType()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.LogMessagePacketBase.#get_NodeBuildEvent()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#CoWaitForMultipleHandles(Microsoft.Build.Shared.NativeMethodsShared+COWAIT_FLAGS,System.Int32,System.Int32,System.IntPtr[],System.Int32&)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#CreatePipe(Microsoft.Win32.SafeHandles.SafeFileHandle&,Microsoft.Win32.SafeHandles.SafeFileHandle&,Microsoft.Build.Shared.NativeMethodsShared+SecurityAttributes,System.Int32)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#FindOnPath(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#FreeLibrary(System.IntPtr)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#GetChildProcessIds(System.Int32,System.DateTime)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#GetCurrentDirectory()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#GetCurrentDirectory(System.Int32,System.Text.StringBuilder)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#GetFileAttributesEx(System.String,System.Int32,Microsoft.Build.Shared.NativeMethodsShared+WIN32_FILE_ATTRIBUTE_DATA&)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#GetFileType(System.IntPtr)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#GetLastWriteDirectoryUtcTime(System.String,System.DateTime&)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#GetLastWriteFileUtcTime(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#GetLongFilePath(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#GetLongPathName(System.String,System.Text.StringBuilder,System.Int32)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#GetMemoryStatus()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#GetModuleFileName(System.Runtime.InteropServices.HandleRef,System.Text.StringBuilder,System.Int32)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#GetNativeSystemInfo(Microsoft.Build.Shared.NativeMethodsShared+SYSTEM_INFO&)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#GetOEMCP()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#GetParentProcessId(System.Int32)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#GetProcAddress(System.IntPtr,System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#GetRequestedRuntimeInfo(System.String,System.String,System.String,System.UInt32,System.UInt32,System.Text.StringBuilder,System.Int32,System.UInt32&,System.Text.StringBuilder,System.Int32,System.UInt32&)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#GetShortFilePath(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#GetShortPathName(System.String,System.Text.StringBuilder,System.Int32)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#GetStdHandle(System.Int32)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#GetSystemInfo(Microsoft.Build.Shared.NativeMethodsShared+SYSTEM_INFO&)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#GlobalMemoryStatusEx(Microsoft.Build.Shared.NativeMethodsShared+MemoryStatus)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#HResultFailed(System.Int32)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#HResultSucceeded(System.Int32)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#KillTree(System.Int32)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#LoadLibrary(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#MsgWaitOne(System.Threading.WaitHandle)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#MsgWaitOne(System.Threading.WaitHandle,System.Int32)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#MsgWaitOne(System.Threading.WaitHandle,System.TimeSpan)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#NtQueryInformationProcess(Microsoft.Build.Shared.NativeMethodsShared+SafeProcessHandle,Microsoft.Build.Shared.NativeMethodsShared+PROCESSINFOCLASS,Microsoft.Build.Shared.NativeMethodsShared+PROCESS_BASIC_INFORMATION&,System.Int32,System.Int32&)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#OpenProcess(Microsoft.Build.Shared.NativeMethodsShared+eDesiredAccess,System.Boolean,System.Int32)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#ReadFile(Microsoft.Win32.SafeHandles.SafeFileHandle,System.Byte[],System.UInt32,System.UInt32&,System.IntPtr)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#SearchPath(System.String,System.String,System.String,System.Int32,System.Text.StringBuilder,System.Int32[])", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#SetErrorMode(System.Int32)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#SetErrorMode_VistaAndOlder(System.Int32)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#SetErrorMode_Win7AndNewer(System.Int32,System.Int32&)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared.#WaitForMultipleObjects(System.UInt32,System.IntPtr[],System.Boolean,System.UInt32)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.NativeMethodsShared+PROCESS_BASIC_INFORMATION.#get_Size()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.TypeLoader.#ReflectionOnlyLoad(System.String,Microsoft.Build.Shared.AssemblyLoadInfo)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.XMakeAttributes.#ArchitectureValuesMatch(System.String,System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.XMakeAttributes.#GetExplicitMSBuildArchitecture(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.XMakeAttributes.#GetExplicitMSBuildRuntime(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.XMakeAttributes.#IsBadlyCasedSpecialTaskAttribute(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.XMakeAttributes.#IsNonBatchingTargetAttribute(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.XMakeAttributes.#IsSpecialTaskAttribute(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.XMakeAttributes.#IsValidMSBuildArchitectureValue(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.XMakeAttributes.#IsValidMSBuildRuntimeValue(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.XMakeAttributes.#RuntimeValuesMatch(System.String,System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.XMakeAttributes.#TryMergeArchitectureValues(System.String,System.String,System.String&)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.XMakeAttributes.#TryMergeRuntimeValues(System.String,System.String,System.String&)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.CharArrayInternTarget.#ResetCount(System.Int32)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.OpportunisticIntern.#EnableStatisticsGathering()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.OpportunisticIntern.#InternStringIfPossible(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.OpportunisticIntern.#ReportStatistics()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.OpportunisticIntern+BucketedPrioritizedStringList.#ReportStatistics(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.OpportunisticIntern+PrioritizedStringList.#Statistics()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.OpportunisticIntern.#CharArrayToString(System.Char[],System.Int32,System.Int32)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.OpportunisticIntern+BucketedPrioritizedStringList+PrioritizedStringList.#Statistics()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.OpportunisticIntern+StringInternTarget.#.ctor(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.StringInternTarget.#.ctor(System.String)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.BackEnd.NodeBuildComplete.#.ctor(System.Boolean)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.BackEnd.NodeEndpointOutOfProcBase.#get_LogDebugCommunications()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.BackEnd.NodeShutdown.#get_Exception()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.BackEnd.NodeShutdown.#FactoryForDeserialization(Microsoft.Build.BackEnd.INodePacketTranslator)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.BackEnd.NodeShutdown.#get_Reason()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.BackEnd.TaskHostTaskComplete.#.ctor(Microsoft.Build.BackEnd.TaskCompleteType,System.Collections.Generic.IDictionary`2<System.String,System.Object>,System.Collections.Generic.IDictionary`2<System.String,System.String>)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.BackEnd.TaskHostTaskComplete.#get_BuildProcessEnvironment()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.BackEnd.TaskHostTaskComplete.#FactoryForDeserialization(Microsoft.Build.BackEnd.INodePacketTranslator)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.BackEnd.TaskHostTaskComplete.#get_TaskException()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.BackEnd.TaskHostTaskComplete.#get_TaskExceptionMessage()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.BackEnd.TaskHostTaskComplete.#get_TaskExceptionMessageArgs()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.BackEnd.TaskHostTaskComplete.#get_TaskOutputParameters()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.BackEnd.TaskHostTaskComplete.#get_TaskResult()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.BackEnd.TaskParameter.#get_ParameterType()", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.CommandLine.LogMessagePacket.#.ctor(Microsoft.Build.BackEnd.INodePacketTranslator)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.CommandLine.LogMessagePacket.#FactoryForDeserialization(Microsoft.Build.BackEnd.INodePacketTranslator)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.CommandLine.OutOfProcTaskAppDomainWrapperBase.#set_CancelPending(System.Boolean)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Internal.CommunicationsUtilities.#GetTaskHostContext(System.Collections.Generic.IDictionary`2<System.String,System.String>)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Internal.CommunicationsUtilities.#ReadLongForHandshake(System.IO.Pipes.PipeStream)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.Shared.AssemblyLoadInfo.#FactoryForTranslation(Microsoft.Build.BackEnd.INodePacketTranslator)", Justification="This is shared code between MSBuild and MSBuildTaskHost")]

[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="Microsoft.Build.CommandLine.OutOfProcTaskAppDomainWrapperBase.#get_WrappedTask()", Justification="This is Ok. It is called by MSBuild.exe OOP node during Cancellation. MSBuildTaskHost doesn't use this.")]

[module: SuppressMessage("Microsoft.Reliability","CA2001:AvoidCallingProblematicMethods", MessageId="System.Reflection.Assembly.LoadFrom", Scope="member", Target="Microsoft.Build.BackEnd.Logging.TaskEngineAssemblyResolver.#ResolveAssembly(System.Object,System.ResolveEventArgs)", Justification="This has been reviewed as ok")]
[module: SuppressMessage("Microsoft.Reliability","CA2001:AvoidCallingProblematicMethods", MessageId="System.Reflection.Assembly.LoadFrom", Scope="member", Target="Microsoft.Build.Shared.TypeLoader+AssemblyInfoToLoadedTypes.#ScanAssemblyForPublicTypes()", Justification="This has been reviewed as ok")]
#endif
