<?php

class AdvancedController extends Website_Controller_Action
{
    public function init() {
        parent::init();

        // do something on initialization //-> see Zend Framework

        // in our case we enable the layout engine (Zend_Layout) for all actions
        $this->enableLayout();
    }

    public function preDispatch() {
        parent::preDispatch();

        // do something before the action is called //-> see Zend Framework
    }

    public function postDispatch() {
        parent::postDispatch();

        // do something after the action is called //-> see Zend Framework
    }

    public function indexAction() {

        $list = new Document_List();
        $list->setCondition("parentId = ? AND type IN ('link','page')", [$this->document->getId()]);
        $list->load();

        $this->view->documents = $list;
    }

    public function contactFormAction() {
        $success = false;

        if($this->getParam("provider")) {
            $adapter = Pimcore_Tool_HybridAuth::authenticate($this->getParam("provider"));
            if($adapter) {
                $user_data = $adapter->getUserProfile();
                if($user_data) {
                    $this->setParam("firstname", $user_data->firstName);
                    $this->setParam("lastname", $user_data->lastName);
                    $this->setParam("email", $user_data->email);
                    $this->setParam("gender", $user_data->gender);
                }
            }
        }

        // getting parameters is very easy ... just call $this->getParam("yorParamKey"); regardless if's POST or GET
        if($this->getParam("firstname") && $this->getParam("lastname") && $this->getParam("email") && $this->getParam("message")) {
            $success = true;

            $mail = new Pimcore_Mail();
            $mail->setIgnoreDebugMode(true);

            // To is used from the email document, but can also be set manually here (same for subject, CC, BCC, ...)
            //$mail->addTo("bernhard.rusch@pimcore.org");

            $emailDocument = $this->document->getProperty("email");
            if(!$emailDocument) {
                $emailDocument = Document::getById(38);
            }

            $mail->setDocument($emailDocument);
            $mail->setParams($this->getAllParams());
            $mail->send();
        }

        // do some validation & assign the parameters to the view
        foreach (["firstname", "lastname", "email", "message", "gender"] as $key) {
            if($this->getParam($key)) {
                $this->view->$key = htmlentities(strip_tags($this->getParam($key)));
            }
        }

        // assign the status to the view
        $this->view->success = $success;
    }

    public function searchAction () {
        if ($this->getParam("q")) {
            try {
                $page = $this->getParam('page');
                if (empty($page)) {
                    $page = 1;
                }
                $perPage = 10;

                $result = Pimcore_Google_Cse::search($this->getParam("q"), (($page - 1) * $perPage), null, [
                    "cx" => "002859715628130885299:baocppu9mii"
                ], $this->getParam("facet"));

                $paginator = Zend_Paginator::factory($result);
                $paginator->setCurrentPageNumber($page);
                $paginator->setItemCountPerPage($perPage);
                $this->view->paginator = $paginator;
                $this->view->result = $result;
            } catch (Exception $e) {
                // something went wrong: eg. limit exceeded, wrong configuration, ...
                Logger::err($e);
                echo $e->getMessage();exit;
            }
        }
    }

    public function objectFormAction() {

        $success = false;

        // getting parameters is very easy ... just call $this->getParam("yorParamKey"); regardless if's POST or GET
        if($this->getParam("firstname") && $this->getParam("lastname") && $this->getParam("email") && $this->getParam("terms")) {
            $success = true;

            // for this example the class "person" and "inquiry" is used
            // first we create a person, then we create an inquiry object and link them together

            // check for an existing person with this name
            $person = Object_Person::getByEmail($this->getParam("email"),1);

            if(!$person) {
                // if there isn't an existing, ... create one
                $filename = Pimcore_File::getValidFilename($this->getParam("email"));

                // first we need to create a new object, and fill some system-related information
                $person = new Object_Person();
                $person->setParent(Object_Abstract::getByPath("/crm/inquiries")); // we store all objects in /crm
                $person->setKey($filename); // the filename of the object
                $person->setPublished(true); // yep, it should be published :)

                // of course this needs some validation here in production...
                $person->setGender($this->getParam("gender"));
                $person->setFirstname($this->getParam("firstname"));
                $person->setLastname($this->getParam("lastname"));
                $person->setEmail($this->getParam("email"));
                $person->setDateRegister(Zend_Date::now());
                $person->save();
            }

            // now we create the inquiry object and link the person in it
            $inquiryFilename = Pimcore_File::getValidFilename(Zend_Date::now()->get(Zend_Date::DATETIME_MEDIUM) . "~" . $person->getEmail());
            $inquiry = new Object_Inquiry();
            $inquiry->setParent(Object_Abstract::getByPath("/inquiries")); // we store all objects in /inquiries
            $inquiry->setKey($inquiryFilename); // the filename of the object
            $inquiry->setPublished(true); // yep, it should be published :)

            // now we fill in the data
            $inquiry->setMessage($this->getParam("message"));
            $inquiry->setPerson($person);
            $inquiry->setDate(Zend_Date::now());
            $inquiry->setTerms((bool) $this->getParam("terms"));
            $inquiry->save();
        } else if ($this->getRequest()->isPost()) {
            $this->view->error = true;
        }

        // do some validation & assign the parameters to the view
        foreach (["firstname", "lastname", "email", "message", "terms"] as $key) {
            if($this->getParam($key)) {
                $this->view->$key = htmlentities(strip_tags($this->getParam($key)));
            }
        }

        // assign the status to the view
        $this->view->success = $success;
    }

    public function sitemapAction () {

        set_time_limit(900);

        $this->view->initial = false;

        if($this->getParam("doc")) {
            $doc = $this->getParam("doc");
        } else {
            $doc = $this->document->getProperty("mainNavStartNode");
            $this->view->initial = true;
        }

        Pimcore::collectGarbage();

        $this->view->doc = $doc;
    }

    public function assetThumbnailListAction() {

        // try to get the tag where the parent folder is specified
        $parentFolder = $this->document->getElement("parentFolder");
        if($parentFolder) {
            $parentFolder = $parentFolder->getElement();
        }

        if(!$parentFolder) {
            // default is the home folder
            $parentFolder = Asset::getById(1);
        }

        // get all children of the parent
        $list = new Asset_List();
        $list->setCondition("path like ?", $parentFolder->getFullpath() . "%");

        $this->view->list = $list;
    }
}
