<?php
/**
 * Display person details
 *
 * This file is part of Zoph.
 *
 * Zoph is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Zoph is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with Zoph; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @package Zoph
 * @author Jason Geiger
 * @author Jeroen Roos
 */

use template\block;
use template\template;

require_once "include.inc.php";

if (!$user->canEditOrganizers()) {
    $_action = "display";
}

if (!$user->canBrowsePeople()) {
    redirect("zoph.php");
}

$name = getvar("person");
$pagenum = getvar("_pageset_page");

if ($name) {
    $people = person::getByName($name);
    if ($people && count($people) == 1) {
        $person = array_shift($people);
    } else {
        $person = new person();
    }
} else {
    $person_id = getvar("person_id");
    $person = new person($person_id);
}

if ($_action=="display" && !$person->isVisible()) {
    redirect("people.php");
}
$obj = &$person;
$redirect = "people.php";
require_once "actions.inc.php";
if ($action != "insert") {
    $person->lookup();
    $title = e($person->getName());
} else {
    $title = translate("New Person");
}

require_once "header.inc.php";
if ($action == "display") {
    $photos_of = $person->getPhotoCount();
    $photos_by = $person->getPhotographer()->getPhotoCount();

    $selection=null;
    $actionlinks=null;

    if ($user->canEditOrganizers()) {
        $actionlinks=array(
            translate("edit")   => "person.php?_action=edit&amp;person_id=" . $person->getId(),
            translate("delete") => "person.php?_action=delete&amp;person_id=" . $person->getId(),
            translate("new")    => "person.php?_action=new"
        );
        if ($person->get("coverphoto")) {
            $actionlinks[translate("unset coverphoto")]="person.php?_action=update&amp;person_id=" .
                $person->getId() . "&amp;coverphoto=NULL";
        }

        try {
            $selection=new selection($_SESSION, array(
                "coverphoto"    => "person.php?_action=update&amp;person_id=" . $person->getId() . "&amp;coverphoto=",
                "return"        => "_return=person.php&amp;_qs=person_id=" . $person->getId()
            ));
        } catch (PhotoNoSelectionException $e) {
            $selection=null;
        }
    }

    try {
        $pageset=$person->getPageset();
        $page=$person->getPage($request_vars, $pagenum);
        $showOrig=$person->showOrig($pagenum);
    } catch (pageException $e) {
        $showOrig=true;
        $page=null;
    }

    $mainActionlinks=array(
        translate("photos of")  => "photos.php?person_id=" . $person->getId(),
        translate("photos by")  => "photos.php?photographer_id=" . $person->getId()
    );

    $tpl=new template("display", array(
        "title"             => $title,
        "obj"               => $person,
        "actionlinks"       => $actionlinks,
        "mainActionlinks"   => $mainActionlinks,
        "selection"         => $selection,
        "page"              => $page,
        "pageTop"           => $person->showPageOnTop(),
        "pageBottom"        => $person->showPageOnBottom(),
        "showMain"          => $showOrig
    ));

    /**
     * @todo All the link blocks here could be generated by the objects themselves
     *       saving a huge amount of more-or-less duplicate code
     */
    if ($user->canSeePeopleDetails()) {
        $dl=$person->getDisplayArray();
        if ($person->getEmail()) {
            $mail=new block("link", array(
                "href"      => "mailto:" . e($person->getEmail()),
                "target"    =>  "",
                "link"      => e($person->getEmail())
            ));
            $dl[translate("email")]=$mail;
        }

        if ($person->home) {
            $home=new block("link", array(
                "href"      => "place.php?place_id=" . $person->get("home_id"),
                "target"    => "",
                "link"      => $person->home->get("title")
            ));
            $dl[translate("home location")]=$home;
        }

        if ($person->work) {
            $home=new block("link", array(
                "href"      => "place.php?place_id=" . $person->get("work_id"),
                "target"    => "",
                "link"      => $person->work->get("title")
            ));
            $dl[translate("work location")]=$home;
        }

        if ($person->get("notes")) {
            $dl[translate("notes")]=$person->get("notes");
        }

        $circles=$person->getCircles();
        if ($circles) {
            $circleLinks=array();
            foreach ($circles as $circle) {
                $circle->lookup();
                $circleLinks[]= new block("link", array(
                                    "href"      => $circle->getURL(),
                                    "target"    => "",
                                    "link"      => $circle->getName()
                                ));
            }
            $dl[translate("circles")]=implode($circleLinks, ", ");
        }
        $tpl->addBlock(new block("definitionlist", array(
            "dl"    => $dl,
            "class" => ""
        )));
    }
    echo $tpl;
} else if ($action == "confirm") {
    ?>
    <h1>
      <?php echo translate("delete person") ?>
    </h1>
    <div class="main">
      <ul class="actionlink">
        <li><a href="person.php?_action=confirm&amp;person_id=<?php echo $person->get("person_id") ?>">
          <?php echo translate("delete") ?></a></li>
        <li><a href="person.php?_action=display&amp;person_id=<?php echo $person->get("person_id") ?>">
          <?php echo translate("cancel") ?></a></li>
      </ul>
      <?php echo sprintf(translate("Confirm deletion of '%s'"), $person->getName()) ?>:
      <br>
    </div>
    <?php
} else {
    require_once "edit_person.inc.php";
}
?>

<?php require_once "footer.inc.php"; ?>
