/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// CephClusterLister helps list CephClusters.
type CephClusterLister interface {
	// List lists all CephClusters in the indexer.
	List(selector labels.Selector) (ret []*v1.CephCluster, err error)
	// CephClusters returns an object that can list and get CephClusters.
	CephClusters(namespace string) CephClusterNamespaceLister
	CephClusterListerExpansion
}

// cephClusterLister implements the CephClusterLister interface.
type cephClusterLister struct {
	indexer cache.Indexer
}

// NewCephClusterLister returns a new CephClusterLister.
func NewCephClusterLister(indexer cache.Indexer) CephClusterLister {
	return &cephClusterLister{indexer: indexer}
}

// List lists all CephClusters in the indexer.
func (s *cephClusterLister) List(selector labels.Selector) (ret []*v1.CephCluster, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.CephCluster))
	})
	return ret, err
}

// CephClusters returns an object that can list and get CephClusters.
func (s *cephClusterLister) CephClusters(namespace string) CephClusterNamespaceLister {
	return cephClusterNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// CephClusterNamespaceLister helps list and get CephClusters.
type CephClusterNamespaceLister interface {
	// List lists all CephClusters in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.CephCluster, err error)
	// Get retrieves the CephCluster from the indexer for a given namespace and name.
	Get(name string) (*v1.CephCluster, error)
	CephClusterNamespaceListerExpansion
}

// cephClusterNamespaceLister implements the CephClusterNamespaceLister
// interface.
type cephClusterNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all CephClusters in the indexer for a given namespace.
func (s cephClusterNamespaceLister) List(selector labels.Selector) (ret []*v1.CephCluster, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.CephCluster))
	})
	return ret, err
}

// Get retrieves the CephCluster from the indexer for a given namespace and name.
func (s cephClusterNamespaceLister) Get(name string) (*v1.CephCluster, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("cephcluster"), name)
	}
	return obj.(*v1.CephCluster), nil
}
