// Copyright (c) The Cortex Authors.
// Licensed under the Apache License 2.0.

package validation

import (
	"testing"

	"github.com/prometheus/client_golang/prometheus/testutil"
	"github.com/stretchr/testify/assert"
)

func TestOverridesExporter_noConfig(t *testing.T) {
	exporter := NewOverridesExporter(newMockTenantLimits(nil))

	// With no updated override configurations, there should be no override metrics
	count := testutil.CollectAndCount(exporter, "cortex_overrides")
	assert.Equal(t, 0, count)
}

func TestOverridesExporter_withConfig(t *testing.T) {
	tenantLimits := map[string]*Limits{
		"tenant-a": {
			MaxQueriersPerTenant: 5,
		},
	}

	exporter := NewOverridesExporter(newMockTenantLimits(tenantLimits))

	// There should be at least a few metrics generated by receiving an override configuration map
	count := testutil.CollectAndCount(exporter, "cortex_overrides")
	assert.Greater(t, count, 0)
}
