// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/query/querypb/query.proto

package querypb

import (
	context "context"
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	storepb "github.com/thanos-io/thanos/pkg/store/storepb"
	prompb "github.com/thanos-io/thanos/pkg/store/storepb/prompb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type QueryRequest struct {
	Query                 string             `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	TimeSeconds           int64              `protobuf:"varint,2,opt,name=time_seconds,json=timeSeconds,proto3" json:"time_seconds,omitempty"`
	TimeoutSeconds        int64              `protobuf:"varint,3,opt,name=timeout_seconds,json=timeoutSeconds,proto3" json:"timeout_seconds,omitempty"`
	MaxResolutionSeconds  int64              `protobuf:"varint,4,opt,name=max_resolution_seconds,json=maxResolutionSeconds,proto3" json:"max_resolution_seconds,omitempty"`
	ReplicaLabels         []string           `protobuf:"bytes,5,rep,name=replica_labels,json=replicaLabels,proto3" json:"replica_labels,omitempty"`
	StoreMatchers         []StoreMatchers    `protobuf:"bytes,6,rep,name=storeMatchers,proto3" json:"storeMatchers"`
	EnableDedup           bool               `protobuf:"varint,7,opt,name=enableDedup,proto3" json:"enableDedup,omitempty"`
	EnablePartialResponse bool               `protobuf:"varint,8,opt,name=enablePartialResponse,proto3" json:"enablePartialResponse,omitempty"`
	EnableQueryPushdown   bool               `protobuf:"varint,9,opt,name=enableQueryPushdown,proto3" json:"enableQueryPushdown,omitempty"`
	SkipChunks            bool               `protobuf:"varint,10,opt,name=skipChunks,proto3" json:"skipChunks,omitempty"`
	ShardInfo             *storepb.ShardInfo `protobuf:"bytes,11,opt,name=shard_info,json=shardInfo,proto3" json:"shard_info,omitempty"`
	LookbackDeltaSeconds  int64              `protobuf:"varint,12,opt,name=lookback_delta_seconds,json=lookbackDeltaSeconds,proto3" json:"lookback_delta_seconds,omitempty"`
}

func (m *QueryRequest) Reset()         { *m = QueryRequest{} }
func (m *QueryRequest) String() string { return proto.CompactTextString(m) }
func (*QueryRequest) ProtoMessage()    {}
func (*QueryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4b2aba43925d729f, []int{0}
}
func (m *QueryRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryRequest.Merge(m, src)
}
func (m *QueryRequest) XXX_Size() int {
	return m.Size()
}
func (m *QueryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_QueryRequest proto.InternalMessageInfo

type StoreMatchers struct {
	LabelMatchers []storepb.LabelMatcher `protobuf:"bytes,1,rep,name=labelMatchers,proto3" json:"labelMatchers"`
}

func (m *StoreMatchers) Reset()         { *m = StoreMatchers{} }
func (m *StoreMatchers) String() string { return proto.CompactTextString(m) }
func (*StoreMatchers) ProtoMessage()    {}
func (*StoreMatchers) Descriptor() ([]byte, []int) {
	return fileDescriptor_4b2aba43925d729f, []int{1}
}
func (m *StoreMatchers) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StoreMatchers) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StoreMatchers.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StoreMatchers) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StoreMatchers.Merge(m, src)
}
func (m *StoreMatchers) XXX_Size() int {
	return m.Size()
}
func (m *StoreMatchers) XXX_DiscardUnknown() {
	xxx_messageInfo_StoreMatchers.DiscardUnknown(m)
}

var xxx_messageInfo_StoreMatchers proto.InternalMessageInfo

type QueryResponse struct {
	// Types that are valid to be assigned to Result:
	//	*QueryResponse_Warnings
	//	*QueryResponse_Timeseries
	Result isQueryResponse_Result `protobuf_oneof:"result"`
}

func (m *QueryResponse) Reset()         { *m = QueryResponse{} }
func (m *QueryResponse) String() string { return proto.CompactTextString(m) }
func (*QueryResponse) ProtoMessage()    {}
func (*QueryResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4b2aba43925d729f, []int{2}
}
func (m *QueryResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryResponse.Merge(m, src)
}
func (m *QueryResponse) XXX_Size() int {
	return m.Size()
}
func (m *QueryResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryResponse.DiscardUnknown(m)
}

var xxx_messageInfo_QueryResponse proto.InternalMessageInfo

type isQueryResponse_Result interface {
	isQueryResponse_Result()
	MarshalTo([]byte) (int, error)
	Size() int
}

type QueryResponse_Warnings struct {
	Warnings string `protobuf:"bytes,1,opt,name=warnings,proto3,oneof" json:"warnings,omitempty"`
}
type QueryResponse_Timeseries struct {
	Timeseries *prompb.TimeSeries `protobuf:"bytes,2,opt,name=timeseries,proto3,oneof" json:"timeseries,omitempty"`
}

func (*QueryResponse_Warnings) isQueryResponse_Result()   {}
func (*QueryResponse_Timeseries) isQueryResponse_Result() {}

func (m *QueryResponse) GetResult() isQueryResponse_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *QueryResponse) GetWarnings() string {
	if x, ok := m.GetResult().(*QueryResponse_Warnings); ok {
		return x.Warnings
	}
	return ""
}

func (m *QueryResponse) GetTimeseries() *prompb.TimeSeries {
	if x, ok := m.GetResult().(*QueryResponse_Timeseries); ok {
		return x.Timeseries
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*QueryResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*QueryResponse_Warnings)(nil),
		(*QueryResponse_Timeseries)(nil),
	}
}

type QueryRangeRequest struct {
	Query                 string             `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	StartTimeSeconds      int64              `protobuf:"varint,2,opt,name=start_time_seconds,json=startTimeSeconds,proto3" json:"start_time_seconds,omitempty"`
	EndTimeSeconds        int64              `protobuf:"varint,3,opt,name=end_time_seconds,json=endTimeSeconds,proto3" json:"end_time_seconds,omitempty"`
	IntervalSeconds       int64              `protobuf:"varint,4,opt,name=interval_seconds,json=intervalSeconds,proto3" json:"interval_seconds,omitempty"`
	TimeoutSeconds        int64              `protobuf:"varint,5,opt,name=timeout_seconds,json=timeoutSeconds,proto3" json:"timeout_seconds,omitempty"`
	MaxResolutionSeconds  int64              `protobuf:"varint,6,opt,name=max_resolution_seconds,json=maxResolutionSeconds,proto3" json:"max_resolution_seconds,omitempty"`
	ReplicaLabels         []string           `protobuf:"bytes,7,rep,name=replica_labels,json=replicaLabels,proto3" json:"replica_labels,omitempty"`
	StoreMatchers         []StoreMatchers    `protobuf:"bytes,8,rep,name=storeMatchers,proto3" json:"storeMatchers"`
	EnableDedup           bool               `protobuf:"varint,9,opt,name=enableDedup,proto3" json:"enableDedup,omitempty"`
	EnablePartialResponse bool               `protobuf:"varint,10,opt,name=enablePartialResponse,proto3" json:"enablePartialResponse,omitempty"`
	EnableQueryPushdown   bool               `protobuf:"varint,11,opt,name=enableQueryPushdown,proto3" json:"enableQueryPushdown,omitempty"`
	SkipChunks            bool               `protobuf:"varint,12,opt,name=skipChunks,proto3" json:"skipChunks,omitempty"`
	ShardInfo             *storepb.ShardInfo `protobuf:"bytes,13,opt,name=shard_info,json=shardInfo,proto3" json:"shard_info,omitempty"`
	LookbackDeltaSeconds  int64              `protobuf:"varint,14,opt,name=lookback_delta_seconds,json=lookbackDeltaSeconds,proto3" json:"lookback_delta_seconds,omitempty"`
}

func (m *QueryRangeRequest) Reset()         { *m = QueryRangeRequest{} }
func (m *QueryRangeRequest) String() string { return proto.CompactTextString(m) }
func (*QueryRangeRequest) ProtoMessage()    {}
func (*QueryRangeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4b2aba43925d729f, []int{3}
}
func (m *QueryRangeRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryRangeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryRangeRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryRangeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryRangeRequest.Merge(m, src)
}
func (m *QueryRangeRequest) XXX_Size() int {
	return m.Size()
}
func (m *QueryRangeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryRangeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_QueryRangeRequest proto.InternalMessageInfo

type QueryRangeResponse struct {
	// Types that are valid to be assigned to Result:
	//	*QueryRangeResponse_Warnings
	//	*QueryRangeResponse_Timeseries
	Result isQueryRangeResponse_Result `protobuf_oneof:"result"`
}

func (m *QueryRangeResponse) Reset()         { *m = QueryRangeResponse{} }
func (m *QueryRangeResponse) String() string { return proto.CompactTextString(m) }
func (*QueryRangeResponse) ProtoMessage()    {}
func (*QueryRangeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4b2aba43925d729f, []int{4}
}
func (m *QueryRangeResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryRangeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryRangeResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryRangeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryRangeResponse.Merge(m, src)
}
func (m *QueryRangeResponse) XXX_Size() int {
	return m.Size()
}
func (m *QueryRangeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryRangeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_QueryRangeResponse proto.InternalMessageInfo

type isQueryRangeResponse_Result interface {
	isQueryRangeResponse_Result()
	MarshalTo([]byte) (int, error)
	Size() int
}

type QueryRangeResponse_Warnings struct {
	Warnings string `protobuf:"bytes,1,opt,name=warnings,proto3,oneof" json:"warnings,omitempty"`
}
type QueryRangeResponse_Timeseries struct {
	Timeseries *prompb.TimeSeries `protobuf:"bytes,2,opt,name=timeseries,proto3,oneof" json:"timeseries,omitempty"`
}

func (*QueryRangeResponse_Warnings) isQueryRangeResponse_Result()   {}
func (*QueryRangeResponse_Timeseries) isQueryRangeResponse_Result() {}

func (m *QueryRangeResponse) GetResult() isQueryRangeResponse_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *QueryRangeResponse) GetWarnings() string {
	if x, ok := m.GetResult().(*QueryRangeResponse_Warnings); ok {
		return x.Warnings
	}
	return ""
}

func (m *QueryRangeResponse) GetTimeseries() *prompb.TimeSeries {
	if x, ok := m.GetResult().(*QueryRangeResponse_Timeseries); ok {
		return x.Timeseries
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*QueryRangeResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*QueryRangeResponse_Warnings)(nil),
		(*QueryRangeResponse_Timeseries)(nil),
	}
}

func init() {
	proto.RegisterType((*QueryRequest)(nil), "thanos.QueryRequest")
	proto.RegisterType((*StoreMatchers)(nil), "thanos.StoreMatchers")
	proto.RegisterType((*QueryResponse)(nil), "thanos.QueryResponse")
	proto.RegisterType((*QueryRangeRequest)(nil), "thanos.QueryRangeRequest")
	proto.RegisterType((*QueryRangeResponse)(nil), "thanos.QueryRangeResponse")
}

func init() { proto.RegisterFile("api/query/querypb/query.proto", fileDescriptor_4b2aba43925d729f) }

var fileDescriptor_4b2aba43925d729f = []byte{
	// 692 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x55, 0xcd, 0x6e, 0xd3, 0x40,
	0x18, 0x8c, 0x49, 0x93, 0x26, 0x5f, 0x92, 0xfe, 0x2c, 0x29, 0xb8, 0x01, 0x8c, 0x89, 0x54, 0x11,
	0x24, 0x94, 0x54, 0xa1, 0xe2, 0x86, 0x04, 0xa5, 0x48, 0x45, 0x2a, 0x52, 0xeb, 0xf6, 0xc4, 0x25,
	0xda, 0xc4, 0xdb, 0xc4, 0x8a, 0xb3, 0xeb, 0xee, 0xae, 0xfb, 0x23, 0xee, 0x70, 0xe5, 0x19, 0x78,
	0x9a, 0x1e, 0x7b, 0xe4, 0x84, 0xa0, 0x7d, 0x11, 0xe4, 0xf5, 0x0f, 0x76, 0x15, 0x95, 0x96, 0x4a,
	0x5c, 0x5c, 0xef, 0xcc, 0x7c, 0xdd, 0xf5, 0x64, 0x46, 0x0b, 0x8f, 0xb0, 0xe7, 0x74, 0x0e, 0x7c,
	0xc2, 0x4f, 0xc2, 0xa7, 0xd7, 0x0f, 0xff, 0xb6, 0x3d, 0xce, 0x24, 0x43, 0x45, 0x39, 0xc2, 0x94,
	0x89, 0x46, 0x7d, 0xc8, 0x86, 0x4c, 0x41, 0x9d, 0xe0, 0x2d, 0x64, 0x1b, 0xcb, 0x42, 0x32, 0x4e,
	0x3a, 0xea, 0xe9, 0xf5, 0x3b, 0xf2, 0xc4, 0x23, 0x22, 0xa2, 0xee, 0x67, 0x29, 0xee, 0x0d, 0x22,
	0xc2, 0xcc, 0x12, 0x1e, 0x67, 0x93, 0xec, 0x68, 0xf3, 0xdb, 0x0c, 0x54, 0x77, 0x82, 0x33, 0x58,
	0xe4, 0xc0, 0x27, 0x42, 0xa2, 0x3a, 0x14, 0xd4, 0x99, 0x74, 0xcd, 0xd4, 0x5a, 0x65, 0x2b, 0x5c,
	0xa0, 0x27, 0x50, 0x95, 0xce, 0x84, 0xf4, 0x04, 0x19, 0x30, 0x6a, 0x0b, 0xfd, 0x8e, 0xa9, 0xb5,
	0xf2, 0x56, 0x25, 0xc0, 0x76, 0x43, 0x08, 0x3d, 0x85, 0xf9, 0x60, 0xc9, 0x7c, 0x99, 0xa8, 0xf2,
	0x4a, 0x35, 0x17, 0xc1, 0xb1, 0x70, 0x0d, 0xee, 0x4d, 0xf0, 0x71, 0x8f, 0x13, 0xc1, 0x5c, 0x5f,
	0x3a, 0x8c, 0x26, 0xfa, 0x19, 0xa5, 0xaf, 0x4f, 0xf0, 0xb1, 0x95, 0x90, 0xf1, 0xd4, 0x0a, 0xcc,
	0x71, 0xe2, 0xb9, 0xce, 0x00, 0xf7, 0x5c, 0xdc, 0x27, 0xae, 0xd0, 0x0b, 0x66, 0xbe, 0x55, 0xb6,
	0x6a, 0x11, 0xba, 0xa5, 0x40, 0xf4, 0x06, 0x6a, 0xea, 0x6b, 0x3f, 0x60, 0x39, 0x18, 0x11, 0x2e,
	0xf4, 0xa2, 0x99, 0x6f, 0x55, 0xba, 0x4b, 0xed, 0xd0, 0xdb, 0xf6, 0x6e, 0x9a, 0x5c, 0x9f, 0x39,
	0xfd, 0xf1, 0x38, 0x67, 0x65, 0x27, 0x90, 0x09, 0x15, 0x42, 0x71, 0xdf, 0x25, 0x1b, 0xc4, 0xf6,
	0x3d, 0x7d, 0xd6, 0xd4, 0x5a, 0x25, 0x2b, 0x0d, 0xa1, 0x35, 0x58, 0x0a, 0x97, 0xdb, 0x98, 0x4b,
	0x07, 0xbb, 0x16, 0x11, 0x1e, 0xa3, 0x82, 0xe8, 0x25, 0xa5, 0x9d, 0x4e, 0xa2, 0x55, 0xb8, 0x1b,
	0x12, 0xca, 0xef, 0x6d, 0x5f, 0x8c, 0x6c, 0x76, 0x44, 0xf5, 0xb2, 0x9a, 0x99, 0x46, 0x21, 0x03,
	0x40, 0x8c, 0x1d, 0xef, 0xed, 0xc8, 0xa7, 0x63, 0xa1, 0x83, 0x12, 0xa6, 0x10, 0xb4, 0x0a, 0x20,
	0x46, 0x98, 0xdb, 0x3d, 0x87, 0xee, 0x33, 0xbd, 0x62, 0x6a, 0xad, 0x4a, 0x77, 0x31, 0xf9, 0xd2,
	0x80, 0x79, 0x4f, 0xf7, 0x99, 0x55, 0x16, 0xf1, 0x6b, 0xe0, 0xbd, 0xcb, 0xd8, 0xb8, 0x8f, 0x07,
	0xe3, 0x9e, 0x4d, 0x5c, 0x89, 0x13, 0xef, 0xab, 0xa1, 0xf7, 0x31, 0xbb, 0x11, 0x90, 0x91, 0xf7,
	0xcd, 0x1d, 0xa8, 0x65, 0x7c, 0x43, 0xaf, 0xa1, 0xa6, 0x7e, 0x84, 0xc4, 0x65, 0x4d, 0xb9, 0x5c,
	0x8f, 0xf7, 0xde, 0x4a, 0x91, 0xb1, 0xc9, 0x99, 0x81, 0xe6, 0x21, 0xd4, 0xa2, 0xd8, 0x45, 0xee,
	0x3c, 0x84, 0xd2, 0x11, 0xe6, 0xd4, 0xa1, 0x43, 0x11, 0x46, 0x6f, 0x33, 0x67, 0x25, 0x08, 0x7a,
	0x05, 0x10, 0xa4, 0x48, 0x10, 0xee, 0x90, 0x30, 0x7d, 0x95, 0xee, 0x83, 0x20, 0xc2, 0x13, 0x22,
	0x47, 0xc4, 0x17, 0xbd, 0x01, 0xf3, 0x4e, 0xda, 0x7b, 0x2a, 0x8e, 0x81, 0x64, 0x33, 0x67, 0xa5,
	0x06, 0xd6, 0x4b, 0x50, 0xe4, 0x44, 0xf8, 0xae, 0x6c, 0x7e, 0x29, 0xc0, 0x62, 0xb8, 0x31, 0xa6,
	0x43, 0x72, 0x75, 0xe8, 0x9f, 0x03, 0x12, 0x12, 0x73, 0xd9, 0x9b, 0x12, 0xfd, 0x05, 0xc5, 0xec,
	0xa5, 0xf2, 0xdf, 0x82, 0x05, 0x42, 0xed, 0xac, 0x36, 0x2a, 0x00, 0xa1, 0x76, 0x5a, 0xf9, 0x0c,
	0x16, 0x1c, 0x2a, 0x09, 0x3f, 0xc4, 0xee, 0xa5, 0xe8, 0xcf, 0xc7, 0xf8, 0x15, 0xa5, 0x2a, 0xdc,
	0xb0, 0x54, 0xc5, 0x1b, 0x95, 0x6a, 0xf6, 0x5a, 0xa5, 0x2a, 0xdd, 0xb6, 0x54, 0xe5, 0x1b, 0x94,
	0x0a, 0xfe, 0xa1, 0x54, 0x95, 0xeb, 0x96, 0xaa, 0xfa, 0x97, 0x52, 0xd5, 0x6e, 0x55, 0xaa, 0xb9,
	0x2b, 0x4a, 0xf5, 0x09, 0x50, 0x3a, 0x88, 0xff, 0xb5, 0x06, 0xdd, 0xcf, 0x1a, 0x14, 0xd4, 0xee,
	0xe8, 0x65, 0xfc, 0x92, 0x94, 0x37, 0x7d, 0x1d, 0x34, 0x96, 0x2e, 0xa1, 0xe1, 0x31, 0x57, 0x35,
	0xf4, 0x0e, 0xe0, 0xcf, 0xf1, 0xd1, 0x72, 0x56, 0x96, 0xea, 0x56, 0xa3, 0x31, 0x8d, 0x8a, 0xff,
	0xcd, 0xfa, 0xca, 0xe9, 0x2f, 0x23, 0x77, 0x7a, 0x6e, 0x68, 0x67, 0xe7, 0x86, 0xf6, 0xf3, 0xdc,
	0xd0, 0xbe, 0x5e, 0x18, 0xb9, 0xb3, 0x0b, 0x23, 0xf7, 0xfd, 0xc2, 0xc8, 0x7d, 0x9c, 0x8d, 0xae,
	0xc9, 0x7e, 0x51, 0xdd, 0x56, 0x2f, 0x7e, 0x07, 0x00, 0x00, 0xff, 0xff, 0xfa, 0x8f, 0xd7, 0xf7,
	0x42, 0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// QueryClient is the client API for Query service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type QueryClient interface {
	Query(ctx context.Context, in *QueryRequest, opts ...grpc.CallOption) (Query_QueryClient, error)
	QueryRange(ctx context.Context, in *QueryRangeRequest, opts ...grpc.CallOption) (Query_QueryRangeClient, error)
}

type queryClient struct {
	cc *grpc.ClientConn
}

func NewQueryClient(cc *grpc.ClientConn) QueryClient {
	return &queryClient{cc}
}

func (c *queryClient) Query(ctx context.Context, in *QueryRequest, opts ...grpc.CallOption) (Query_QueryClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Query_serviceDesc.Streams[0], "/thanos.Query/Query", opts...)
	if err != nil {
		return nil, err
	}
	x := &queryQueryClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Query_QueryClient interface {
	Recv() (*QueryResponse, error)
	grpc.ClientStream
}

type queryQueryClient struct {
	grpc.ClientStream
}

func (x *queryQueryClient) Recv() (*QueryResponse, error) {
	m := new(QueryResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *queryClient) QueryRange(ctx context.Context, in *QueryRangeRequest, opts ...grpc.CallOption) (Query_QueryRangeClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Query_serviceDesc.Streams[1], "/thanos.Query/QueryRange", opts...)
	if err != nil {
		return nil, err
	}
	x := &queryQueryRangeClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Query_QueryRangeClient interface {
	Recv() (*QueryRangeResponse, error)
	grpc.ClientStream
}

type queryQueryRangeClient struct {
	grpc.ClientStream
}

func (x *queryQueryRangeClient) Recv() (*QueryRangeResponse, error) {
	m := new(QueryRangeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// QueryServer is the server API for Query service.
type QueryServer interface {
	Query(*QueryRequest, Query_QueryServer) error
	QueryRange(*QueryRangeRequest, Query_QueryRangeServer) error
}

// UnimplementedQueryServer can be embedded to have forward compatible implementations.
type UnimplementedQueryServer struct {
}

func (*UnimplementedQueryServer) Query(req *QueryRequest, srv Query_QueryServer) error {
	return status.Errorf(codes.Unimplemented, "method Query not implemented")
}
func (*UnimplementedQueryServer) QueryRange(req *QueryRangeRequest, srv Query_QueryRangeServer) error {
	return status.Errorf(codes.Unimplemented, "method QueryRange not implemented")
}

func RegisterQueryServer(s *grpc.Server, srv QueryServer) {
	s.RegisterService(&_Query_serviceDesc, srv)
}

func _Query_Query_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(QueryRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(QueryServer).Query(m, &queryQueryServer{stream})
}

type Query_QueryServer interface {
	Send(*QueryResponse) error
	grpc.ServerStream
}

type queryQueryServer struct {
	grpc.ServerStream
}

func (x *queryQueryServer) Send(m *QueryResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Query_QueryRange_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(QueryRangeRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(QueryServer).QueryRange(m, &queryQueryRangeServer{stream})
}

type Query_QueryRangeServer interface {
	Send(*QueryRangeResponse) error
	grpc.ServerStream
}

type queryQueryRangeServer struct {
	grpc.ServerStream
}

func (x *queryQueryRangeServer) Send(m *QueryRangeResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _Query_serviceDesc = grpc.ServiceDesc{
	ServiceName: "thanos.Query",
	HandlerType: (*QueryServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Query",
			Handler:       _Query_Query_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "QueryRange",
			Handler:       _Query_QueryRange_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "api/query/querypb/query.proto",
}

func (m *QueryRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.LookbackDeltaSeconds != 0 {
		i = encodeVarintQuery(dAtA, i, uint64(m.LookbackDeltaSeconds))
		i--
		dAtA[i] = 0x60
	}
	if m.ShardInfo != nil {
		{
			size, err := m.ShardInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintQuery(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.SkipChunks {
		i--
		if m.SkipChunks {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x50
	}
	if m.EnableQueryPushdown {
		i--
		if m.EnableQueryPushdown {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if m.EnablePartialResponse {
		i--
		if m.EnablePartialResponse {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x40
	}
	if m.EnableDedup {
		i--
		if m.EnableDedup {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if len(m.StoreMatchers) > 0 {
		for iNdEx := len(m.StoreMatchers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.StoreMatchers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintQuery(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.ReplicaLabels) > 0 {
		for iNdEx := len(m.ReplicaLabels) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ReplicaLabels[iNdEx])
			copy(dAtA[i:], m.ReplicaLabels[iNdEx])
			i = encodeVarintQuery(dAtA, i, uint64(len(m.ReplicaLabels[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.MaxResolutionSeconds != 0 {
		i = encodeVarintQuery(dAtA, i, uint64(m.MaxResolutionSeconds))
		i--
		dAtA[i] = 0x20
	}
	if m.TimeoutSeconds != 0 {
		i = encodeVarintQuery(dAtA, i, uint64(m.TimeoutSeconds))
		i--
		dAtA[i] = 0x18
	}
	if m.TimeSeconds != 0 {
		i = encodeVarintQuery(dAtA, i, uint64(m.TimeSeconds))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Query) > 0 {
		i -= len(m.Query)
		copy(dAtA[i:], m.Query)
		i = encodeVarintQuery(dAtA, i, uint64(len(m.Query)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *StoreMatchers) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoreMatchers) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StoreMatchers) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.LabelMatchers) > 0 {
		for iNdEx := len(m.LabelMatchers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.LabelMatchers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintQuery(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *QueryResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Result != nil {
		{
			size := m.Result.Size()
			i -= size
			if _, err := m.Result.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *QueryResponse_Warnings) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryResponse_Warnings) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Warnings)
	copy(dAtA[i:], m.Warnings)
	i = encodeVarintQuery(dAtA, i, uint64(len(m.Warnings)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}
func (m *QueryResponse_Timeseries) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryResponse_Timeseries) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Timeseries != nil {
		{
			size, err := m.Timeseries.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintQuery(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *QueryRangeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryRangeRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryRangeRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.LookbackDeltaSeconds != 0 {
		i = encodeVarintQuery(dAtA, i, uint64(m.LookbackDeltaSeconds))
		i--
		dAtA[i] = 0x70
	}
	if m.ShardInfo != nil {
		{
			size, err := m.ShardInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintQuery(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6a
	}
	if m.SkipChunks {
		i--
		if m.SkipChunks {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x60
	}
	if m.EnableQueryPushdown {
		i--
		if m.EnableQueryPushdown {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x58
	}
	if m.EnablePartialResponse {
		i--
		if m.EnablePartialResponse {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x50
	}
	if m.EnableDedup {
		i--
		if m.EnableDedup {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if len(m.StoreMatchers) > 0 {
		for iNdEx := len(m.StoreMatchers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.StoreMatchers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintQuery(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.ReplicaLabels) > 0 {
		for iNdEx := len(m.ReplicaLabels) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ReplicaLabels[iNdEx])
			copy(dAtA[i:], m.ReplicaLabels[iNdEx])
			i = encodeVarintQuery(dAtA, i, uint64(len(m.ReplicaLabels[iNdEx])))
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.MaxResolutionSeconds != 0 {
		i = encodeVarintQuery(dAtA, i, uint64(m.MaxResolutionSeconds))
		i--
		dAtA[i] = 0x30
	}
	if m.TimeoutSeconds != 0 {
		i = encodeVarintQuery(dAtA, i, uint64(m.TimeoutSeconds))
		i--
		dAtA[i] = 0x28
	}
	if m.IntervalSeconds != 0 {
		i = encodeVarintQuery(dAtA, i, uint64(m.IntervalSeconds))
		i--
		dAtA[i] = 0x20
	}
	if m.EndTimeSeconds != 0 {
		i = encodeVarintQuery(dAtA, i, uint64(m.EndTimeSeconds))
		i--
		dAtA[i] = 0x18
	}
	if m.StartTimeSeconds != 0 {
		i = encodeVarintQuery(dAtA, i, uint64(m.StartTimeSeconds))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Query) > 0 {
		i -= len(m.Query)
		copy(dAtA[i:], m.Query)
		i = encodeVarintQuery(dAtA, i, uint64(len(m.Query)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *QueryRangeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryRangeResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryRangeResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Result != nil {
		{
			size := m.Result.Size()
			i -= size
			if _, err := m.Result.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *QueryRangeResponse_Warnings) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryRangeResponse_Warnings) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Warnings)
	copy(dAtA[i:], m.Warnings)
	i = encodeVarintQuery(dAtA, i, uint64(len(m.Warnings)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}
func (m *QueryRangeResponse_Timeseries) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryRangeResponse_Timeseries) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Timeseries != nil {
		{
			size, err := m.Timeseries.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintQuery(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func encodeVarintQuery(dAtA []byte, offset int, v uint64) int {
	offset -= sovQuery(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *QueryRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovQuery(uint64(l))
	}
	if m.TimeSeconds != 0 {
		n += 1 + sovQuery(uint64(m.TimeSeconds))
	}
	if m.TimeoutSeconds != 0 {
		n += 1 + sovQuery(uint64(m.TimeoutSeconds))
	}
	if m.MaxResolutionSeconds != 0 {
		n += 1 + sovQuery(uint64(m.MaxResolutionSeconds))
	}
	if len(m.ReplicaLabels) > 0 {
		for _, s := range m.ReplicaLabels {
			l = len(s)
			n += 1 + l + sovQuery(uint64(l))
		}
	}
	if len(m.StoreMatchers) > 0 {
		for _, e := range m.StoreMatchers {
			l = e.Size()
			n += 1 + l + sovQuery(uint64(l))
		}
	}
	if m.EnableDedup {
		n += 2
	}
	if m.EnablePartialResponse {
		n += 2
	}
	if m.EnableQueryPushdown {
		n += 2
	}
	if m.SkipChunks {
		n += 2
	}
	if m.ShardInfo != nil {
		l = m.ShardInfo.Size()
		n += 1 + l + sovQuery(uint64(l))
	}
	if m.LookbackDeltaSeconds != 0 {
		n += 1 + sovQuery(uint64(m.LookbackDeltaSeconds))
	}
	return n
}

func (m *StoreMatchers) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.LabelMatchers) > 0 {
		for _, e := range m.LabelMatchers {
			l = e.Size()
			n += 1 + l + sovQuery(uint64(l))
		}
	}
	return n
}

func (m *QueryResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Result != nil {
		n += m.Result.Size()
	}
	return n
}

func (m *QueryResponse_Warnings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Warnings)
	n += 1 + l + sovQuery(uint64(l))
	return n
}
func (m *QueryResponse_Timeseries) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Timeseries != nil {
		l = m.Timeseries.Size()
		n += 1 + l + sovQuery(uint64(l))
	}
	return n
}
func (m *QueryRangeRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovQuery(uint64(l))
	}
	if m.StartTimeSeconds != 0 {
		n += 1 + sovQuery(uint64(m.StartTimeSeconds))
	}
	if m.EndTimeSeconds != 0 {
		n += 1 + sovQuery(uint64(m.EndTimeSeconds))
	}
	if m.IntervalSeconds != 0 {
		n += 1 + sovQuery(uint64(m.IntervalSeconds))
	}
	if m.TimeoutSeconds != 0 {
		n += 1 + sovQuery(uint64(m.TimeoutSeconds))
	}
	if m.MaxResolutionSeconds != 0 {
		n += 1 + sovQuery(uint64(m.MaxResolutionSeconds))
	}
	if len(m.ReplicaLabels) > 0 {
		for _, s := range m.ReplicaLabels {
			l = len(s)
			n += 1 + l + sovQuery(uint64(l))
		}
	}
	if len(m.StoreMatchers) > 0 {
		for _, e := range m.StoreMatchers {
			l = e.Size()
			n += 1 + l + sovQuery(uint64(l))
		}
	}
	if m.EnableDedup {
		n += 2
	}
	if m.EnablePartialResponse {
		n += 2
	}
	if m.EnableQueryPushdown {
		n += 2
	}
	if m.SkipChunks {
		n += 2
	}
	if m.ShardInfo != nil {
		l = m.ShardInfo.Size()
		n += 1 + l + sovQuery(uint64(l))
	}
	if m.LookbackDeltaSeconds != 0 {
		n += 1 + sovQuery(uint64(m.LookbackDeltaSeconds))
	}
	return n
}

func (m *QueryRangeResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Result != nil {
		n += m.Result.Size()
	}
	return n
}

func (m *QueryRangeResponse_Warnings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Warnings)
	n += 1 + l + sovQuery(uint64(l))
	return n
}
func (m *QueryRangeResponse_Timeseries) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Timeseries != nil {
		l = m.Timeseries.Size()
		n += 1 + l + sovQuery(uint64(l))
	}
	return n
}

func sovQuery(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozQuery(x uint64) (n int) {
	return sovQuery(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *QueryRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeSeconds", wireType)
			}
			m.TimeSeconds = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TimeSeconds |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeoutSeconds", wireType)
			}
			m.TimeoutSeconds = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TimeoutSeconds |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxResolutionSeconds", wireType)
			}
			m.MaxResolutionSeconds = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxResolutionSeconds |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicaLabels", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ReplicaLabels = append(m.ReplicaLabels, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreMatchers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StoreMatchers = append(m.StoreMatchers, StoreMatchers{})
			if err := m.StoreMatchers[len(m.StoreMatchers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnableDedup", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnableDedup = bool(v != 0)
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnablePartialResponse", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnablePartialResponse = bool(v != 0)
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnableQueryPushdown", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnableQueryPushdown = bool(v != 0)
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SkipChunks", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SkipChunks = bool(v != 0)
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ShardInfo == nil {
				m.ShardInfo = &storepb.ShardInfo{}
			}
			if err := m.ShardInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LookbackDeltaSeconds", wireType)
			}
			m.LookbackDeltaSeconds = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LookbackDeltaSeconds |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StoreMatchers) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreMatchers: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreMatchers: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LabelMatchers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LabelMatchers = append(m.LabelMatchers, storepb.LabelMatcher{})
			if err := m.LabelMatchers[len(m.LabelMatchers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warnings", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Result = &QueryResponse_Warnings{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeseries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &prompb.TimeSeries{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Result = &QueryResponse_Timeseries{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryRangeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryRangeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryRangeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeSeconds", wireType)
			}
			m.StartTimeSeconds = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartTimeSeconds |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTimeSeconds", wireType)
			}
			m.EndTimeSeconds = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndTimeSeconds |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntervalSeconds", wireType)
			}
			m.IntervalSeconds = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IntervalSeconds |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeoutSeconds", wireType)
			}
			m.TimeoutSeconds = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TimeoutSeconds |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxResolutionSeconds", wireType)
			}
			m.MaxResolutionSeconds = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxResolutionSeconds |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicaLabels", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ReplicaLabels = append(m.ReplicaLabels, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreMatchers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StoreMatchers = append(m.StoreMatchers, StoreMatchers{})
			if err := m.StoreMatchers[len(m.StoreMatchers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnableDedup", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnableDedup = bool(v != 0)
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnablePartialResponse", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnablePartialResponse = bool(v != 0)
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnableQueryPushdown", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnableQueryPushdown = bool(v != 0)
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SkipChunks", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SkipChunks = bool(v != 0)
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ShardInfo == nil {
				m.ShardInfo = &storepb.ShardInfo{}
			}
			if err := m.ShardInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LookbackDeltaSeconds", wireType)
			}
			m.LookbackDeltaSeconds = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LookbackDeltaSeconds |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryRangeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryRangeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryRangeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warnings", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Result = &QueryRangeResponse_Warnings{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeseries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &prompb.TimeSeries{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Result = &QueryRangeResponse_Timeseries{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipQuery(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthQuery
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupQuery
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthQuery
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthQuery        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowQuery          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupQuery = fmt.Errorf("proto: unexpected end of group")
)
