// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: exemplars/exemplarspb/rpc.proto

package exemplarspb

import (
	context "context"
	encoding_binary "encoding/binary"
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	labelpb "github.com/thanos-io/thanos/pkg/store/labelpb"
	storepb "github.com/thanos-io/thanos/pkg/store/storepb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type ExemplarsRequest struct {
	Query                   string                          `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	Start                   int64                           `protobuf:"varint,2,opt,name=start,proto3" json:"start,omitempty"`
	End                     int64                           `protobuf:"varint,3,opt,name=end,proto3" json:"end,omitempty"`
	PartialResponseStrategy storepb.PartialResponseStrategy `protobuf:"varint,4,opt,name=partial_response_strategy,json=partialResponseStrategy,proto3,enum=thanos.PartialResponseStrategy" json:"partial_response_strategy,omitempty"`
}

func (m *ExemplarsRequest) Reset()         { *m = ExemplarsRequest{} }
func (m *ExemplarsRequest) String() string { return proto.CompactTextString(m) }
func (*ExemplarsRequest) ProtoMessage()    {}
func (*ExemplarsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd9ad2a40bac3cc9, []int{0}
}
func (m *ExemplarsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExemplarsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExemplarsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExemplarsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExemplarsRequest.Merge(m, src)
}
func (m *ExemplarsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ExemplarsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExemplarsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExemplarsRequest proto.InternalMessageInfo

type ExemplarsResponse struct {
	// Types that are valid to be assigned to Result:
	//	*ExemplarsResponse_Data
	//	*ExemplarsResponse_Warning
	Result isExemplarsResponse_Result `protobuf_oneof:"result"`
}

func (m *ExemplarsResponse) Reset()         { *m = ExemplarsResponse{} }
func (m *ExemplarsResponse) String() string { return proto.CompactTextString(m) }
func (*ExemplarsResponse) ProtoMessage()    {}
func (*ExemplarsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd9ad2a40bac3cc9, []int{1}
}
func (m *ExemplarsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExemplarsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExemplarsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExemplarsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExemplarsResponse.Merge(m, src)
}
func (m *ExemplarsResponse) XXX_Size() int {
	return m.Size()
}
func (m *ExemplarsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExemplarsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExemplarsResponse proto.InternalMessageInfo

type isExemplarsResponse_Result interface {
	isExemplarsResponse_Result()
	MarshalTo([]byte) (int, error)
	Size() int
}

type ExemplarsResponse_Data struct {
	Data *ExemplarData `protobuf:"bytes,1,opt,name=data,proto3,oneof" json:"data,omitempty"`
}
type ExemplarsResponse_Warning struct {
	Warning string `protobuf:"bytes,2,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (*ExemplarsResponse_Data) isExemplarsResponse_Result()    {}
func (*ExemplarsResponse_Warning) isExemplarsResponse_Result() {}

func (m *ExemplarsResponse) GetResult() isExemplarsResponse_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *ExemplarsResponse) GetData() *ExemplarData {
	if x, ok := m.GetResult().(*ExemplarsResponse_Data); ok {
		return x.Data
	}
	return nil
}

func (m *ExemplarsResponse) GetWarning() string {
	if x, ok := m.GetResult().(*ExemplarsResponse_Warning); ok {
		return x.Warning
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ExemplarsResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ExemplarsResponse_Data)(nil),
		(*ExemplarsResponse_Warning)(nil),
	}
}

type ExemplarData struct {
	SeriesLabels labelpb.ZLabelSet `protobuf:"bytes,1,opt,name=seriesLabels,proto3" json:"seriesLabels"`
	Exemplars    []*Exemplar       `protobuf:"bytes,2,rep,name=exemplars,proto3" json:"exemplars"`
}

func (m *ExemplarData) Reset()         { *m = ExemplarData{} }
func (m *ExemplarData) String() string { return proto.CompactTextString(m) }
func (*ExemplarData) ProtoMessage()    {}
func (*ExemplarData) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd9ad2a40bac3cc9, []int{2}
}
func (m *ExemplarData) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExemplarData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExemplarData.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExemplarData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExemplarData.Merge(m, src)
}
func (m *ExemplarData) XXX_Size() int {
	return m.Size()
}
func (m *ExemplarData) XXX_DiscardUnknown() {
	xxx_messageInfo_ExemplarData.DiscardUnknown(m)
}

var xxx_messageInfo_ExemplarData proto.InternalMessageInfo

type Exemplar struct {
	Labels labelpb.ZLabelSet `protobuf:"bytes,1,opt,name=labels,proto3" json:"labels"`
	Value  float64           `protobuf:"fixed64,2,opt,name=value,proto3" json:"value"`
	Ts     int64             `protobuf:"varint,3,opt,name=ts,proto3" json:"timestamp"`
}

func (m *Exemplar) Reset()         { *m = Exemplar{} }
func (m *Exemplar) String() string { return proto.CompactTextString(m) }
func (*Exemplar) ProtoMessage()    {}
func (*Exemplar) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd9ad2a40bac3cc9, []int{3}
}
func (m *Exemplar) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Exemplar) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Exemplar.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Exemplar) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Exemplar.Merge(m, src)
}
func (m *Exemplar) XXX_Size() int {
	return m.Size()
}
func (m *Exemplar) XXX_DiscardUnknown() {
	xxx_messageInfo_Exemplar.DiscardUnknown(m)
}

var xxx_messageInfo_Exemplar proto.InternalMessageInfo

func init() {
	proto.RegisterType((*ExemplarsRequest)(nil), "thanos.ExemplarsRequest")
	proto.RegisterType((*ExemplarsResponse)(nil), "thanos.ExemplarsResponse")
	proto.RegisterType((*ExemplarData)(nil), "thanos.ExemplarData")
	proto.RegisterType((*Exemplar)(nil), "thanos.Exemplar")
}

func init() { proto.RegisterFile("exemplars/exemplarspb/rpc.proto", fileDescriptor_fd9ad2a40bac3cc9) }

var fileDescriptor_fd9ad2a40bac3cc9 = []byte{
	// 465 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x93, 0xc1, 0x6e, 0xd3, 0x40,
	0x10, 0x86, 0xbd, 0x49, 0x1b, 0xea, 0x49, 0xa9, 0xd2, 0x55, 0x24, 0x9c, 0x48, 0xd8, 0x51, 0x4e,
	0x81, 0x43, 0x8c, 0xc2, 0x89, 0x03, 0x17, 0x0b, 0xa4, 0x4a, 0x20, 0x81, 0xb6, 0xb7, 0x72, 0xa8,
	0x36, 0x74, 0x14, 0x22, 0x39, 0xf6, 0x76, 0x77, 0x02, 0xe4, 0x01, 0xb8, 0x73, 0xe6, 0x1d, 0x78,
	0x8f, 0x1c, 0x7b, 0xe4, 0x14, 0x41, 0x72, 0xcb, 0x53, 0xa0, 0xec, 0xda, 0x69, 0x1a, 0x55, 0xea,
	0xc5, 0x3b, 0xf3, 0xcf, 0x67, 0xef, 0x3f, 0x3b, 0x6b, 0x88, 0xf0, 0x3b, 0x4e, 0x54, 0x2a, 0xb5,
	0x89, 0xb7, 0x91, 0x1a, 0xc6, 0x5a, 0x7d, 0xee, 0x2b, 0x9d, 0x53, 0xce, 0x6b, 0xf4, 0x45, 0x66,
	0xb9, 0x69, 0xb7, 0x0c, 0xe5, 0x1a, 0x63, 0xfb, 0x54, 0xc3, 0x98, 0x66, 0x0a, 0x8d, 0x43, 0xca,
	0x52, 0x2a, 0x87, 0x98, 0xee, 0x95, 0x9a, 0xa3, 0x7c, 0x94, 0xdb, 0x30, 0xde, 0x44, 0x4e, 0xed,
	0xfe, 0x66, 0xd0, 0x78, 0x5b, 0xee, 0x26, 0xf0, 0x7a, 0x8a, 0x86, 0x78, 0x13, 0x0e, 0xaf, 0xa7,
	0xa8, 0x67, 0x01, 0xeb, 0xb0, 0x9e, 0x2f, 0x5c, 0xb2, 0x51, 0x0d, 0x49, 0x4d, 0x41, 0xa5, 0xc3,
	0x7a, 0x55, 0xe1, 0x12, 0xde, 0x80, 0x2a, 0x66, 0x57, 0x41, 0xd5, 0x6a, 0x9b, 0x90, 0x7f, 0x82,
	0x96, 0x92, 0x9a, 0xc6, 0x32, 0xbd, 0xd4, 0x68, 0x54, 0x9e, 0x19, 0xbc, 0x34, 0xa4, 0x25, 0xe1,
	0x68, 0x16, 0x1c, 0x74, 0x58, 0xef, 0x64, 0x10, 0xf5, 0x5d, 0x2b, 0xfd, 0x8f, 0x0e, 0x14, 0x05,
	0x77, 0x5e, 0x60, 0xe2, 0x89, 0xba, 0xbf, 0xd0, 0x45, 0x38, 0xdd, 0xb1, 0xeb, 0x8a, 0xfc, 0x39,
	0x1c, 0x5c, 0x49, 0x92, 0xd6, 0x6e, 0x7d, 0xd0, 0x2c, 0x3f, 0x5e, 0x82, 0x6f, 0x24, 0xc9, 0x33,
	0x4f, 0x58, 0x86, 0xb7, 0xe1, 0xd1, 0x37, 0xa9, 0xb3, 0x71, 0x36, 0xb2, 0x7d, 0xf8, 0x67, 0x9e,
	0x28, 0x85, 0xe4, 0x08, 0x6a, 0x1a, 0xcd, 0x34, 0xa5, 0xee, 0x2f, 0x06, 0xc7, 0xbb, 0xaf, 0xf3,
	0x77, 0x70, 0x6c, 0x50, 0x8f, 0xd1, 0xbc, 0xdf, 0x1c, 0xad, 0x29, 0xb6, 0x3a, 0x2d, 0xb7, 0xba,
	0xb0, 0xf2, 0x39, 0x52, 0xd2, 0x9c, 0x2f, 0x22, 0x6f, 0xbd, 0x88, 0xee, 0xe0, 0xe2, 0x4e, 0xc6,
	0x5f, 0x83, 0xbf, 0x9d, 0x70, 0x50, 0xe9, 0x54, 0x7b, 0xf5, 0x41, 0x63, 0xdf, 0x74, 0xf2, 0x78,
	0xbd, 0x88, 0x6e, 0x31, 0x71, 0x1b, 0x76, 0x7f, 0x30, 0x38, 0x2a, 0x31, 0xfe, 0x0a, 0x6a, 0xe9,
	0x03, 0x96, 0x4e, 0x0a, 0x4b, 0x05, 0x28, 0x8a, 0x95, 0x47, 0x70, 0xf8, 0x55, 0xa6, 0x53, 0xb4,
	0x07, 0xc1, 0x12, 0x7f, 0xbd, 0x88, 0x9c, 0x20, 0xdc, 0xc2, 0x9f, 0x42, 0x85, 0x8c, 0x1b, 0xad,
	0xb3, 0x43, 0xe3, 0x09, 0x1a, 0x92, 0x13, 0x25, 0x2a, 0x64, 0x06, 0x1f, 0xc0, 0xdf, 0xce, 0x82,
	0x27, 0xbb, 0x49, 0xb0, 0xdf, 0x4d, 0x79, 0xb5, 0xda, 0xad, 0x7b, 0x2a, 0x6e, 0x8a, 0x2f, 0x58,
	0xf2, 0x6c, 0xfe, 0x2f, 0xf4, 0xe6, 0xcb, 0x90, 0xdd, 0x2c, 0x43, 0xf6, 0x77, 0x19, 0xb2, 0x9f,
	0xab, 0xd0, 0xbb, 0x59, 0x85, 0xde, 0x9f, 0x55, 0xe8, 0x5d, 0xd4, 0x77, 0xfe, 0x8a, 0x61, 0xcd,
	0x5e, 0xdf, 0x97, 0xff, 0x03, 0x00, 0x00, 0xff, 0xff, 0x0f, 0x15, 0xe4, 0x68, 0x35, 0x03, 0x00,
	0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ExemplarsClient is the client API for Exemplars service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ExemplarsClient interface {
	/// Exemplars has info for all exemplars.
	/// Returned exemplars are expected to include external labels.
	Exemplars(ctx context.Context, in *ExemplarsRequest, opts ...grpc.CallOption) (Exemplars_ExemplarsClient, error)
}

type exemplarsClient struct {
	cc *grpc.ClientConn
}

func NewExemplarsClient(cc *grpc.ClientConn) ExemplarsClient {
	return &exemplarsClient{cc}
}

func (c *exemplarsClient) Exemplars(ctx context.Context, in *ExemplarsRequest, opts ...grpc.CallOption) (Exemplars_ExemplarsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Exemplars_serviceDesc.Streams[0], "/thanos.Exemplars/Exemplars", opts...)
	if err != nil {
		return nil, err
	}
	x := &exemplarsExemplarsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Exemplars_ExemplarsClient interface {
	Recv() (*ExemplarsResponse, error)
	grpc.ClientStream
}

type exemplarsExemplarsClient struct {
	grpc.ClientStream
}

func (x *exemplarsExemplarsClient) Recv() (*ExemplarsResponse, error) {
	m := new(ExemplarsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// ExemplarsServer is the server API for Exemplars service.
type ExemplarsServer interface {
	/// Exemplars has info for all exemplars.
	/// Returned exemplars are expected to include external labels.
	Exemplars(*ExemplarsRequest, Exemplars_ExemplarsServer) error
}

// UnimplementedExemplarsServer can be embedded to have forward compatible implementations.
type UnimplementedExemplarsServer struct {
}

func (*UnimplementedExemplarsServer) Exemplars(req *ExemplarsRequest, srv Exemplars_ExemplarsServer) error {
	return status.Errorf(codes.Unimplemented, "method Exemplars not implemented")
}

func RegisterExemplarsServer(s *grpc.Server, srv ExemplarsServer) {
	s.RegisterService(&_Exemplars_serviceDesc, srv)
}

func _Exemplars_Exemplars_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ExemplarsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ExemplarsServer).Exemplars(m, &exemplarsExemplarsServer{stream})
}

type Exemplars_ExemplarsServer interface {
	Send(*ExemplarsResponse) error
	grpc.ServerStream
}

type exemplarsExemplarsServer struct {
	grpc.ServerStream
}

func (x *exemplarsExemplarsServer) Send(m *ExemplarsResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _Exemplars_serviceDesc = grpc.ServiceDesc{
	ServiceName: "thanos.Exemplars",
	HandlerType: (*ExemplarsServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Exemplars",
			Handler:       _Exemplars_Exemplars_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "exemplars/exemplarspb/rpc.proto",
}

func (m *ExemplarsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExemplarsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExemplarsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.PartialResponseStrategy != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.PartialResponseStrategy))
		i--
		dAtA[i] = 0x20
	}
	if m.End != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.End))
		i--
		dAtA[i] = 0x18
	}
	if m.Start != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.Start))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Query) > 0 {
		i -= len(m.Query)
		copy(dAtA[i:], m.Query)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.Query)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ExemplarsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExemplarsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExemplarsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Result != nil {
		{
			size := m.Result.Size()
			i -= size
			if _, err := m.Result.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *ExemplarsResponse_Data) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExemplarsResponse_Data) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Data != nil {
		{
			size, err := m.Data.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *ExemplarsResponse_Warning) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExemplarsResponse_Warning) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Warning)
	copy(dAtA[i:], m.Warning)
	i = encodeVarintRpc(dAtA, i, uint64(len(m.Warning)))
	i--
	dAtA[i] = 0x12
	return len(dAtA) - i, nil
}
func (m *ExemplarData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExemplarData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExemplarData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Exemplars) > 0 {
		for iNdEx := len(m.Exemplars) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Exemplars[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRpc(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.SeriesLabels.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintRpc(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *Exemplar) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Exemplar) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Exemplar) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Ts != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.Ts))
		i--
		dAtA[i] = 0x18
	}
	if m.Value != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Value))))
		i--
		dAtA[i] = 0x11
	}
	{
		size, err := m.Labels.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintRpc(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func encodeVarintRpc(dAtA []byte, offset int, v uint64) int {
	offset -= sovRpc(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ExemplarsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	if m.Start != 0 {
		n += 1 + sovRpc(uint64(m.Start))
	}
	if m.End != 0 {
		n += 1 + sovRpc(uint64(m.End))
	}
	if m.PartialResponseStrategy != 0 {
		n += 1 + sovRpc(uint64(m.PartialResponseStrategy))
	}
	return n
}

func (m *ExemplarsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Result != nil {
		n += m.Result.Size()
	}
	return n
}

func (m *ExemplarsResponse_Data) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Data != nil {
		l = m.Data.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	return n
}
func (m *ExemplarsResponse_Warning) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Warning)
	n += 1 + l + sovRpc(uint64(l))
	return n
}
func (m *ExemplarData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.SeriesLabels.Size()
	n += 1 + l + sovRpc(uint64(l))
	if len(m.Exemplars) > 0 {
		for _, e := range m.Exemplars {
			l = e.Size()
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	return n
}

func (m *Exemplar) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Labels.Size()
	n += 1 + l + sovRpc(uint64(l))
	if m.Value != 0 {
		n += 9
	}
	if m.Ts != 0 {
		n += 1 + sovRpc(uint64(m.Ts))
	}
	return n
}

func sovRpc(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozRpc(x uint64) (n int) {
	return sovRpc(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ExemplarsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExemplarsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExemplarsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			m.Start = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Start |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			m.End = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.End |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartialResponseStrategy", wireType)
			}
			m.PartialResponseStrategy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PartialResponseStrategy |= storepb.PartialResponseStrategy(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExemplarsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExemplarsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExemplarsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ExemplarData{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Result = &ExemplarsResponse_Data{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warning", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Result = &ExemplarsResponse_Warning{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExemplarData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExemplarData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExemplarData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SeriesLabels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.SeriesLabels.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exemplars", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Exemplars = append(m.Exemplars, &Exemplar{})
			if err := m.Exemplars[len(m.Exemplars)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Exemplar) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Exemplar: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Exemplar: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Labels.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Value = float64(math.Float64frombits(v))
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ts", wireType)
			}
			m.Ts = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Ts |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRpc(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthRpc
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupRpc
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthRpc
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthRpc        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRpc          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupRpc = fmt.Errorf("proto: unexpected end of group")
)
