#title:分页查询
#index:0,1
----------------------------------------------------------------------------------------
概述
	使用数据库的应用程序，多数情况下都需要使用 {#00A;_“分页”} 这个功能。尤其是在 Web 应用程序中，后端的分页查询尤其的普遍。
	在以往的使用经验中，一个分页查询，除了能获取到一个列表外，我们通常需要如下几个信息才能在客户端显示出一个完整的翻页条。
	 * 当前页数 -- 第几页
	 * 页大小 -- 每页有多少条记录
	 * 总页数 -- 一共多少页
	 * 总记录数 -- 如果不分页，一共有多少条记录
	当我们获得了这四条信息后，对于维护一个翻页查询就足够。

	Nutz.Dao 的查询接口天然就支持分页查询。
----------------------------------------------------------------------------------------
Dao 接口的第三个参数
	让我们先看看 Nutz.Dao 接口查询函数的声明：
	{{{<JAVA>
	<T> List<T> query(Class<T> classOfT, Condition condition, Pager pager);
	}}}
	这个接口有三个参数
	 * classOfT 告诉 Nutz.Dao 需要查询的实体类型
	 * [condition.man condition] 告诉 Nutz.Dao 查询出的列表需要符合的条件。详细请看 [condition.man 复杂条件]。
	 * 最后一个参数，就是告诉 Nutz.Dao 将结果如何分页的了。

	{#FF0000;* Pager 对象有如下几个注意事项：}
	 * 如果 pager 被传入了 null，则不分页
	 * 生成 Pager 对象的时候需要传入 {#00A;“当前页数”} 和 {#00A;“页大小”}
	 * Pager 虽然有 getRecordCount() 和 getPageCount() 方法，但是它不会自动被设值 -- 因为考虑到效率
	 * 通过 Pager.setRecordCount() 可以为 Pager 设置结果集的总数，Pager 会通过 getPageCount() 返回总页数

----------------------------------------------------------------------------------------
将分页信息和查询结果一起返回
	{{{
	public QueryResult getPetList(Dao dao, int pageNumber, int pageSize){
		Pager pager = dao.createPager(pageNumber, pageSize);
		List<Pet> list = dao.query(Pet.class, null, pager);
		pager.setRecordCount(dao.count(Pet.class));
		return new QueryResult(list, pager);
	}
	}}}

    Nutz 会自动为各种不同的数据库，根据你传入的 Pager 生成翻页方言。但是考虑到效率因素，
    Nutz.Dao 并不会为 Pager 计算结果集的总数。我知道这那么一点点让人觉得有点不方便，但是我想给你
    控制权，我想让你可以: "只在必要的时候才计算结果集的总数"，我想，这个控制权对你来说，比少写
    一行CRUD代码更加重要，对吗？

















